/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.spi.util.TypeAccessor;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationLinkHelper {
    private final TypeAccessor typeAccessor;
    private final ManifestRetriever manifestRetriever;

    @Autowired
    public ApplicationLinkHelper(TypeAccessor typeAccessor, ManifestRetriever manifestRetriever) {
        this.typeAccessor = typeAccessor;
        this.manifestRetriever = manifestRetriever;
    }

    public ApplicationId getJiraApplicationId(URI baseUrl) {
        try {
            return this.manifestRetriever.getManifest(baseUrl, this.typeAccessor.getApplicationType(JiraApplicationType.class)).getId();
        }
        catch (ManifestNotFoundException e2) {
            throw new RuntimeException("Unexpected exception while generating an AppLinks manifest for the non-UAL JIRA server at " + baseUrl.toString(), e2);
        }
    }
}

