/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.action;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.actions.RemoteRequestAjaxResponse;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fisheye.jira.JiraExceptionMessage;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.OauthRequestsIgnoredException;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.jira.issue.QueryContext;
import com.atlassian.fisheye.jira.issue.QueryContextImpl;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.UrlHelper;
import com.google.common.base.Strings;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JiraIssueAjaxAction
extends ActionSupport
implements RemoteRequestAjaxResponse,
ServletRequestAware,
ServletResponseAware {
    @Resource
    private JiraIssueService jiraIssueService;
    @Resource
    private ProjectManager projectManager;
    private String key;
    private String projectKey;
    private JiraIssue issue;
    private Integer maxTitleLength;
    private String errorMsg;
    private List<CredentialsRequiredMessage> credentialsRequired = new ArrayList<CredentialsRequiredMessage>();
    private List<JiraExceptionMessage> jiraExceptions = new ArrayList<JiraExceptionMessage>();
    private String successURL;
    private boolean shouldGetIssueMetadata = true;
    private boolean hideIssueTitle;
    private boolean canLogWork;
    private boolean subtasksConfigured;
    private boolean issueIsSubtask;
    private HttpServletRequest request;
    private HttpServletResponse response;
    @Autowired
    protected JiraServerService jiraServerService;
    private static final String NOT_FOUND = "notfound";

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.issue = this.jiraIssueService.getJiraIssue(this.key, this.buildQueryContext(), new RemoteExceptionHandler(){

            @Override
            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
                JiraIssueAjaxAction.this.credentialsRequired.add(JiraIssueUtil.buildCredentialsRequired(jiraServer, cre, false));
            }

            @Override
            public void acceptException(JiraServer jiraServer, Exception e2) {
                JiraIssueAjaxAction.this.jiraExceptions.add(JiraIssueUtil.buildJiraException(jiraServer, e2, false));
            }
        });
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String executeInline() throws Exception {
        this.execute();
        if (this.issue != null && this.shouldGetIssueMetadata) {
            this.canLogWork = this.issue.canLogWork();
            this.subtasksConfigured = this.issue.getJiraServer().getSubtaskConfiguration() != null;
            this.issueIsSubtask = this.issue.isSubTask();
        }
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String redirectToJira() throws IOException {
        RemoteExceptionHandler exceptionHandler = new RemoteExceptionHandler(){

            @Override
            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException credentialsException) {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append(ServletUtils.getBaseUrl(JiraIssueAjaxAction.this.request));
                urlBuilder.append("/action/jira-issue.do");
                UrlHelper helper = new UrlHelper();
                helper.putParam("key", JiraIssueAjaxAction.this.key);
                if (!Strings.isNullOrEmpty((String)JiraIssueAjaxAction.this.projectKey)) {
                    helper.putParam("projectKey", JiraIssueAjaxAction.this.projectKey);
                }
                urlBuilder.append(helper.getParamString());
                try {
                    URI fisheyeCallbackUri = new URI(urlBuilder.toString());
                    URI oAuthUri = credentialsException.getAuthorisationURI(fisheyeCallbackUri);
                    JiraIssueAjaxAction.this.response.sendRedirect(oAuthUri.toString());
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }

            @Override
            public void acceptException(JiraServer jiraServer, Exception e2) {
                if (!(e2 instanceof NotPermittedException)) {
                    JiraIssueAjaxAction.this.jiraExceptions.add(JiraIssueUtil.buildJiraException(jiraServer, e2, false));
                }
            }
        };
        QueryContext context = this.buildQueryContext();
        ArrayList<JiraServer> servers = new ArrayList<JiraServer>();
        for (JiraServer server : context.getJiraServers()) {
            servers.add(server);
        }
        if (servers.size() == 1) {
            this.successURL = ((JiraServer)servers.get(0)).getDisplayUrl() + "/browse/" + this.key;
            return "success";
        }
        this.issue = this.jiraIssueService.getJiraIssue(this.key, context, exceptionHandler);
        if (this.issue != null) {
            this.successURL = this.issue.getDisplayUrl();
            return "success";
        }
        if (!Strings.isNullOrEmpty((String)this.errorMsg)) {
            return "error";
        }
        return NOT_FOUND;
    }

    public String getSuccessURL() {
        return this.successURL;
    }

    public boolean isCanLogWork() {
        return this.canLogWork;
    }

    private QueryContext buildQueryContext() {
        QueryContextImpl.Builder builder = QueryContextImpl.Builder.newInstance(this.jiraServerService);
        if (!Strings.isNullOrEmpty((String)this.projectKey)) {
            builder.project(this.getProject());
        }
        return builder.build();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public Integer getMaxTitleLength() {
        return this.maxTitleLength;
    }

    public void setMaxTitleLength(Integer maxTitleLength) {
        this.maxTitleLength = maxTitleLength;
    }

    public boolean isShouldGetIssueMetadata() {
        return this.shouldGetIssueMetadata;
    }

    public void setShouldGetIssueMetadata(boolean shouldGetIssueMetadata) {
        this.shouldGetIssueMetadata = shouldGetIssueMetadata;
    }

    public boolean isHideIssueTitle() {
        return this.hideIssueTitle;
    }

    public void setHideIssueTitle(boolean hideIssueTitle) {
        this.hideIssueTitle = hideIssueTitle;
    }

    public JiraIssue getIssue() {
        return this.issue;
    }

    public Project getProject() {
        return this.projectManager.getProjectByKey(this.projectKey);
    }

    public String getJiraIssueUrl() {
        Project project;
        if (this.issue != null) {
            return this.issue.getDisplayUrl();
        }
        if (!Strings.isNullOrEmpty((String)this.projectKey) && (project = this.getProject()) != null) {
            return this.jiraIssueService.getJiraIssueUrl(this.key, project);
        }
        return null;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isError() {
        return StringUtils.isNotBlank((String)this.errorMsg);
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    @Override
    public List<CredentialsRequiredMessage> getCredentialsRequired() {
        return this.credentialsRequired;
    }

    @Override
    public List<JiraExceptionMessage> getJiraExceptions() {
        return this.jiraExceptions;
    }

    public boolean isNotFound() {
        return this.getException() instanceof NotPermittedException;
    }

    @Override
    public boolean isOauthIgnored() {
        return this.getException() instanceof OauthRequestsIgnoredException;
    }

    @Override
    public Exception getException() {
        return this.getJiraExceptions().isEmpty() ? null : this.getJiraExceptions().get(0).getOriginalException();
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public boolean isIssueIsSubtask() {
        return this.issueIsSubtask;
    }

    public boolean isSubtasksConfigured() {
        return this.subtasksConfigured;
    }
}

