/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerFactory;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="jiraServerService")
@AvailableToPlugins
public class JiraServerServiceImpl
implements JiraServerService,
DisposableBean,
InitializingBean {
    private final ApplicationLinkService applicationLinkService;
    private final EntityLinkService entityLinkService;
    private final JiraServerFactory jiraServerFactory;
    private EventPublisher eventPublisher;
    private final ResettableLazyReference<Boolean> hasJiraApplicationLink = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return JiraServerServiceImpl.this.getAllJiraApplinks().iterator().hasNext();
        }
    };
    private List<JiraServer> jiraServerCache = new ArrayList<JiraServer>();

    @Autowired
    public JiraServerServiceImpl(ApplicationLinkService applicationLinkService, EntityLinkService entityLinkService, JiraServerFactory jiraServerFactory, EventPublisher eventPublisher) {
        this.applicationLinkService = applicationLinkService;
        this.entityLinkService = entityLinkService;
        this.jiraServerFactory = jiraServerFactory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public JiraServer getJiraServer(ApplicationId applicationId) {
        for (JiraServer server : this.getJiraServers()) {
            if (!applicationId.equals((Object)server.getApplicationLink().getId())) continue;
            return server;
        }
        return null;
    }

    @Override
    public Iterable<JiraServer> getJiraServers() {
        return this.asJiraServers(this.getAllJiraApplinks());
    }

    private Iterable<ApplicationLink> getAllJiraApplinks() {
        return this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
    }

    private Iterable<ApplicationLink> appendRemainingAppLinks(Iterable<ApplicationLink> appLinksForEntity) {
        LinkedHashSet appLinks = Sets.newLinkedHashSet(appLinksForEntity);
        Iterable<ApplicationLink> allAppLinks = this.getAllJiraApplinks();
        for (ApplicationLink appLink : allAppLinks) {
            appLinks.add(appLink);
        }
        return appLinks;
    }

    @Override
    public Iterable<JiraServer> getJiraServersPrioritised(Project project) {
        Iterable<ApplicationLink> appLinksForEntity = this.aggregateJiraServers(this.entityLinkService.getEntityLinks((Object)project, JiraProjectEntityType.class));
        return this.asJiraServers(this.appendRemainingAppLinks(appLinksForEntity));
    }

    @Override
    public Iterable<JiraServer> getJiraServersPrioritised(RepositoryHandle repository) {
        Iterable<ApplicationLink> appLinksForEntity = this.aggregateJiraServers(this.entityLinkService.getEntityLinks((Object)repository, JiraProjectEntityType.class));
        return this.asJiraServers(this.appendRemainingAppLinks(appLinksForEntity));
    }

    @Override
    public Iterable<JiraServer> getLinkedJiraServers(Project project) {
        return this.asJiraServers(this.aggregateJiraServers(this.entityLinkService.getEntityLinks((Object)project, JiraProjectEntityType.class)));
    }

    @Override
    public Iterable<JiraServer> getLinkedJiraServers(RepositoryHandle repository) {
        return this.asJiraServers(this.aggregateJiraServers(this.entityLinkService.getEntityLinks((Object)repository, JiraProjectEntityType.class)));
    }

    private Iterable<ApplicationLink> aggregateJiraServers(Iterable<EntityLink> entityLinks) {
        ObjectLinkedOpenHashSet applicationLinks = new ObjectLinkedOpenHashSet();
        for (EntityLink entityLink : entityLinks) {
            applicationLinks.add(entityLink.getApplicationLink());
        }
        return applicationLinks;
    }

    private Iterable<JiraServer> asJiraServers(Iterable<ApplicationLink> applicationLinks) {
        ArrayList<JiraServer> updatedCache = new ArrayList<JiraServer>();
        for (ApplicationLink jiraLink : applicationLinks) {
            boolean matched = false;
            for (JiraServer storedServer : this.jiraServerCache) {
                if (!storedServer.getApplicationLink().equals(jiraLink)) continue;
                updatedCache.add(storedServer);
                matched = true;
                break;
            }
            if (matched) continue;
            updatedCache.add(this.jiraServerFactory.getJiraServer(jiraLink));
        }
        this.jiraServerCache = updatedCache;
        return ImmutableList.copyOf(this.jiraServerCache);
    }

    @Override
    public boolean hasJiraApplicationLink() {
        return (Boolean)this.hasJiraApplicationLink.get();
    }

    @EventListener
    public void onCreateApplink(ApplicationLinkAddedEvent event) {
        this.hasJiraApplicationLink.reset();
    }

    @EventListener
    public void onDeleteApplink(ApplicationLinkDeletedEvent event) {
        this.hasJiraApplicationLink.reset();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

