/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fisheye.jira.JiraExceptionMessage;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JiraIssueUtil {
    private static final Pattern PROJECT_PATTERN = Pattern.compile("^(.*)-\\d+$");
    private static final String JIRA_ISSUE_REGEXP_BASE = "(([A-Z][A-Z_0-9]{1,49})-\\d{1,9})";
    public static final String JIRA_ISSUE_REGEXP_LIBERAL = "(?i)(?:[^A-Z_]|^)(([A-Z][A-Z_0-9]{1,49})-\\d{1,9})";
    public static final String JIRA_ISSUE_REGEXP = "(?i)(?:[^-\\w]|^)(([A-Z][A-Z_0-9]{1,49})-\\d{1,9})";
    public static final Pattern JIRA_ISSUE_PATTERN = Pattern.compile("(?i)(?:[^-\\w]|^)(([A-Z][A-Z_0-9]{1,49})-\\d{1,9})");
    public static final Pattern JIRA_ISSUE_PATTERN_LIBERAL = Pattern.compile("(?i)(?:[^A-Z_]|^)(([A-Z][A-Z_0-9]{1,49})-\\d{1,9})");
    public static final Function<String, Option<String>> ISSUE_KEY_TO_PROJECT_KEY = new Function<String, Option<String>>(){

        public Option<String> apply(@Nullable String issueKey) {
            return issueKey == null ? Option.none() : JiraIssueUtil.getProjectKey(issueKey);
        }
    };

    private JiraIssueUtil() {
    }

    public static Option<String> getProjectKey(@Nonnull String jiraIssueKey) {
        Matcher m2 = PROJECT_PATTERN.matcher(jiraIssueKey);
        if (m2.find()) {
            return Option.option((Object)m2.group(1));
        }
        return Option.none();
    }

    public static List<String> getJiraKeysFromString(String message) {
        return JiraIssueUtil.getJiraKeysFromString(message, JIRA_ISSUE_PATTERN);
    }

    public static List<String> getJiraKeysFromStringLiberally(String message) {
        return JiraIssueUtil.getJiraKeysFromString(message, JIRA_ISSUE_PATTERN_LIBERAL);
    }

    private static List<String> getJiraKeysFromString(String message, Pattern pattern) {
        ArrayList<String> hits = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)message)) {
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String jiraKey = matcher.group(1);
                hits.add(jiraKey.toUpperCase(Locale.US));
            }
        }
        return hits;
    }

    public static CredentialsRequiredMessage buildCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre, boolean useHtml) {
        String messageHtml = String.format(useHtml ? "The JIRA server <strong>%s</strong> requires credentials." : "The JIRA server %s requires credentials.", jiraServer.getEscapedName());
        return new CredentialsRequiredMessage(jiraServer.getApplicationLink(), messageHtml, cre.getAuthorisationURI());
    }

    public static JiraExceptionMessage buildJiraException(JiraServer jiraServer, Exception e2, boolean useHtml) {
        String jiraErrorMessage = e2.getMessage() == null ? null : e2.getMessage().replaceFirst("^com\\.atlassian([^\\s:])+:\\s+", "");
        String errorMessage = JiraIssueUtil.generateErrorMessage(jiraServer, jiraErrorMessage, false);
        Logs.APP_LOG.debug((Object)errorMessage, (Throwable)e2);
        if (useHtml) {
            errorMessage = JiraIssueUtil.generateErrorMessage(jiraServer, jiraErrorMessage, true);
        }
        return new JiraExceptionMessage(e2, errorMessage, jiraServer);
    }

    private static String generateErrorMessage(JiraServer jiraServer, String errorMessage, boolean useHtml) {
        if (errorMessage == null) {
            return null;
        }
        if (useHtml) {
            return String.format("JIRA Server <strong>%s</strong>: %s", jiraServer.getEscapedName(), ExpressionUtil.escapeString(errorMessage));
        }
        return String.format("JIRA Server %s: %s", jiraServer.getApplicationLink().getName(), errorMessage);
    }
}

