/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira;

import java.util.Comparator;

public class JiraField
implements Comparable<JiraField> {
    public static final Comparator<JiraField> NAME_COMPARATOR = new Comparator<JiraField>(){

        @Override
        public int compare(JiraField o1, JiraField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Integer id;
    private final String name;
    private final String icon;

    public JiraField(Integer id, String name, String icon) {
        this.id = id;
        this.name = name;
        this.icon = icon;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIconUrl() {
        return this.icon;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        JiraField jiraField = (JiraField)o2;
        return !(this.id != null ? !this.id.equals(jiraField.id) : jiraField.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    @Override
    public int compareTo(JiraField o2) {
        return this.getId() - o2.getId();
    }

    public static enum Type {
        TYPE("type"),
        SUBTASK_TYPE("subtask_type"),
        RESOLUTION("resolution"),
        STATUS("status");

        private final String fieldName;

        private Type(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

