/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.db;

import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.hg.client.HgCommitDetails;
import com.atlassian.fisheye.hg.client.HgDiffInfo;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Strings;
import java.io.IOException;

public class MergeCommitIndex {
    private final InfinityDbHandle dbh;
    private final CommonStringTables commonStringTables;
    private static final I ENTITY = DvcsSchema.Hg.E_MERGE_COMMIT;
    private static final String NULL_COMMIT = "0000000000000000000000000000000000000000";

    public void insert(HgDiffInfo hgDiffInfo, HgCommitDetails commitDetails) throws DbException {
        if (!commitDetails.isMergeFromFirstParent(hgDiffInfo)) {
            this.insert(commitDetails.getCommitHash(), hgDiffInfo.getToPath(), hgDiffInfo.getCommit(), hgDiffInfo.getMergeReplaceCommit());
        }
    }

    public MergeCommitIndex(InfinityDbHandle dbh, CommonStringTables commonStringTables) {
        this.dbh = dbh;
        this.commonStringTables = commonStringTables;
    }

    private synchronized void insert(String commit, String path, String fileCommit, String mergeReplaceCommit) throws DbException {
        try {
            long id = this.getCommitId(commit);
            IndexEntry entry = new IndexEntry(id, commit, path, fileCommit, mergeReplaceCommit);
            y cu = entry.getCu();
            this.dbh.get().b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visit(long startId, Visitor visitor) throws DbException {
        y cu = y.a().a(ENTITY);
        int len = cu.e();
        cu.b(startId);
        ac db = this.dbh.get();
        try {
            boolean keepGoing;
            while (db.a(cu, len) && (keepGoing = visitor.visit(new IndexEntry(cu)))) {
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long getPathId(String path) throws DbException {
        return this.commonStringTables.pathDB.find(path);
    }

    private String getPathName(long l2) throws DbException {
        return this.commonStringTables.pathDB.get(l2);
    }

    private long getCommitId(String commitHash) throws DbException {
        if (Strings.isNullOrEmpty((String)commitHash)) {
            return this.commonStringTables.changeSetIdDB.add(NULL_COMMIT);
        }
        long id = this.commonStringTables.changeSetIdDB.find(commitHash);
        if (id == -1L) {
            Logs.APP_LOG.debug((Object)("Could not find commit " + commitHash));
            id = this.commonStringTables.changeSetIdDB.add(commitHash);
        }
        return id;
    }

    private String getCommitHash(long id) throws DbException {
        return this.commonStringTables.changeSetIdDB.get(id);
    }

    public void visitRevisions(long commitId, Visitor visitor) throws DbException {
        y cu = y.a().a(ENTITY);
        cu.b(commitId);
        int len = cu.e();
        ac db = this.dbh.get();
        try {
            while (db.a(cu, len)) {
                visitor.visit(new IndexEntry(cu));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public class IndexEntry {
        public final long id;
        public final String commit;
        public final String path;
        public final String fileCommit;
        public final String mergeReplaceCommit;

        public IndexEntry(y cu) throws DbException {
            int len = y.a().a(ENTITY).e();
            this.id = cu.v(len);
            this.commit = MergeCommitIndex.this.getCommitHash(this.id);
            len = cu.w(len);
            this.path = MergeCommitIndex.this.getPathName(cu.v(len));
            len = cu.w(len);
            this.fileCommit = MergeCommitIndex.this.getCommitHash(cu.v(len));
            len = cu.w(len);
            this.mergeReplaceCommit = MergeCommitIndex.this.getCommitHash(cu.v(len));
        }

        public IndexEntry(long id, String commit, String path, String fileCommit, String mergeReplaceCommit) {
            this.id = id;
            this.commit = commit;
            this.path = path;
            this.fileCommit = fileCommit;
            this.mergeReplaceCommit = mergeReplaceCommit;
        }

        public y getCu() throws DbException {
            y cu = y.a();
            cu.a(ENTITY).b(this.id).b(MergeCommitIndex.this.getPathId(this.path)).b(MergeCommitIndex.this.getCommitId(this.fileCommit)).b(MergeCommitIndex.this.getCommitId(this.mergeReplaceCommit));
            return cu;
        }

        public boolean isAdd() {
            return MergeCommitIndex.NULL_COMMIT.equals(this.mergeReplaceCommit);
        }

        public String toString() {
            return "IndexEntry{id=" + this.id + ", commit='" + this.commit + '\'' + ", path='" + this.path + '\'' + ", fileCommit='" + this.fileCommit + '\'' + ", mergeReplaceCommit='" + this.mergeReplaceCommit + '\'' + '}';
        }

        public boolean isReplace() {
            return !MergeCommitIndex.NULL_COMMIT.equals(this.mergeReplaceCommit);
        }
    }

    public static interface Visitor {
        public boolean visit(IndexEntry var1) throws DbException;
    }
}

