/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.db;

import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;

public class HgRevInfoDAO
extends DvcsRevInfoDAO<HgRevInfo, CommonStringTables> {
    public HgRevInfoDAO(String repositoryName, InfinityDbHandle dbh, CommonStringTables stringTables, LicenseEnforcer licenseEnforcer) {
        super(repositoryName, dbh, stringTables, licenseEnforcer);
    }

    @Override
    public HgRevInfo load(int revid) throws DbException {
        HgRevInfo revInfo = null;
        if (this.commonDAO.exists(revid)) {
            try {
                revInfo = new HgRevInfo();
                this.commonDAO.load(revid, revInfo);
                revInfo.setAdjustedDate(this.commonDAO.getLongProperty(DvcsSchema.Hg.E_DATE_ADJUSTED, revid, 0L));
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Exception", (Throwable)e2);
                revInfo = null;
            }
        }
        return revInfo;
    }

    @Override
    public int insertNew(HgRevInfo revInfo, AncestorLink ancestorLink, boolean storeDiffs) throws DbException, LicensePolicyException {
        int revid = super.insertNew(revInfo, ancestorLink, storeDiffs);
        long commitId = this.stringTables.changeSetIdDB.add(revInfo.getChangeSetId());
        this.commonDAO.addPathLongProperty(DvcsSchema.I_PATHID_COMMIT, revInfo.getPath(), revInfo.getDate(), commitId);
        long pathId = this.commonDAO.getPathId(revInfo.getPath());
        this.commonDAO.addRevIdLongProperty(DvcsSchema.I_REVID_PATHID, revid, pathId);
        this.commonDAO.addRevIdLongProperty(DvcsSchema.Hg.E_DATE_ADJUSTED, revid, revInfo.getAdjustedDate());
        return revid;
    }

    @Override
    public int getRevId(Path path, String commit) throws DbException {
        if (commit == null) {
            return -1;
        }
        return this.commonDAO.getRevId(path, commit);
    }
}

