/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.db;

import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.atlassian.fisheye.hg.db.HgRevInfoDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;

public class HgChangeSetDAO
extends DvcsChangeSetDAO<HgRevInfo, HgChangeSet, CommonStringTables> {
    private static final Predicate<Tag> NOT_TIP_PREDICATE = Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"tip")), Tag.TO_NAME);

    public HgChangeSetDAO(RepositoryStatus status, InfinityDbHandle dbh, CommonStringTables stringTables, HgRevInfoDAO revDAO, LicenseEnforcer licenseEnforcer) {
        super(status, dbh, stringTables, revDAO, licenseEnforcer);
    }

    @Override
    public HgChangeSet createChangeSet(String csid) {
        return new HgChangeSet(csid, this, (HgRevInfoDAO)this.fileRevDAO);
    }

    @Override
    protected void loadAttributes(EavEntityCu eav, HgChangeSet changeset) throws DbException, IOException {
        super.loadAttributes(eav, changeset);
        long subBranchId = eav.getLong(DvcsSchema.Hg.HgChangeSetInfo.A_SUB_BRANCH, 0L);
        String subBranch = this.stringTables.changeSetIdDB.get(subBranchId);
        changeset.setSubBranch(subBranch, subBranchId);
        long adjustedDate = eav.getLong(DvcsSchema.Hg.HgChangeSetInfo.A_DATE_ADJUSTED, 0L);
        changeset.setAdjustedDate(adjustedDate);
    }

    @Override
    protected void storeAttributes(EavEntityCu eav, long csDbId, HgChangeSet changeset) throws DbException, IOException {
        super.storeAttributes(eav, csDbId, changeset);
        eav.updateLong(DvcsSchema.Hg.HgChangeSetInfo.A_SUB_BRANCH, this.stringTables.changeSetIdDB.find(changeset.getSubBranch()));
        eav.updateLong(DvcsSchema.Hg.HgChangeSetInfo.A_DATE_ADJUSTED, changeset.getAdjustedDate());
    }

    public long getSubBranchId(String changeSetId) throws DbException {
        EavEntityCu eav = this.makeEav(this.stringTables.changeSetIdDB.find(changeSetId));
        try {
            return eav.getLong(DvcsSchema.Hg.HgChangeSetInfo.A_SUB_BRANCH, 0L);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Set<Tag> getAllTags() throws DbException {
        return Sets.filter(super.getAllTags(), NOT_TIP_PREDICATE);
    }
}

