/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.db;

import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;

public class BranchPointCommitIndex {
    private InfinityDbHandle dbh;
    private CommonStringTables stringTables;
    private static final I ENTITY = DvcsSchema.Hg.E_BRANCH_TAIL;
    private static final I INDEX = DvcsSchema.Hg.I_BRANCH_TAIL;

    public BranchPointCommitIndex(InfinityDbHandle dbh, CommonStringTables stringTables) {
        this.dbh = dbh;
        this.stringTables = stringTables;
    }

    private void addBranchPoint(long branchName, long hashCommitOnBranch, long hashCommitBeforeBranch) throws DbException {
        try {
            y cu = y.a();
            cu.a(ENTITY).b(hashCommitOnBranch).b(branchName).b(hashCommitBeforeBranch);
            this.dbh.get().b(cu);
            cu.f().a(INDEX).b(branchName).b(hashCommitOnBranch);
            this.dbh.get().b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addBranchPoint(String branchName, String hashCommitOnBranch, String hashCommitBeforeBranch) throws DbException {
        this.addBranchPoint(this.addBranchId(branchName), this.addCommitId(hashCommitOnBranch), this.addCommitId(hashCommitBeforeBranch));
    }

    public boolean isBranchPointIndexed(String branch) throws DbException {
        y cu = y.a();
        long branchId = this.getBranchId(branch);
        cu.a(INDEX).b(branchId);
        try {
            return this.dbh.get().a(cu, cu.e());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long getBranchId(String branch) throws DbException {
        return this.stringTables.branchDB.find(branch);
    }

    private long addBranchId(String branch) throws DbException {
        return this.stringTables.branchDB.add(branch);
    }

    private String getBranchName(long id) throws DbException {
        return this.stringTables.branchDB.get(id);
    }

    private long addCommitId(String commitHash) throws DbException {
        return this.stringTables.changeSetIdDB.add(commitHash);
    }

    private String getCommitHash(long id) throws DbException {
        return this.stringTables.changeSetIdDB.get(id);
    }

    public IndexEntry getCommit(long id) throws DbException {
        y cu = y.a().a(ENTITY).b(id);
        ac db = this.dbh.get();
        try {
            if (db.a(cu, cu.e())) {
                return new IndexEntry(cu);
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public static interface Visitor {
        public void visit(IndexEntry var1) throws DbException;
    }

    public class IndexEntry {
        public final long id;
        public final String branch;
        public final String commitHash;
        public final String parentCommitHash;

        public IndexEntry(y cu) throws DbException {
            int len = y.a().a(ENTITY).e();
            this.id = cu.v(len);
            this.commitHash = BranchPointCommitIndex.this.getCommitHash(this.id);
            len = cu.w(len);
            this.branch = BranchPointCommitIndex.this.getBranchName(cu.v(len));
            len = cu.w(len);
            this.parentCommitHash = BranchPointCommitIndex.this.getCommitHash(cu.v(len));
        }
    }
}

