/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HgListBranchesOutputHandler
extends BaseLineOutputHandler {
    private static final Pattern BRANCHSTATE_PATTERN = Pattern.compile("(.*?)(\\d+:(\\w{12}))\\s*(\\((inactive|closed)\\))?");
    private static final int NAME_GROUP = 1;
    private static final int HEAD_GROUP = 3;
    private static final int STATUS_GROUP = 5;
    private Set<Branch> branches = new HashSet<Branch>();

    public HgListBranchesOutputHandler(Charset encoding, String loggingContext) {
        super(encoding, loggingContext);
    }

    protected void processLine(int lineNum, String line) {
        Matcher matcher = BRANCHSTATE_PATTERN.matcher(line);
        if (matcher.matches()) {
            String branchname = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)branchname)) {
                Branch branch = new Branch(branchname, matcher.group(3), BranchState.ACTIVE);
                if (matcher.groupCount() >= 5) {
                    if ("closed".equals(matcher.group(5))) {
                        branch.setState(BranchState.CLOSED);
                    } else if ("inactive".equals(matcher.group(5))) {
                        branch.setState(BranchState.INACTIVE);
                    }
                }
                this.branches.add(branch);
            }
        } else {
            this.reportNonMatchingLine(line);
        }
    }

    public Set<Branch> getBranches() {
        return this.branches;
    }
}

