/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.impl.CommonChangeInfo;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class HgDiffInfo
extends CommonChangeInfo {
    private String toPath;
    private GitDiffInfo gitDiffInfo;
    private Mode mode;
    private long fileSize;
    private boolean binary;
    private List<FileParent> parents = null;
    private String fromPath;
    private String commit;
    private String mergeParent;
    private String mergeReplaceCommit;

    public HgDiffInfo() {
    }

    public HgDiffInfo(String path) {
        this.toPath = path;
    }

    @Override
    public int getNumAdded() {
        return this.gitDiffInfo != null ? this.gitDiffInfo.getNumAdded() : 0;
    }

    @Override
    public int getNumRemoved() {
        return this.gitDiffInfo != null ? this.gitDiffInfo.getNumRemoved() : 0;
    }

    public String getToPath() {
        return this.toPath;
    }

    @Override
    public String toString() {
        return "HgDiffInfo - " + this.toPath;
    }

    @Override
    public String toStringChild() {
        return this.toString();
    }

    public void setGitDiffInfo(GitDiffInfo gitDiffInfo) {
        this.gitDiffInfo = gitDiffInfo;
    }

    public void setFileAction(String fileAction) {
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)(this.toPath + ": " + fileAction));
        }
        if (fileAction == null) {
            throw new IllegalArgumentException("fileAction cannot be null");
        }
        if (fileAction.equals("Added")) {
            this.mode = Mode.ADDED;
        } else if (fileAction.equals("Modified") || fileAction.equals("MetaChange")) {
            this.mode = Mode.MODIFIED;
        } else if (fileAction.equals("Deleted")) {
            this.mode = Mode.DELETED;
        } else if (fileAction.startsWith("Copy from")) {
            this.mode = Mode.COPIED;
            this.fromPath = fileAction.substring(10).trim();
        } else if (fileAction.startsWith("Move from")) {
            this.mode = Mode.MOVED;
            this.fromPath = fileAction.substring(10).trim();
        } else if (fileAction.equals("Merged")) {
            this.mode = Mode.MERGED;
        } else {
            throw new IllegalArgumentException("unknown fileAction: " + fileAction);
        }
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void addFileParent(FileParent fileParent) {
        if (this.parents == null) {
            this.parents = new LinkedList<FileParent>();
        }
        this.parents.add(fileParent);
    }

    public List<FileParent> getFileParents() {
        if (this.parents == null) {
            return Collections.emptyList();
        }
        return this.parents;
    }

    public boolean isNewlyAdded() {
        return this.mode == Mode.ADDED;
    }

    public boolean isChanged() {
        return this.gitDiffInfo != null && !this.isNewlyAdded();
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getFromPath() {
        if (this.isModification() || this.isDeletion()) {
            return this.toPath;
        }
        return this.fromPath;
    }

    public boolean isCopy() {
        return this.gitDiffInfo != null && this.gitDiffInfo.isCopy();
    }

    public boolean isMove() {
        return this.gitDiffInfo != null && this.gitDiffInfo.isMove();
    }

    @Override
    public List<Hunk> getHunks() {
        if (this.gitDiffInfo == null) {
            return Collections.emptyList();
        }
        return this.gitDiffInfo.getHunks();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isModification() {
        return this.mode == Mode.MODIFIED;
    }

    public boolean isDeletion() {
        return this.mode == Mode.DELETED;
    }

    @Override
    public File getTmpDiffAddedFile() {
        if (this.gitDiffInfo == null) {
            return null;
        }
        return this.gitDiffInfo.getTmpDiffAddedFile();
    }

    @Override
    public File getTmpDiffRemovedFile() {
        if (this.gitDiffInfo == null) {
            return null;
        }
        return this.gitDiffInfo.getTmpDiffRemovedFile();
    }

    public void setCommit(String s2) {
        this.commit = s2;
    }

    public String getCommit() {
        return this.commit;
    }

    public void setMergeParent(String mergeParent) {
        this.mergeParent = mergeParent;
    }

    public String getMergeParent() {
        return this.mergeParent;
    }

    public boolean isMerge() {
        return this.mode == Mode.MERGED;
    }

    public void setMergeReplaceCommit(String mergeReplaceCommit) {
        this.mergeReplaceCommit = mergeReplaceCommit;
    }

    public String getMergeReplaceCommit() {
        return this.mergeReplaceCommit;
    }

    private static enum Mode {
        MODIFIED,
        ADDED,
        DELETED,
        MOVED,
        COPIED,
        MERGED;

    }

    public static class FileParent {
        private final String path;
        private final String commitHash;

        public FileParent(String path, String commitHash) {
            this.path = path;
            this.commitHash = commitHash;
        }

        public String getCommitHash() {
            return this.commitHash;
        }

        public String getPath() {
            return this.path;
        }
    }
}

