/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.dvcs.client.LineCountOutputHandler;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.dvcs.handler.LineArrayOutputHandler;
import com.atlassian.fisheye.hg.HgScmConfig;
import com.atlassian.fisheye.hg.client.HgCommandBuilder;
import com.atlassian.fisheye.hg.client.HgListBranchesOutputHandler;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.SafeExternalProcessBuilder;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.rep.VersionHandler;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class HgContext
extends DvcsContext {
    public static final String HG_VERSION_PATTERN_STRING = "version\\s([\\d\\.\\+]+)";
    private static final long TIMEOUT_VERSION_COMMAND_MS = 120000L;
    private HgScmConfig hgConfig;
    private Charset charset = Charset.forName("utf8");

    public HgContext(RepositoryConfig config) {
        super(config);
        this.hgConfig = (HgScmConfig)config.getScmConfig();
    }

    @Override
    public DvcsScmConfig getScmConfig() {
        return this.hgConfig;
    }

    public String getTip() throws DvcsProcessException {
        HgCommandBuilder command = HgCommandBuilder.createLogTipCommand();
        LineArrayOutputHandler handler = new LineArrayOutputHandler(this.getEncoding());
        this.executeCommand((DvcsCommandBuilder)command, (OutputHandler)handler);
        List<String> logTipOutput = handler.getLines();
        return !logTipOutput.isEmpty() ? logTipOutput.get(0) : null;
    }

    @Override
    public String getMainBranchName() {
        return "default";
    }

    protected Charset getEncoding() {
        return ((HgScmConfig)this.getConfig().getScmConfig()).getEncoding();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Version determineHgVersion() throws ConfigException {
        return HgContext.determineHgVersion(this.getScmConfig().getExecutable());
    }

    public int getLineCountForFileRevisionFromClient(Path filePath, String revision) throws DvcsProcessException {
        HgCommandBuilder command = new HgCommandBuilder("cat", filePath.toString(), "-r", revision);
        LineCountOutputHandler lcHandler = new LineCountOutputHandler();
        this.executeCommand((DvcsCommandBuilder)command, (OutputHandler)lcHandler);
        return lcHandler.getLineCount();
    }

    @Override
    public Set<Branch> getBranchesInLocalRepo() throws DvcsProcessException {
        HgCommandBuilder listBranches = HgCommandBuilder.createListBranchesCommand();
        HgListBranchesOutputHandler handler = new HgListBranchesOutputHandler(this.getEncoding(), listBranches.toString());
        this.executeCommand((DvcsCommandBuilder)listBranches, (OutputHandler)handler);
        return handler.getBranches();
    }

    public static Version determineHgVersion(String hgExecutable) throws ConfigException {
        VersionHandler handler = new VersionHandler(HG_VERSION_PATTERN_STRING);
        ExternalProcess process = new SafeExternalProcessBuilder().command(Arrays.asList(hgExecutable, "version")).idleTimeout(120000L).handlers((OutputHandler)handler).log(Logs.APP_LOG, (Priority)Level.DEBUG).build();
        process.execute();
        if (process.getHandler().succeeded()) {
            if (handler.getVersionString() != null) {
                return new Version(handler.getVersionString());
            }
            throw new ConfigException("No version string found in output of " + OBFUSCATOR.obfuscate(process.getCommandLine()));
        }
        throw new ConfigException("Unable to get hg version. Ensure that hg is installed and on your PATH", process.getHandler().getException());
    }
}

