/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.dvcs.client.DvcsCommitDetails;
import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.atlassian.fisheye.hg.client.HgDiffInfo;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class HgCommitDetails
extends DvcsCommitDetails {
    private int rev;
    private String[] tags;
    private String description = "";
    private List<HgDiffInfo> diffInfoList = new ArrayList<HgDiffInfo>();
    private HgDiffInfo currentDiff;
    private long adjustedDate;

    public HgCommitDetails(String commitHash) {
        this.commitHash = commitHash;
    }

    public HgCommitDetails() {
    }

    public void setRev(int rev) {
        this.rev = rev;
    }

    public void setParents(String[] strings) {
        this.parents = Arrays.asList(strings);
    }

    public void setDate(long date) {
        this.date = new Date(date);
    }

    public void setTags(String tags) {
        if (!Strings.isNullOrEmpty((String)tags)) {
            this.tags = tags.split(" ");
        }
    }

    public String[] getTags() {
        if (this.tags == null) {
            this.tags = new String[0];
        }
        return this.tags;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addDescriptionLine(String line) {
        this.description = this.description + "\n" + line;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRev() {
        return this.rev;
    }

    public List<HgDiffInfo> getDiffInfoList() {
        return this.diffInfoList;
    }

    public void addPath(String path) {
        this.currentDiff = new HgDiffInfo(path);
        this.currentDiff.setCommit(this.getCommitHash());
        this.diffInfoList.add(this.currentDiff);
    }

    public String getCurrentPath() {
        return this.currentDiff.getToPath();
    }

    public void setFileType(String fileType) {
        this.currentDiff.setFileAction(fileType);
    }

    public void setBinary(boolean binary) {
        this.currentDiff.setBinary(binary);
    }

    public void setFileSize(long bytes) {
        this.currentDiff.setFileSize(bytes);
    }

    public void addFileParent(HgDiffInfo.FileParent parent) {
        this.currentDiff.addFileParent(parent);
    }

    public void addGitDiffInfo(GitDiffInfo diffInfo) {
        this.currentDiff.setGitDiffInfo(diffInfo);
    }

    public String toString() {
        return this.rev + ":" + this.commitHash.substring(0, 12);
    }

    public void setMergedFileRevision(String s2) {
        this.currentDiff.setCommit(s2);
    }

    public void setMergeParent(String s2) {
        this.currentDiff.setMergeParent(s2);
    }

    public List<HgDiffInfo> getFilesAddedInMerge() {
        ArrayList<HgDiffInfo> addedFiles = new ArrayList<HgDiffInfo>();
        for (HgDiffInfo e2 : this.diffInfoList) {
            if (!e2.isMerge() || this.isMergeFromFirstParent(e2)) continue;
            addedFiles.add(e2);
        }
        return addedFiles;
    }

    public boolean isMergeFromFirstParent(HgDiffInfo hgDiffInfo) {
        return ((String)this.parents.get(0)).equals(hgDiffInfo.getMergeParent());
    }

    public void setMergeReplaceCommit(String mergeReplaceCommit) {
        this.currentDiff.setMergeReplaceCommit(mergeReplaceCommit);
    }

    public boolean isOnlyMerges() {
        for (HgDiffInfo e2 : this.diffInfoList) {
            if (e2.isMerge()) continue;
            return false;
        }
        return true;
    }

    public void setAdjustedDate(long adjustedDate) {
        this.adjustedDate = adjustedDate;
    }

    public long getAdjustedDate() {
        return this.adjustedDate;
    }
}

