/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HgCommandBuilder
implements DvcsCommandBuilder {
    public static final String PYTHON_HG_HGFELOG = "python/hg/hgfelog";
    private static String feLogScriptPath = null;
    private String[] command;
    private String startRev;
    private String template;
    private String branch;
    private String endRev;
    private String rev;
    private boolean verbose = false;
    private boolean includeClosedBranches = false;
    private Map<String, String> extensions = new HashMap<String, String>();
    private boolean patch = false;
    private boolean gitPatch = false;
    private String path;
    private boolean listCommitHash;
    private boolean listFileName;
    private boolean listLineNumber;
    private String source;
    private String destination;
    private boolean includeMergeInfo;
    private String spaceEscapedPathToSshWrapper;

    protected HgCommandBuilder(String ... command) {
        this.command = command;
    }

    private HgCommandBuilder startRev(String startRev) {
        this.startRev = startRev;
        return this;
    }

    private HgCommandBuilder template(String template) {
        this.template = template;
        return this;
    }

    private HgCommandBuilder branch(String branch) {
        this.branch = branch;
        return this;
    }

    private HgCommandBuilder patch(boolean patch) {
        this.patch = patch;
        return this;
    }

    private HgCommandBuilder endRev(String endRev) {
        this.endRev = endRev;
        return this;
    }

    private HgCommandBuilder rev(String rev) {
        this.rev = rev;
        return this;
    }

    public HgCommandBuilder setSshCommand(String spaceEscapedPathToSsh) {
        this.spaceEscapedPathToSshWrapper = spaceEscapedPathToSsh;
        return this;
    }

    private HgCommandBuilder verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    private HgCommandBuilder gitPatch(boolean gitPatch) {
        this.gitPatch = gitPatch;
        return this;
    }

    private HgCommandBuilder extension(String extension, String file) {
        this.extensions.put(extension, file);
        return this;
    }

    @Override
    public List<String> createCommand() {
        LinkedList commandArgs = Lists.newLinkedList();
        for (Map.Entry<String, String> extEntry : this.extensions.entrySet()) {
            commandArgs.add("--config");
            commandArgs.add("extensions." + extEntry.getKey() + "=" + extEntry.getValue());
        }
        if (!this.verbose) {
            commandArgs.add("--config");
            commandArgs.add("ui.verbose=false");
        } else {
            commandArgs.add("-v");
        }
        Collections.addAll(commandArgs, this.command);
        if (this.rev != null) {
            commandArgs.add("-r");
            commandArgs.add(this.rev);
        } else if (this.startRev != null || this.endRev != null) {
            commandArgs.add("-r");
            StringBuilder sb = new StringBuilder();
            if (this.startRev != null) {
                sb.append(this.startRev);
            }
            sb.append(":");
            if (this.endRev != null) {
                sb.append(this.endRev);
            }
            commandArgs.add(sb.toString());
        }
        if (!Strings.isNullOrEmpty((String)this.spaceEscapedPathToSshWrapper)) {
            commandArgs.addAll(HgCommandBuilder.getAuthCommand(this.spaceEscapedPathToSshWrapper));
        }
        if (this.template != null) {
            commandArgs.add("--template");
            commandArgs.add(this.template);
        }
        if (this.branch != null) {
            commandArgs.add("-b");
            commandArgs.add(this.branch);
        }
        if (this.gitPatch) {
            commandArgs.add("-pg");
        } else if (this.patch) {
            commandArgs.add("-p");
        }
        if (this.listCommitHash) {
            commandArgs.add("-c");
        }
        if (this.listFileName) {
            commandArgs.add("-f");
        }
        if (this.listLineNumber) {
            commandArgs.add("-l");
        }
        if (this.source != null) {
            commandArgs.add(this.source);
            if (this.destination != null) {
                commandArgs.add(this.destination);
            }
        } else if (this.path != null) {
            commandArgs.add(this.path);
        }
        if (this.includeMergeInfo) {
            commandArgs.add("-m");
        }
        if (this.includeClosedBranches) {
            commandArgs.add("-c");
        }
        return commandArgs;
    }

    public String toString() {
        return this.createCommand().toString();
    }

    public static HgCommandBuilder createListCommitsCommand(String currentIndexed) {
        return new HgCommandBuilder("log").startRev(currentIndexed != null ? currentIndexed : "0").template("{rev}\\t{node}\\t{parents}\\n");
    }

    public static HgCommandBuilder createListBranchCommitsCommand(String currentIndexed, String branch) {
        if (branch == null) {
            throw new NullPointerException("branch cannot be null");
        }
        return new HgCommandBuilder("log").branch(branch).startRev(currentIndexed != null ? currentIndexed : "0").template("{rev}\\t{node}\\t{parents}\\n");
    }

    public static HgCommandBuilder createContentCommand(String path, String changeSetId) {
        HgCommandBuilder builder = new HgCommandBuilder("cat");
        builder.rev(changeSetId).path(path);
        return builder;
    }

    private HgCommandBuilder path(String path) {
        this.path = path;
        return this;
    }

    public static HgCommandBuilder createBlameCommand(RevInfoKey revInfoKey) {
        HgCommandBuilder builder = new HgCommandBuilder("annotate");
        builder.path(revInfoKey.getPath().getPath()).rev(revInfoKey.getRev()).listCommitHash(true).listFileName(true).listLineNumber(true);
        return builder;
    }

    public static HgCommandBuilder createLogTipCommand() {
        return HgCommandBuilder.createLogCommand("tip");
    }

    public static HgCommandBuilder createFilePredecessorsCommand(String commitHash, String parentPath) {
        String escapedPath = parentPath.replaceAll("'", "\\\\'");
        String revSpec = String.format("last(::p1(%1$s) and file('%2$s')) or last(::p2(%1$s) and file('%2$s'))", commitHash, escapedPath);
        return HgCommandBuilder.createLogCommand(revSpec);
    }

    public static HgCommandBuilder createLogCommand(String revspec) {
        HgCommandBuilder builder = new HgCommandBuilder("log");
        builder.rev(revspec);
        builder.template("{node}\\n");
        return builder;
    }

    private HgCommandBuilder listCommitHash(boolean b2) {
        this.listCommitHash = b2;
        return this;
    }

    private HgCommandBuilder listFileName(boolean b2) {
        this.listFileName = b2;
        return this;
    }

    private HgCommandBuilder listLineNumber(boolean b2) {
        this.listLineNumber = b2;
        return this;
    }

    private static List<String> getAuthCommand(String spaceEscapedSshPath) {
        ArrayList<String> commands = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)spaceEscapedSshPath)) {
            commands.add("-e");
            commands.add(spaceEscapedSshPath);
        }
        return commands;
    }

    public static HgCommandBuilder createCloneCommand(String remoteLocation, String name) {
        return HgCommandBuilder.createCloneCommandInner(remoteLocation, name);
    }

    public static HgCommandBuilder createTestCloneCommand(String remoteLocation, File dir) {
        return HgCommandBuilder.createCloneCommandInner(remoteLocation, dir.getAbsolutePath(), "0");
    }

    private static HgCommandBuilder createCloneCommandInner(String remoteLocation, String destination) {
        return HgCommandBuilder.createCloneCommandInner(remoteLocation, destination, null);
    }

    private static HgCommandBuilder createCloneCommandInner(String remoteLocation, String destination, String rev) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("clone");
        commands.add("--noupdate");
        HgCommandBuilder builder = new HgCommandBuilder(commands.toArray(new String[commands.size()]));
        builder.source(remoteLocation).destination(destination);
        if (rev != null) {
            builder.rev(rev);
        }
        return builder;
    }

    private HgCommandBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    private HgCommandBuilder source(String source) {
        this.source = source;
        return this;
    }

    private HgCommandBuilder includeMergeInfo(boolean b2) {
        this.includeMergeInfo = b2;
        return this;
    }

    private HgCommandBuilder includeClosedBranches(boolean includeClosedBranches) {
        this.includeClosedBranches = includeClosedBranches;
        return this;
    }

    protected static String getFeLogScriptPath() {
        if (feLogScriptPath == null) {
            feLogScriptPath = new File(AppConfig.getAppHome().getAbsolutePath(), "python/hg/hgfelog/hgfelog.py").getAbsolutePath();
        }
        return feLogScriptPath;
    }

    public static HgCommandBuilder createFeLogCommand(String commit) {
        return new HgCommandBuilder("felog", commit).extension("felog", HgCommandBuilder.getFeLogScriptPath()).patch(true).includeMergeInfo(true);
    }

    public static HgCommandBuilder createPullCommand(String remoteLocation) {
        return new HgCommandBuilder("pull").source(remoteLocation);
    }

    public static HgCommandBuilder createListTagsCommand() {
        return new HgCommandBuilder("tags", "--debug");
    }

    public static HgCommandBuilder createListFileRevsCommand(String forCommitRev) {
        return new HgCommandBuilder("feparents", forCommitRev).verbose(true).extension("felog", HgCommandBuilder.getFeLogScriptPath());
    }

    public static HgCommandBuilder createListBranchesCommand() {
        return new HgCommandBuilder("branches").includeClosedBranches(true);
    }

    public static HgCommandBuilder createInitCommand() {
        return new HgCommandBuilder("init");
    }
}

