/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.ManifestDAO;
import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.hg.client.HgCommandBuilder;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgChangeSetDAO;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.atlassian.fisheye.hg.db.HgRevInfoDAO;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HgClientManifestDAO
implements ManifestDAO<HgRevInfo> {
    static final Pattern FEPARENTS_PATTERN = Pattern.compile("(\\d+):([0-9a-fA-F]{40}) (.+?)");
    private HgContext hgContext;
    private HgRevInfoDAO fileRevDAO;
    private HgChangeSetDAO changeSetDAO;

    public HgClientManifestDAO(HgContext context, HgRevInfoDAO fileRevDAO, HgChangeSetDAO csDAO) {
        this.hgContext = context;
        this.changeSetDAO = csDAO;
        this.fileRevDAO = fileRevDAO;
    }

    @Override
    public Manifest<HgRevInfo> load(String csid) throws DbException {
        HgChangeSet cs = (HgChangeSet)this.changeSetDAO.load(csid);
        return new Manifest<HgRevInfo>(cs, this);
    }

    @Override
    public void visitRevisions(final String csid, final Visitor<HgRevInfo> visitor) throws DbException {
        try {
            this.hgContext.executeCommand((DvcsCommandBuilder)HgCommandBuilder.createListFileRevsCommand(csid), (OutputHandler)new BaseLineOutputHandler(this.hgContext.getScmConfig().getEncoding()){

                protected void processLine(int lineNum, String line) {
                    Matcher matcher = FEPARENTS_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        Path path = new Path(matcher.group(3));
                        if (HgClientManifestDAO.this.hgContext.isPathInRepo(path)) {
                            HgRevInfo fileRev = (HgRevInfo)HgClientManifestDAO.this.fileRevDAO.loadLazy(new RevInfoKey(path, matcher.group(2)));
                            if (fileRev != null) {
                                visitor.visit(fileRev);
                            } else {
                                Logs.APP_LOG.warn((Object)("While resolving manifest " + csid + ".Cannot find file revision in index: path = " + path + ", revision = " + matcher.group(2)));
                            }
                        }
                    } else {
                        Logs.APP_LOG.warn((Object)("Cannot parse output line [" + line + "]"));
                    }
                }
            });
        }
        catch (DvcsProcessException e2) {
            throw new DbException(e2);
        }
    }
}

