/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.dvcs.client.DvcsChangeParser;
import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.atlassian.fisheye.hg.client.HgCommitDetails;
import com.atlassian.fisheye.hg.client.HgDiffInfo;
import com.atlassian.fisheye.hg.client.HgDiffOutputHandler;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.base.Strings;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class HgChangeParser
extends DvcsChangeParser {
    private static final String HASH_REGEX = "([0-9a-fA-F]{40})";
    private static final String COMMIT_REGEX = "C:([0-9a-fA-F]{40})";
    private static final String PARENTS_REGEX = "((([0-9a-fA-F]{40})( |))*)";
    private static final String FILE_PARENTS_REGEX = "([0-9a-fA-F]{40}) (.*)$";
    private static final String IN_GIT_DIFF_PREFIX = "FD:";
    private ParserState state = ParserState.COMMIT;
    private String previousLine = null;
    private HgCommitDetails commitDetails = new HgCommitDetails();
    private DiffTextCache diffTextCache;
    private static final ParserState FIRST_LINE_OF_FILE_BLOCK = ParserState.FILES;
    private HgDiffOutputHandler hgDiffParser;
    private final AllowRules allowRules;

    public HgChangeParser(Charset encoding, RepositoryStatus status, DiffTextCache diffTextCache, AllowRules allowRules) {
        super(encoding, status, false);
        this.diffTextCache = diffTextCache;
        this.allowRules = allowRules;
    }

    protected void processLine(int lineNum, String line) throws DbException {
        if (this.getStatus().isStopRequested()) {
            this.cancelProcess();
            throw new RuntimeException("Repository is stopping");
        }
        if (Logs.APP_LOG.isTraceEnabled()) {
            Logs.APP_LOG.trace((Object)line);
        }
        if ((this.state == ParserState.DESC || this.state == ParserState.IN_DESC) && line.matches(ParserState.PARENTS.pattern.pattern())) {
            this.state = ParserState.PARENTS;
        }
        if (line.matches(FIRST_LINE_OF_FILE_BLOCK.pattern.pattern()) && this.state == ParserState.IN_GIT_DIFF) {
            if (this.state == ParserState.IN_GIT_DIFF && this.hgDiffParser != null) {
                this.hgDiffParser.complete();
                this.hgDiffParser = null;
            }
            this.state = FIRST_LINE_OF_FILE_BLOCK;
        }
        if (line.matches(COMMIT_REGEX) && this.state != ParserState.COMMIT) {
            Logs.APP_LOG.error((Object)("Missed commit statement " + line + " while in state " + (Object)((Object)this.state)));
            this.state = ParserState.COMMIT;
        }
        if (this.state == ParserState.IN_GIT_DIFF) {
            if (this.hgDiffParser == null) {
                this.hgDiffParser = new HgDiffOutputHandler(this.getStatus(), this.getEncodingCharset(), this.allowRules.isIgnored(new Path(this.commitDetails.getCurrentPath())) ? null : this.diffTextCache){

                    @Override
                    protected void processDiffInfo(GitDiffInfo diffInfo) {
                        HgChangeParser.this.commitDetails.addGitDiffInfo(diffInfo);
                    }
                };
            }
            this.hgDiffParser.processLine(lineNum, line.substring(IN_GIT_DIFF_PREFIX.length()));
        } else {
            Matcher matcher = this.state.pattern.matcher(line);
            if (!matcher.matches()) {
                if (this.state.isOptional) {
                    this.state = this.state.nextState;
                    this.processLine(lineNum, line);
                    return;
                }
                throw new RuntimeException("Match failed: string [" + line + "], pattern [" + this.state.pattern + "]");
            }
            this.state.processMatch(this.commitDetails, matcher);
            this.state = this.state.nextState;
        }
        if (Logs.APP_LOG.isTraceEnabled()) {
            Logs.APP_LOG.trace((Object)("final state: " + (Object)((Object)this.state)));
        }
    }

    private void handleCommit() throws DbException {
        if (this.hgDiffParser != null) {
            this.hgDiffParser.complete();
            this.hgDiffParser = null;
        }
        if (this.commitDetails != null && this.commitDetails.getRev() != -1) {
            this.processCommit(this.commitDetails);
        }
        this.resetParser();
    }

    public void resetParser() {
        this.state = ParserState.COMMIT;
        this.commitDetails = new HgCommitDetails();
    }

    protected void processInputEnd(int lineCount) throws DbException {
        this.handleCommit();
    }

    protected void processEndByException(int lineCount) throws DbException {
        if (this.state == ParserState.IN_GIT_DIFF) {
            this.handleCommit();
        }
    }

    protected abstract boolean processCommit(HgCommitDetails var1) throws DbException;

    private static enum ParserState {
        IN_GIT_DIFF(Pattern.compile("FD:(.*)", 32)){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
            }
        }
        ,
        FP1(Pattern.compile("FP1:([0-9a-fA-F]{40}) (.*)$"), IN_GIT_DIFF, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                this.processFileParentMatch(commitDetails, matcher);
            }
        }
        ,
        FP0(Pattern.compile("FP0:([0-9a-fA-F]{40}) (.*)$"), FP1, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                this.processFileParentMatch(commitDetails, matcher);
            }
        }
        ,
        FB(Pattern.compile("FB:(.*)", 32), FP0, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setBinary(Boolean.parseBoolean(matcher.group(1)));
            }
        }
        ,
        FF(Pattern.compile("FF:(.*)", 32), FB, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
            }
        }
        ,
        FS(Pattern.compile("FS:(.*)", 32), FF, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setFileSize(Long.parseLong(matcher.group(1)));
            }
        }
        ,
        FE(Pattern.compile("FE:(.*)", 32), FS, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setMergeReplaceCommit(matcher.group(1));
            }
        }
        ,
        FM(Pattern.compile("FM:(.*)", 32), FE, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setMergeParent(matcher.group(1));
            }
        }
        ,
        FT(Pattern.compile("FT:(.*)", 32), FM){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setFileType(matcher.group(1));
            }
        }
        ,
        FR(Pattern.compile("FR:(.*)", 32), FT, true){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setMergedFileRevision(matcher.group(1));
            }
        }
        ,
        FILES(Pattern.compile("F:(.*)", 32), FR){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.addPath(matcher.group(1));
            }
        }
        ,
        PARENTS(Pattern.compile("P:((([0-9a-fA-F]{40})( |))*)"), FILES){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                String parents = matcher.group(1);
                if (!Strings.isNullOrEmpty((String)parents)) {
                    commitDetails.setParents(parents.split(" "));
                }
            }
        }
        ,
        IN_DESC(Pattern.compile("M:(.*)", 32)){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.addDescriptionLine(matcher.group(1));
            }
        }
        ,
        DESC(Pattern.compile("M:(.*)", 32), IN_DESC){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setDescription(matcher.group(1));
            }
        }
        ,
        TAGS(Pattern.compile("T:(.*)", 32), DESC){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setTags(matcher.group(1));
            }
        }
        ,
        DATE(Pattern.compile("D:([0-9]*)(\\.[0-9]*(-[0-9]*|))?"), TAGS){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setDate(1000L * Long.parseLong(matcher.group(1)));
            }
        }
        ,
        AUTHOR(Pattern.compile("A:(.*)", 32), DATE){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setAuthor(matcher.group(1));
            }
        }
        ,
        BRANCHES(Pattern.compile("B:(.*)", 32), AUTHOR){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setBranch(matcher.group(1));
            }
        }
        ,
        REV(Pattern.compile("R:(-?[0-9]*)", 32), BRANCHES){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setRev(Integer.parseInt(matcher.group(1)));
            }
        }
        ,
        COMMIT(Pattern.compile("C:([0-9a-fA-F]{40})"), REV){

            @Override
            void processMatch(HgCommitDetails commitDetails, Matcher matcher) {
                commitDetails.setCommitHash(matcher.group(1));
            }
        };

        private final Pattern pattern;
        private final ParserState nextState;
        private final boolean isOptional;

        private ParserState(Pattern pattern) {
            this(pattern, (ParserState)null);
        }

        private ParserState(Pattern pattern, ParserState rev) {
            this(pattern, rev, false);
        }

        private ParserState(Pattern pattern, ParserState rev, boolean isOptional) {
            this.pattern = pattern;
            this.nextState = rev == null ? this : rev;
            this.isOptional = isOptional;
        }

        abstract void processMatch(HgCommitDetails var1, Matcher var2);

        void processFileParentMatch(HgCommitDetails commitDetails, Matcher matcher) {
            String parentHash = matcher.group(1);
            String parentPath = matcher.group(2);
            if (!Strings.isNullOrEmpty((String)parentHash) && !Strings.isNullOrEmpty((String)parentPath)) {
                HgDiffInfo.FileParent parent = new HgDiffInfo.FileParent(parentPath, parentHash);
                commitDetails.addFileParent(parent);
            }
        }

        public String toString() {
            return super.toString() + "(r:\"" + this.pattern.pattern() + "\";next:" + this.nextState.name();
        }
    }
}

