/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.cenqua.fisheye.rep.DbException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class HgBlameParser
extends BaseLineOutputHandler {
    private static final Pattern BLAME_PATTERN = Pattern.compile("\\s*([0-9a-fA-F]{12})\\s*(.+?):\\s*(\\d+):.*?", 32);
    private int length;
    private int lineNum = 0;
    private String filename;
    private String commit;
    private int chunkStartLineOriginal;
    private int chunkStartLineCurrent;

    public HgBlameParser(Charset encoding) {
        super(encoding);
    }

    protected void processLine(int lineNum, String line) throws DbException {
        this.processChunkLine(line);
    }

    private void processChunkLine(String line) throws DbException {
        Matcher matcher = BLAME_PATTERN.matcher(line);
        if (matcher.matches()) {
            ++this.lineNum;
            String commit = matcher.group(1);
            String filename = matcher.group(2);
            int originalLine = Integer.parseInt(matcher.group(3));
            if (commit.equals(this.commit) && filename.equals(this.filename) && originalLine == this.chunkStartLineOriginal + this.length) {
                ++this.length;
            } else {
                if (this.commit != null) {
                    this.endChunk(this.commit, this.filename, this.chunkStartLineOriginal, this.chunkStartLineCurrent, this.length);
                }
                this.commit = commit;
                this.filename = filename;
                this.chunkStartLineOriginal = originalLine;
                this.chunkStartLineCurrent = this.lineNum;
                this.length = 1;
            }
        } else {
            throw new RuntimeException("Failed to match line " + line + " using pattern: " + BLAME_PATTERN);
        }
    }

    protected abstract void endChunk(String var1, String var2, int var3, int var4, int var5) throws DbException;

    protected void processInputEnd(int lineCount) throws DbException {
        if (this.commit != null) {
            this.endChunk(this.commit, this.filename, this.chunkStartLineOriginal, this.chunkStartLineCurrent, this.length);
        }
    }
}

