/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.hg.HgSubBranch;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;

public class SubBranchDAO {
    private final CommonStringTables stringTables;
    private final InfinityDbHandle dbh;

    public SubBranchDAO(InfinityDbHandle dbh, CommonStringTables stringTables) {
        this.dbh = dbh;
        this.stringTables = stringTables;
    }

    public void save(HgSubBranch subBranch) throws DbException {
        long i2 = this.stringTables.changeSetIdDB.find(subBranch.getId());
        try {
            EavEntityCu eav = this.makeSubBranchEav(i2);
            eav.updateLong(DvcsSchema.SubBranchInfo.A_PARENT_ID, this.stringTables.changeSetIdDB.find(subBranch.getParentCommit()));
            eav.updateLong(DvcsSchema.SubBranchInfo.A_MERGE_ID, this.stringTables.changeSetIdDB.find(subBranch.getEndingMergeCommit()));
            eav.updateLong(DvcsSchema.SubBranchInfo.A_LAST_ON_BRANCH_ID, this.stringTables.changeSetIdDB.find(subBranch.getLastCommitOnBranch()));
            eav.updateLong(DvcsSchema.SubBranchInfo.A_PARENT_SUBBRANCH_ID, subBranch.getParentSubBranchId());
            LongIterator longIterator = subBranch.getChildSubBranchIds().iterator();
            while (longIterator.hasNext()) {
                long childSubBranchId = (Long)longIterator.next();
                eav.addNoDupLong(DvcsSchema.SubBranchInfo.A_CHILD_SUBBRANCH_IDS, childSubBranchId);
            }
            eav = this.makeSubBranchEav(subBranch.getParentSubBranchId());
            eav.addNoDupLong(DvcsSchema.SubBranchInfo.A_CHILD_SUBBRANCH_IDS, i2);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public HgSubBranch load(long subBranch) throws DbException {
        return this.load(this.stringTables.changeSetIdDB.get(subBranch));
    }

    public HgSubBranch load(String id) throws DbException {
        if (Strings.isNullOrEmpty((String)id)) {
            return null;
        }
        long i2 = this.stringTables.changeSetIdDB.find(id);
        if (i2 == -1L || i2 == 0L) {
            return null;
        }
        EavEntityCu eav = this.makeSubBranchEav(i2);
        try {
            if (!eav.exists()) {
                return null;
            }
            long defaultId = this.stringTables.changeSetIdDB.find(null);
            long parentId = eav.getLong(DvcsSchema.SubBranchInfo.A_PARENT_ID, defaultId);
            long mergeId = eav.getLong(DvcsSchema.SubBranchInfo.A_MERGE_ID, defaultId);
            long lastOnBranchId = eav.getLong(DvcsSchema.SubBranchInfo.A_LAST_ON_BRANCH_ID, defaultId);
            long parentSubBranchId = eav.getLong(DvcsSchema.SubBranchInfo.A_PARENT_SUBBRANCH_ID, defaultId);
            LongList childSubBranchIds = eav.getLongs(DvcsSchema.SubBranchInfo.A_CHILD_SUBBRANCH_IDS);
            return new HgSubBranch(id, this.stringTables.changeSetIdDB.get(parentId), this.stringTables.changeSetIdDB.get(mergeId), this.stringTables.changeSetIdDB.get(lastOnBranchId), parentSubBranchId, childSubBranchIds);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected EavEntityCu makeSubBranchEav(long csid) throws DbException {
        ac db = this.dbh.get();
        return new EavEntityCu(db, DvcsSchema.SubBranchInfo.ENTITY, csid);
    }
}

