/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;

public class HgSubBranch {
    private final String id;
    private final String parentCommit;
    private String endingMergeCommit = null;
    private String lastCommitOnBranch = null;
    private long parentSubBranchId;
    private LongSet childSubBranchIds;

    public HgSubBranch(String id, String parentCommit, long parentSubBranchId) {
        this(id, parentCommit, null, id, parentSubBranchId, null);
    }

    public HgSubBranch(String id, String parentCommit, String endingMergeCommit, String lastOnBranch, long parentSubBranchId, LongList childSubBranchIds) {
        this.id = id;
        this.parentCommit = this.replaceWithNullIfZeroHash(parentCommit);
        this.endingMergeCommit = this.replaceWithNullIfZeroHash(endingMergeCommit);
        this.lastCommitOnBranch = this.replaceWithNullIfZeroHash(lastOnBranch);
        this.parentSubBranchId = parentSubBranchId;
        this.childSubBranchIds = childSubBranchIds == null ? new LongOpenHashSet() : new LongOpenHashSet((LongCollection)childSubBranchIds);
    }

    public String getParentCommit() {
        return this.parentCommit;
    }

    public String getEndingMergeCommit() {
        return this.endingMergeCommit;
    }

    public void setEndingMergeCommit(String endingMergeCommit, String lastCommitOnBranch) {
        this.endingMergeCommit = this.replaceWithNullIfZeroHash(endingMergeCommit);
        this.lastCommitOnBranch = this.replaceWithNullIfZeroHash(lastCommitOnBranch);
    }

    private String replaceWithNullIfZeroHash(String hash) {
        return "0000000000000000000000000000000000000000".equals(hash) ? null : hash;
    }

    private String replaceWithZeroHashIfNull(String hash) {
        return hash == null ? "0000000000000000000000000000000000000000" : hash;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "HgSubBranch{id='" + this.id + '\'' + ", parentCommit='" + this.parentCommit + '\'' + ", endingMergeCommit='" + this.endingMergeCommit + '\'' + ", lastCommitOnBranch='" + this.lastCommitOnBranch + '\'' + ", parentSubBranchId=" + this.parentSubBranchId + ", childSubBranchIds=" + this.childSubBranchIds + '}';
    }

    public String getLastCommitOnBranch() {
        return this.lastCommitOnBranch;
    }

    public long getParentSubBranchId() {
        return this.parentSubBranchId;
    }

    public void setParentSubBranchId(long parentSubBranchId) {
        this.parentSubBranchId = parentSubBranchId;
    }

    public LongSet getChildSubBranchIds() {
        return this.childSubBranchIds;
    }

    public void setChildSubBranchIds(LongSet childSubBranchIds) {
        this.childSubBranchIds = childSubBranchIds;
    }

    public void setLastCommitOnBranch(String lastCommitOnBranch) {
        this.lastCommitOnBranch = lastCommitOnBranch;
    }
}

