/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fecru.security.Credentials;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.security.SshWrapper;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.client.HgCommandBuilder;
import com.atlassian.fisheye.hg.client.HgProcessFactory;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.StringProcessHandler;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.IntervalUtils;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.apache.commons.lang.StringUtils;

public class HgScmConfig
extends DvcsScmConfig {
    private static final String HG_DEFAULT_EXECUTABLE = "hg";
    private static final long TEST_CONNECTION_TIMEOUT = 60000L;
    public static final int CACHE_VERSION = 12;
    private HgRepType hgConfig;
    private FileSystemUtils fileSystemUtils;

    public HgScmConfig(String name, RootConfig rootConfig, RepositorySystemType scmConfig, SshKeyManager sshKeyManager, HgProcessFactory hgProcessFactory) {
        super(12, rootConfig, sshKeyManager, hgProcessFactory);
        this.hgConfig = (HgRepType)scmConfig;
        if (this.hgConfig == null) {
            throw new IllegalStateException(name + " did not contain expected <hg> element");
        }
        this.reloadUpdateSettings();
        this.setLocation(this.hgConfig.getLocation());
        if (this.hgConfig.isSetBlocksize()) {
            this.setBlockSize(this.hgConfig.getBlocksize().intValue());
        } else {
            this.setBlockSize(HgScmConfig.getDefaultBlockSize());
        }
        if (this.hgConfig.isSetCommandTimeout() && !Strings.isNullOrEmpty((String)this.hgConfig.getCommandTimeout().trim())) {
            String commandTimeoutStr = this.hgConfig.getCommandTimeout();
            try {
                this.setCommandTimeout(new Interval(commandTimeoutStr));
            }
            catch (NumberFormatException e2) {
                this.setConfigException("Command timeout interval is not valid: " + commandTimeoutStr);
            }
        } else {
            this.setCommandTimeout(HgScmConfig.getDefaultCommandTimeout());
        }
        this.setEncoding(this.determineEncoding());
    }

    @Override
    public void reloadUpdateSettings() {
        String pollPeriodString = this.hgConfig.isSetUpdater() ? this.hgConfig.getUpdater().getPollPeriod() : null;
        this.setPollPeriod(IntervalUtils.convertStringToLongOrNever(pollPeriodString, this.getDefaultPollPeriod()));
    }

    @Override
    public Credentials getCredentials() {
        if (this.hgConfig.isSetPasswordAuth()) {
            return this.createCredentials(this.hgConfig.getPasswordAuth());
        }
        if (this.hgConfig.isSetSshAuth()) {
            return this.createCredentials(this.hgConfig.getSshAuth());
        }
        return null;
    }

    @Override
    public HgRepositoryEngine createRepositoryEngine(RepositoryConfig repoConfig, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        return new HgRepositoryEngine(repoConfig, upgradeManager, indexingContext);
    }

    public FileSystemUtils getFileSystemUtils() {
        if (this.fileSystemUtils == null) {
            this.fileSystemUtils = (FileSystemUtils)SpringContext.getComponent("fileSystemUtils");
        }
        return this.fileSystemUtils;
    }

    @Override
    public void testConnection(RepositoryConfig config) throws ConfigException {
        File dir = new File(AppConfig.getTempDir(), "hg_test_clone_" + System.currentTimeMillis());
        try {
            IOHelper.mkdirs(dir);
            StringProcessHandler processHandler = new StringProcessHandler();
            try {
                HgCommandBuilder command = HgCommandBuilder.createTestCloneCommand(this.getRemoteLocationWithCredentials(), dir);
                if (this.isSshAuthenticatedRepo()) {
                    command.setSshCommand(this.getFileSystemUtils().spaceEscapeFilePath(SshWrapper.getSshWrapperCmd(false)));
                }
                this.executeCommand(command, (PluggableProcessHandler)processHandler, 60000L, new ProcessMonitor[0]);
            }
            catch (ProcessTimeoutException e2) {
                String message = DvcsContext.OBFUSCATOR.obfuscate("The operation timed out while connecting to the repository. The server may be waiting for a password.\n" + processHandler.getOutput());
                throw new ConfigException(message, e2);
            }
            catch (ProcessException e3) {
                String message = DvcsContext.OBFUSCATOR.obfuscate("Error talking to repository: \n" + processHandler.getOutput() + "\n" + processHandler.getError());
                throw new ConfigException(message, e3);
            }
        }
        catch (IOException e4) {
            throw new ConfigException("Could not create test hg clone", e4);
        }
        finally {
            IOHelper.recursiveDelete(dir, Integer.MAX_VALUE, true);
        }
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.HG;
    }

    @Override
    public String getExecutable() {
        ConfigDocument.Config serverConfig = this.getRootConfig().getConfig();
        if (serverConfig != null && serverConfig.isSetHgConfig() && serverConfig.getHgConfig().getHgExecutable() != null) {
            return serverConfig.getHgConfig().getHgExecutable();
        }
        return HG_DEFAULT_EXECUTABLE;
    }

    public Charset determineEncoding() {
        String hgEncodingString = System.getenv("HGENCODING");
        Charset hgEncoding = null;
        Charset defaultEncoding = Charset.defaultCharset();
        if (!StringUtils.isBlank((String)hgEncodingString)) {
            if (Charset.isSupported(hgEncodingString)) {
                try {
                    hgEncoding = Charset.forName(hgEncodingString);
                    if (!hgEncoding.equals(Charset.defaultCharset())) {
                        Logs.APP_LOG.warn((Object)("HGENCODING is set, but is different from the default encoding used by Java. This will cause encoding issues for filenames, branches and tags that have non-ASCII characters in them . The issue can be corrected by adding a -Dfile.encoding=" + hgEncoding.name() + " parameter to the FishEye/Crucible startup."));
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {}
            } else {
                Logs.APP_LOG.warn((Object)("HGENCODING is set, but doesn't refer to a known encoding " + hgEncoding + "; using " + defaultEncoding));
                hgEncoding = defaultEncoding;
            }
        } else {
            hgEncoding = defaultEncoding;
        }
        return hgEncoding;
    }
}

