/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fecru.security.SshWrapper;
import com.atlassian.fisheye.dvcs.DvcsScanner;
import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessRuntimeException;
import com.atlassian.fisheye.dvcs.handler.StatusProcessHandler;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgSubBranch;
import com.atlassian.fisheye.hg.client.HgChangeParser;
import com.atlassian.fisheye.hg.client.HgCommandBuilder;
import com.atlassian.fisheye.hg.client.HgCommitDetails;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.fisheye.hg.client.HgDiffInfo;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgChangeSetDAO;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.atlassian.fisheye.hg.db.HgRevInfoDAO;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.LineOutputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.cenqua.fisheye.util.FileUtils;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class HgScanner
extends DvcsScanner<HgRevInfo, HgChangeSet, HgCache, CommonStringTables> {
    public static final String TIP = "tip";
    private final HgContext context;
    private HgChangeParser changeParser;
    private HgRevInfoDAO fileRevDAO;
    private HgChangeSetDAO csDAO;
    private static final Pattern TAGINFO_PATTERN = Pattern.compile("(.+?)\\s+(-1|\\d+):([0-9a-fA-F]{40})");
    private static final String NULL_TAG_ID = Strings.repeat((String)"0", (int)40);
    private FileSystemUtils fileSystemUtils = null;

    public HgScanner(HgRepositoryEngine engine) {
        super(engine);
        this.context = engine.getContext();
    }

    private void createChangeParser() {
        this.changeParser = new HgChangeParser(this.getEncoding(), this.getStatus(), this.getDiffTextCache(), this.getRepositoryConfig().getAllowRules()){

            @Override
            protected boolean processCommit(HgCommitDetails commitDetails) throws DbException {
                try {
                    return HgScanner.this.processHgCommit(commitDetails);
                }
                catch (LicensePolicyException e2) {
                    throw new DvcsProcessRuntimeException(e2);
                }
            }
        };
    }

    protected void setFileSystemUtils(FileSystemUtils fileSystemUtils) {
        this.fileSystemUtils = fileSystemUtils;
    }

    protected FileSystemUtils getFileSystemUtils() {
        if (this.fileSystemUtils == null) {
            this.fileSystemUtils = (FileSystemUtils)SpringContext.getComponent("fileSystemUtils");
        }
        return this.fileSystemUtils;
    }

    @Override
    public void start(HgCache cache) throws DbException, ConfigException {
        super.start(cache);
        this.fileRevDAO = cache.getFileRevisionDAO();
        this.csDAO = cache.getChangeSetDAO();
        this.createChangeParser();
    }

    @Override
    protected void performClone(File cloneLocation) throws ConfigException {
        StatusProcessHandler handler = new StatusProcessHandler(this.getRepoName(), this.getEncoding(), this.getStatus());
        this.getStatus().setMessage("Cloning repository");
        try {
            IOHelper.mkdirs(cloneLocation);
            this.context.executeCommand((DvcsCommandBuilder)HgCommandBuilder.createInitCommand(), handler);
            this.fetchLatest();
            this.getContext().storeCloneDetails();
        }
        catch (ProcessException e2) {
            FileUtils.deleteTree(cloneLocation);
            String message = this.obfuscate("Unable to clone remote repository: " + this.context.getScmConfig().getRemoteLocation() + (!Strings.isNullOrEmpty((String)handler.getError()) ? "\n - " + handler.getError() : "") + (!Strings.isNullOrEmpty((String)handler.getStdOut()) ? "\n - " + handler.getStdOut() : ""));
            this.getStatus().setEngineError(message);
            throw new ConfigException(message, e2);
        }
        catch (IOException e3) {
            throw new ConfigException("Unable to clone remote repository", e3);
        }
    }

    @Override
    protected boolean fetchLatest() throws ConfigException {
        StatusProcessHandler handler = new StatusProcessHandler(this.getRepoName(), this.getEncoding(), this.getStatus());
        Set<Branch> oldBranches = null;
        Set<Tag> oldTags = null;
        try {
            oldBranches = this.getContext().getBranchesInLocalRepo();
            oldTags = this.getTagsInRepo();
        }
        catch (DvcsProcessException e2) {
            Logs.APP_LOG.warn((Object)"Problem getting existing branches and tags from fetched repo", (Throwable)e2);
        }
        try {
            HgCommandBuilder pullCommand = HgCommandBuilder.createPullCommand(this.getRemoteLocationWithCredentials());
            if (this.context.getScmConfig().isSshAuthenticatedRepo()) {
                pullCommand.setSshCommand(this.getFileSystemUtils().spaceEscapeFilePath(SshWrapper.getSshWrapperCmd(false)));
            }
            this.context.executeCommand((DvcsCommandBuilder)pullCommand, handler);
        }
        catch (ProcessException e3) {
            String message = this.obfuscate("Unable to pull from remote repository: " + this.context.getScmConfig().getRemoteLocation() + (!Strings.isNullOrEmpty((String)handler.getError()) ? "\n - " + handler.getError() : "") + (!Strings.isNullOrEmpty((String)handler.getStdOut()) ? "\n - " + handler.getStdOut() : ""));
            this.getStatus().setEngineError(message);
            throw new ConfigException(message, e3);
        }
        boolean updateOccurred = false;
        try {
            Set<Branch> newBranches = this.context.getBranchesInLocalRepo();
            if (newBranches.isEmpty()) {
                ((HgCache)this.getCache()).setInitialIndexingComplete(true);
            }
            if (oldBranches == null || oldTags == null) {
                updateOccurred = true;
            } else {
                Set<Tag> newTags;
                if (!newBranches.equals(oldBranches)) {
                    updateOccurred = true;
                }
                if (!updateOccurred && !(newTags = this.getTagsInRepo()).equals(oldTags)) {
                    updateOccurred = true;
                }
            }
        }
        catch (DvcsProcessException e4) {
            Logs.APP_LOG.warn((Object)"Problem getting branches from fetched repo", (Throwable)e4);
            updateOccurred = true;
        }
        return updateOccurred;
    }

    @Override
    protected boolean processTags() throws DvcsProcessException, DbException {
        boolean updated = false;
        Set<Tag> tags = this.getTagsInRepo();
        for (Tag tag : tags) {
            if (!this.processTag(tag)) continue;
            updated = true;
        }
        ((HgCache)this.getCache()).pruneDeletedTags(tags);
        return updated;
    }

    private Set<Tag> getTagsInRepo() throws DvcsProcessException {
        final HashSet<Tag> tags = new HashSet<Tag>();
        HgCommandBuilder listTagsCommandBuilder = HgCommandBuilder.createListTagsCommand();
        this.context.executeCommand((DvcsCommandBuilder)listTagsCommandBuilder, (OutputHandler)new BaseLineOutputHandler(this.getEncoding(), listTagsCommandBuilder.toString()){

            protected void processLine(int lineNum, String line) {
                Matcher matcher = TAGINFO_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String tag = matcher.group(1);
                    String tagCommitHash = matcher.group(3);
                    if (!NULL_TAG_ID.equals(tagCommitHash)) {
                        tags.add(new Tag(tag, tagCommitHash));
                    }
                } else {
                    this.reportNonMatchingLine(line);
                }
            }
        });
        return tags;
    }

    private boolean processTag(Tag tag) throws DbException {
        Tag currentTag = this.csDAO.getTag(tag.getName());
        if (currentTag != null && !tag.equals(currentTag)) {
            ((HgCache)this.getCache()).removeTag(currentTag);
        }
        if (!tag.hashEquals(currentTag)) {
            try {
                ((HgCache)this.getCache()).applyTag(tag);
            }
            catch (DvcsProcessException e2) {
                String message = "Error processing tag '" + tag.getName() + "' for commit '" + tag.getChangesetId() + "'";
                Logs.APP_LOG.error((Object)message, (Throwable)e2);
                this.context.getConfig().getStatus().setEngineError(message, e2, this.context.getConfig());
                return false;
            }
            this.csDAO.addTag(tag);
            return true;
        }
        return false;
    }

    @Override
    protected boolean slurpCommits(String currentIndexedHead, List<String> commits) throws DvcsProcessException, LicensePolicyException {
        for (String commit : commits) {
            this.getStatus().setMessage("Indexing commit " + commit);
            HgCommandBuilder command = HgCommandBuilder.createFeLogCommand(commit);
            this.processChange(command);
            if (!this.isStopRequested()) continue;
            return true;
        }
        return true;
    }

    private void processChange(HgCommandBuilder command) throws LicensePolicyException, DvcsProcessException {
        try {
            this.changeParser.resetParser();
            this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)this.changeParser);
        }
        catch (DvcsProcessException e2) {
            e2.rethrowCauseIfItsA(LicensePolicyException.class);
            throw e2;
        }
    }

    protected HgRevInfoDAO getDvcsRevInfoDAO() {
        return this.fileRevDAO;
    }

    protected HgCommandBuilder getListCommitsCommand(String currentIndexed) {
        return HgCommandBuilder.createListCommitsCommand(currentIndexed);
    }

    protected HgCommandBuilder getListBranchCommitsCommand(String currentIndexed, String branch) {
        return HgCommandBuilder.createListBranchCommitsCommand(currentIndexed, branch);
    }

    @Override
    protected HgChangeParser getChangeParser() {
        return this.changeParser;
    }

    @Override
    protected String getRevisionContentKey(DvcsRevInfo revision) {
        return String.valueOf(revision.getRevID());
    }

    @Override
    protected HgContext getContext() {
        return this.context;
    }

    @Override
    protected void handleSlurpException(Exception e2) throws ConfigException {
        boolean handled = false;
        if (e2 instanceof ConfigException) {
            for (Throwable t2 = e2; t2 != null; t2 = t2.getCause()) {
                if (t2.getMessage().startsWith("Cannot run program \"hg\"")) {
                    this.getStatus().setEngineError("Configuration Error: Cannot find \"hg\" binary: Please set in \"Admin\" -> \"Server Settings\"->\"HG Executable\"");
                    handled = true;
                    break;
                }
                if (t2.getMessage().contains(this.context.getScmConfig().getRemoteLocation() + " not found!")) {
                    this.getStatus().setEngineError("Configuration Error: Repository " + this.context.getScmConfig().getRemoteLocation() + " not found");
                    handled = true;
                    break;
                }
                if (!t2.getMessage().contains("abort: There is no Mercurial repository here (.hg not found)")) continue;
                this.getStatus().setEngineError("Repository scan failed due to local clone corruption: Try \"Re-index\"");
                handled = true;
                break;
            }
        }
        if (!handled) {
            super.handleSlurpException(e2);
        }
    }

    @Override
    protected boolean preProcessBranches() throws DvcsProcessException {
        Tag tipTag = ((HgCache)this.getCache()).getTag(TIP);
        String indexedTip = tipTag == null ? null : tipTag.getChangesetId();
        String currentTip = this.getContext().getTip();
        this.getStatus().setMessage("Indexing changesets " + Strings.nullToEmpty((String)indexedTip) + ".." + currentTip);
        boolean indexedCommits = this.processCommitStream(TIP, indexedTip, currentTip, new Function<List<String>, String>(){

            public String apply(List<String> commits) {
                return commits.get(commits.size() - 1);
            }
        });
        if (tipTag == null || !Objects.equal((Object)tipTag.getChangesetId(), (Object)currentTip)) {
            this.processTag(new Tag(TIP, currentTip));
            return true;
        }
        return indexedCommits;
    }

    @Override
    protected List<String> getUnseenCommits(String startCommit, String endCommit, String commitStreamName) throws DvcsProcessException {
        if (!TIP.equals(commitStreamName)) {
            return Collections.emptyList();
        }
        HgCommandBuilder command = this.getListCommitsCommand(startCommit);
        final ArrayList<String> result = new ArrayList<String>();
        BaseLineOutputHandler handler = new BaseLineOutputHandler(this.getEncoding()){

            protected void processLine(int lineNum, String line) {
                List<String> hashes = Arrays.asList(line.split("\t"));
                String commitHash = hashes.get(1);
                if (!HgScanner.this.getChangeSetDAO().exists(commitHash)) {
                    if (result.size() >= HgScanner.this.getContext().getScmConfig().getBlockSize()) {
                        this.cancelProcess();
                    } else {
                        result.add(commitHash);
                    }
                }
            }
        };
        this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)handler);
        return result;
    }

    private boolean processHgCommit(HgCommitDetails commitDetails) throws DbException, LicensePolicyException {
        String commitHash = commitDetails.getCommitHash();
        if (this.csDAO.exists(commitHash)) {
            return false;
        }
        Logs.APP_LOG.debug((Object)("Processing commit " + commitHash));
        boolean result = this.processChangeSet(commitDetails);
        this.processFileRevisions(commitDetails);
        if (result) {
            this.addProcessedCommit(commitDetails.getBranch(), commitHash);
        }
        return result;
    }

    protected boolean shouldIndexChangeSet(HgCommitDetails commitDetails) throws DbException {
        if (commitDetails.getDiffInfoList().isEmpty()) {
            return true;
        }
        for (HgDiffInfo diffInfo : commitDetails.getDiffInfoList()) {
            if (!this.shouldProcessFileRevision(diffInfo)) continue;
            return true;
        }
        String[] tags = commitDetails.getTags();
        if (tags != null && tags.length > 0) {
            return true;
        }
        return commitDetails.getParents().size() > 1;
    }

    private boolean processChangeSet(HgCommitDetails commitDetails) throws DbException, LicensePolicyException {
        if (this.shouldIndexChangeSet(commitDetails)) {
            this.updateBranchPoints(commitDetails);
            HgChangeSet changeset = new HgChangeSet(commitDetails.getCommitHash(), this.csDAO, this.fileRevDAO);
            changeset.setAuthor(commitDetails.getAuthor());
            changeset.setComment(commitDetails.getDescription());
            changeset.setDate(commitDetails.getDate().getTime());
            changeset.setBranch(commitDetails.getBranch());
            changeset.setParents(commitDetails.getParents());
            boolean isLocEnabled = this.getRepositoryConfig().isLocEnabled();
            List<Object> updatedSubBranches = Collections.emptyList();
            if (isLocEnabled) {
                updatedSubBranches = this.updateSubBranchInfo(changeset);
            }
            long adjustedDate = commitDetails.getDate().getTime();
            for (String string : commitDetails.getParents()) {
                HgChangeSet csParent = (HgChangeSet)this.csDAO.load(string);
                if (csParent == null) continue;
                adjustedDate = Math.max(adjustedDate, csParent.getAdjustedDate() + 1000L);
            }
            changeset.setAdjustedDate(adjustedDate);
            commitDetails.setAdjustedDate(adjustedDate);
            this.csDAO.store(changeset);
            if (isLocEnabled) {
                for (HgSubBranch hgSubBranch : updatedSubBranches) {
                    ((HgCache)this.getCache()).saveSubBranch(hgSubBranch);
                }
            }
            return true;
        }
        this.csDAO.updateParentGraph(commitDetails.getCommitHash(), commitDetails.getParents());
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)String.format("[%s]: Ignoring changeset %s; it does not contain any changes in the watched area", ((HgCache)this.getCache()).getRepositoryName(), commitDetails.getCommitHash()));
        }
        return false;
    }

    private List<HgSubBranch> updateSubBranchInfo(HgChangeSet changeset) throws DbException {
        ArrayList<HgSubBranch> updatedSubBranches = new ArrayList<HgSubBranch>();
        List<String> parents = changeset.getParents();
        String firstParent = parents.isEmpty() ? null : parents.get(0);
        List siblings = firstParent == null ? Collections.emptyList() : this.csDAO.loadChildIds(firstParent);
        HgChangeSet parentCS = (HgChangeSet)this.csDAO.load(firstParent);
        siblings.remove(changeset.getId());
        if (parents.isEmpty() || !siblings.isEmpty() || !parentCS.getBranch().equals(changeset.getBranch())) {
            changeset.setSubBranch(changeset.getId(), ((CommonStringTables)((HgCache)this.getCache()).getStringTables()).changeSetIdDB.find(changeset.getId()));
            String parentSubBranch = parentCS == null ? null : parentCS.getSubBranch();
            long parentSubBranchId = ((CommonStringTables)((HgCache)this.getCache()).getStringTables()).changeSetIdDB.find(parentSubBranch);
            HgSubBranch subBranch = new HgSubBranch(changeset.getId(), firstParent, parentSubBranchId);
            updatedSubBranches.add(subBranch);
        } else {
            HgSubBranch subBranch = ((HgCache)this.getCache()).getSubBranch(parentCS.getSubBranch());
            changeset.setSubBranch(parentCS.getSubBranch(), parentCS.getSubBranchId());
            subBranch.setLastCommitOnBranch(changeset.getId());
            updatedSubBranches.add(subBranch);
        }
        if (parents.size() == 2) {
            HgChangeSet parentCS2 = (HgChangeSet)this.csDAO.load(parents.get(1));
            HgSubBranch oldSubBranch = ((HgCache)this.getCache()).getSubBranch(parentCS2.getSubBranch());
            oldSubBranch.setEndingMergeCommit(changeset.getId(), parentCS2.getId());
            updatedSubBranches.add(oldSubBranch);
        }
        return updatedSubBranches;
    }

    private void updateBranchPoints(HgCommitDetails commitDetails) throws DbException {
        if (!((HgCache)this.getCache()).isBranchPointIndexed(commitDetails.getBranch())) {
            String parent = "0000000000000000000000000000000000000000";
            if (!commitDetails.getParents().isEmpty()) {
                parent = commitDetails.getParents().get(0);
            }
            ((HgCache)this.getCache()).addBranchPoint(commitDetails.getBranch(), commitDetails.getCommitHash(), parent);
        }
    }

    private boolean isPathInRepo(String path) {
        return this.context.isPathInRepo(this.context.getLocalPath(path));
    }

    private boolean shouldProcessFileRevision(HgDiffInfo diffInfo) throws DbException {
        if (diffInfo.isMove()) {
            return this.isPathInRepo(diffInfo.getFromPath()) || this.isPathInRepo(diffInfo.getToPath());
        }
        return this.isPathInRepo(diffInfo.getToPath());
    }

    private void processFileRevisions(HgCommitDetails commitDetails) throws DbException, LicensePolicyException {
        for (HgDiffInfo hgDiffInfo : commitDetails.getDiffInfoList()) {
            if (!this.shouldProcessFileRevision(hgDiffInfo)) continue;
            if (hgDiffInfo.isMerge()) {
                ((HgCache)this.getCache()).addMergeCommit(hgDiffInfo, commitDetails);
                continue;
            }
            if (hgDiffInfo.isNewlyAdded()) {
                this.processAddition(commitDetails, hgDiffInfo);
                continue;
            }
            if (hgDiffInfo.isMove() || hgDiffInfo.isCopy()) {
                this.processMoveOrCopy(commitDetails, hgDiffInfo);
                continue;
            }
            if (hgDiffInfo.isDeletion()) {
                this.processDeletion(commitDetails, hgDiffInfo);
                continue;
            }
            this.processModification(commitDetails, hgDiffInfo);
        }
    }

    private HgRevInfo createRevInfo(HgCommitDetails commitDetails, HgDiffInfo diffInfo) {
        HgRevInfo revInfo = new HgRevInfo();
        revInfo.setComment(commitDetails.getDescription());
        revInfo.setAuthor(commitDetails.getAuthor());
        revInfo.setDate(commitDetails.getDate().getTime());
        revInfo.setPath(this.context.getLocalPath(diffInfo.getToPath()));
        revInfo.setRevision(commitDetails.getCommitHash());
        int type = 1;
        if (revInfo.getPath().isRoot()) {
            type = 2;
        }
        revInfo.setFileType(type);
        revInfo.addBranch(commitDetails.getBranch());
        revInfo.setTrunkLike(Strings.isNullOrEmpty((String)commitDetails.getBranch()) || commitDetails.getBranch().equals(this.context.getMainBranchName()));
        revInfo.setHunks(diffInfo.getHunks());
        revInfo.setTmpDiffAddedFile(diffInfo.getTmpDiffAddedFile());
        revInfo.setTmpDiffRemovedFile(diffInfo.getTmpDiffRemovedFile());
        revInfo.setBinary(diffInfo.isBinary());
        revInfo.setAdjustedDate(commitDetails.getAdjustedDate());
        if (diffInfo.getFileSize() > this.getRepositoryConfig().getMaxIndexableSize()) {
            revInfo.setOversize(true);
        }
        return revInfo;
    }

    private void processAddition(HgCommitDetails commitDetails, HgDiffInfo diffInfo) throws DbException, LicensePolicyException {
        HgRevInfo revInfo = this.createRevInfo(commitDetails, diffInfo);
        revInfo.setAdded(true);
        int linesAdded = 0;
        if (diffInfo.isNewlyAdded()) {
            linesAdded = diffInfo.getNumAdded();
        } else if (!diffInfo.isBinary()) {
            try {
                linesAdded = this.context.getLineCountForFileRevisionFromClient(revInfo.getPath(), revInfo.getRevision());
            }
            catch (DvcsProcessException e2) {
                Logs.APP_LOG.error((Object)("Error while determining line count for " + revInfo.getPath() + " at revision " + revInfo.getRevision()));
            }
        }
        revInfo.setLineCount(linesAdded);
        revInfo.setLinesAdded(linesAdded);
        revInfo.setLinesRemoved(0);
        this.insertNewRevision(revInfo, null);
    }

    private IntList getSrcRevIds(final HgDiffInfo diffInfo) throws DbException {
        IntArrayList srcRevIds = new IntArrayList();
        for (HgDiffInfo.FileParent parent : diffInfo.getFileParents()) {
            String sourceHash = this.csDAO.getLongCommitHash(parent.getCommitHash());
            int srcRevId = -1;
            if (sourceHash != null && !sourceHash.equals("0000000000000000000000000000000000000000")) {
                srcRevId = this.fileRevDAO.getRevId(this.context.getLocalPath(parent.getPath()), sourceHash);
            }
            if (srcRevId != -1) {
                srcRevIds.add(srcRevId);
                continue;
            }
            Logs.APP_LOG.debug((Object)("Failed to find ancestor revision " + parent.getPath() + "@" + sourceHash + ". Trying to fallback to topological search."));
            try {
                this.context.executeCommand((DvcsCommandBuilder)HgCommandBuilder.createFilePredecessorsCommand(diffInfo.getCommit(), parent.getPath()), (OutputHandler)new LineOutputHandler((IntList)srcRevIds){
                    final /* synthetic */ IntList val$srcRevIds;
                    {
                        this.val$srcRevIds = intList;
                    }

                    protected void processLine(int lineNum, String line) {
                        int revId = HgScanner.this.fileRevDAO.getRevId(new Path(diffInfo.getFromPath()), line);
                        if (revId == -1) {
                            Logs.APP_LOG.debug((Object)("Topological search returned " + line + ", but didn't manage to find that either."));
                        } else {
                            this.val$srcRevIds.add(revId);
                        }
                    }
                });
            }
            catch (DvcsProcessException e2) {
                throw new RuntimeException("Error retrieving revision ancestors using topological search", e2);
            }
            if (!srcRevIds.isEmpty()) continue;
            Logs.APP_LOG.warn((Object)("Can't find parent revision for " + diffInfo.getToPath() + ", hash = " + diffInfo.getCommit() + ", " + "parent hash = " + sourceHash + ", parent path = " + parent.getPath()));
        }
        return srcRevIds;
    }

    private void processMoveOrCopy(HgCommitDetails commitDetails, HgDiffInfo diffInfo) throws DbException, LicensePolicyException {
        boolean toInsideRepo = this.isPathInRepo(diffInfo.getToPath());
        boolean fromInsideRepo = this.isPathInRepo(diffInfo.getFromPath());
        if (fromInsideRepo && toInsideRepo) {
            HgRevInfo revInfo = this.createRevInfo(commitDetails, diffInfo);
            revInfo.setCopy(diffInfo.isCopy());
            revInfo.setMove(diffInfo.isMove());
            IntList srcRevIds = this.getSrcRevIds(diffInfo);
            AncestorLink ancestorLink = srcRevIds.isEmpty() ? null : new AncestorLink(revInfo.isMove() ? AncestorLink.Type.MOVE : AncestorLink.Type.COPY, (Iterable<Integer>)srcRevIds);
            this.computeRevisionLinecounts(diffInfo, revInfo, srcRevIds);
            if (revInfo.isMove() && !srcRevIds.isEmpty()) {
                HgRevInfo deletedRev = this.createRevInfo(commitDetails, diffInfo);
                deletedRev.setPath(this.context.getLocalPath(diffInfo.getFromPath()));
                deletedRev.createDeletedHunk();
                deletedRev.setDead(true);
                deletedRev.setBinary(revInfo.isBinary());
                deletedRev.setLineCount(0);
                deletedRev.setLinesAdded(0);
                deletedRev.setLinesRemoved(this.fileRevDAO.getLineCount((Integer)srcRevIds.get(0)));
                this.insertNewRevision(deletedRev, new AncestorLink(AncestorLink.Type.DIRECT, (Iterable<Integer>)srcRevIds));
            }
            this.insertNewRevision(revInfo, ancestorLink);
        } else if (!fromInsideRepo && toInsideRepo) {
            this.processAddition(commitDetails, diffInfo);
        } else if (fromInsideRepo && !toInsideRepo && diffInfo.isMove()) {
            this.processDeletion(commitDetails, diffInfo);
        }
    }

    private void processModification(HgCommitDetails commitDetails, HgDiffInfo diffInfo) throws DbException, LicensePolicyException {
        HgRevInfo revInfo = this.createRevInfo(commitDetails, diffInfo);
        revInfo.setModify(true);
        IntList srcRevIds = this.getSrcRevIds(diffInfo);
        AncestorLink ancestorLink = srcRevIds.isEmpty() ? null : new AncestorLink(AncestorLink.Type.DIRECT, (Iterable<Integer>)srcRevIds);
        this.computeRevisionLinecounts(diffInfo, revInfo, srcRevIds);
        this.insertNewRevision(revInfo, ancestorLink);
    }

    private void computeRevisionLinecounts(HgDiffInfo diffInfo, HgRevInfo revInfo, IntList srcRevIds) {
        if (srcRevIds.isEmpty()) {
            revInfo.setLineCount(diffInfo.getNumAdded());
            revInfo.setLinesAdded(diffInfo.getNumAdded());
            revInfo.setLinesRemoved(diffInfo.getNumRemoved());
        } else {
            int ancestorId = srcRevIds.getInt(0);
            boolean ancestorBinary = this.fileRevDAO.isBinary(ancestorId);
            boolean ancestorOversize = this.fileRevDAO.isOversize(ancestorId);
            if (!diffInfo.isChanged()) {
                revInfo.setBinary(ancestorBinary);
            }
            if (!revInfo.isBinaryOrOversize() && (ancestorBinary || ancestorOversize)) {
                int linesInCurrentRev;
                try {
                    linesInCurrentRev = this.context.getLineCountForFileRevisionFromClient(revInfo.getPath(), revInfo.getRevision());
                }
                catch (DvcsProcessException e2) {
                    throw new RuntimeException(e2);
                }
                revInfo.setLineCount(linesInCurrentRev);
                revInfo.setLinesAdded(linesInCurrentRev);
                revInfo.setLinesRemoved(0);
            } else {
                int ancestorLineCount = this.fileRevDAO.getLineCount(ancestorId);
                int lineCount = ancestorLineCount + diffInfo.getNumAdded() - diffInfo.getNumRemoved();
                revInfo.setLineCount(lineCount);
                revInfo.setLinesAdded(diffInfo.getNumAdded());
                revInfo.setLinesRemoved(diffInfo.getNumRemoved());
            }
        }
    }

    private void processDeletion(HgCommitDetails commitDetails, HgDiffInfo diffInfo) throws DbException, LicensePolicyException {
        HgRevInfo revInfo = this.createRevInfo(commitDetails, diffInfo);
        if (diffInfo.getFromPath() != null) {
            revInfo.setPath(this.context.getLocalPath(diffInfo.getFromPath()));
        }
        revInfo.setDead(true);
        IntList srcRevIds = this.getSrcRevIds(diffInfo);
        AncestorLink ancestorLink = null;
        int ancestorLineCount = 0;
        if (!srcRevIds.isEmpty()) {
            ancestorLink = new AncestorLink(AncestorLink.Type.DIRECT, (Iterable<Integer>)srcRevIds);
            ancestorLineCount = this.fileRevDAO.getLineCount(srcRevIds.getInt(0));
        }
        revInfo.setLineCount(0);
        revInfo.setLinesAdded(0);
        revInfo.setLinesRemoved(ancestorLineCount);
        this.insertNewRevision(revInfo, ancestorLink);
    }

    private void insertNewRevision(HgRevInfo revInfo, AncestorLink ancestorLink) throws DbException, LicensePolicyException {
        if (revInfo.getPath() == null) {
            Logs.APP_LOG.warn((Object)(this.context.getName() + ": null path in HgRevInfo:" + revInfo));
        }
        this.createParentDir(revInfo.getPath().getParent());
        int revid = this.fileRevDAO.insertNew(revInfo, ancestorLink, this.getFeatures().isStoreDiffs());
        if (this.getFeatures().isStoreDiffs()) {
            this.getRepositoryIndexer().indexDiffText(revInfo, revid, this.getDiffTextCache(), this.fileRevDAO.getCommonRevInfoDAO());
        }
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)(this.context.getName() + ": Indexed " + revid + ": " + revInfo.toString() + ", ancestors " + (ancestorLink == null ? null : ancestorLink.getRevids())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indexContentBlock(Multimap<String, DvcsRevInfo> revisions) throws DvcsProcessException, DbException {
        if (revisions.isEmpty()) {
            return;
        }
        Timer timer = new Timer("Indexing Content Block of " + this.context.getName());
        try {
            final File contentFile = File.createTempFile("content", null, AppConfig.getTempDir());
            for (Map.Entry entry : revisions.entries()) {
                DvcsRevInfo rev = (DvcsRevInfo)entry.getValue();
                String path = "unknown";
                String csid = "unknown";
                try {
                    path = rev.getPath().getPath();
                    csid = rev.getChangeSetId();
                    HgCommandBuilder command = HgCommandBuilder.createContentCommand(path, csid);
                    this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)new BaseOutputHandler(){

                        public void process(InputStream output) throws ProcessException {
                            try {
                                IOHelper.copyStream(output, contentFile);
                            }
                            catch (IOException e1) {
                                throw new ProcessException((Throwable)e1);
                            }
                        }
                    });
                    if (!this.context.getConfig().isOfIndexableSize(rev.getPath(), contentFile.length(), rev.getDisplayRevision())) continue;
                    this.getRepositoryIndexer().indexContent(rev, contentFile, this.context.getCharset());
                }
                catch (Exception ex) {
                    String message = "Problem indexing content of \"" + path + "\" for rev \"" + csid + "\" from repo \"" + this.getContext().getName() + "\" due to " + ex.getClass() + " - " + ex.getMessage();
                    Logs.APP_LOG.error((Object)message, (Throwable)ex);
                    this.getContext().getConfig().getStatus().setEngineError(message);
                }
                finally {
                    IOHelper.deleteFile(contentFile);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        timer.end();
    }

    @Override
    public String updateRevisions(String start, String end) throws RepositoryClientException, DbException {
        throw new UnsupportedOperationException("Hg Repositories do not support rescanning presently");
    }

    protected HgChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    protected Branch prepareBranchToBeStored(@Nullable Branch branchInCache, @Nullable Branch branchInScm) {
        if (branchInScm != null) {
            return branchInScm;
        }
        if (branchInCache != null && branchInCache.getState() != BranchState.CLOSED) {
            Branch closedBranch = branchInCache.clone();
            closedBranch.setState(BranchState.CLOSED);
            return closedBranch;
        }
        throw new IllegalStateException("Both branchInCache and branchInScm not specified in onBranchHeadUpdated");
    }
}

