/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.hg.HgBlameAndLinecountCalculator;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgScanner;
import com.atlassian.fisheye.hg.client.HgContext;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.Version;

public class HgRepositoryEngine
extends BaseRepositoryEngine<HgScanner, HgCache> {
    private static final Version MINIMAL_HG_VERSION = new Version("1.5");
    private final HgContext context;

    public HgRepositoryEngine(RepositoryConfig cfg, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        super(cfg, upgradeManager, indexingContext);
        this.context = new HgContext(cfg);
    }

    @Override
    protected HgScanner createScanner() throws DbException {
        return new HgScanner(this);
    }

    @Override
    protected HgCache createCache(long cacheSerial) {
        return new HgCache(cacheSerial, this.getDiskCacheVersion(), this.context, this.context.getName(), this.getDatabaseHandle(), this.getIndexConnection(), this.getLicenseEnforcer(), this.getIndexingContext());
    }

    @Override
    protected void ensureCorrectScmVersion() throws ConfigException {
        Version hgVersion = this.context.determineHgVersion();
        HgRepositoryEngine.validateHgVersion(hgVersion);
    }

    public static void validateHgVersion(Version hgVersion) throws ConfigException {
        if (hgVersion.compareTo(MINIMAL_HG_VERSION) < 0) {
            throw new ConfigException("You must use a hg version of " + MINIMAL_HG_VERSION + " or later - you have " + hgVersion);
        }
    }

    @Override
    public String getDisplayRevision(String revision) {
        return DvcsUtils.truncateHash(revision);
    }

    @Override
    protected BlameAndLinecountCalculator initLinecountCalculator() {
        return new HgBlameAndLinecountCalculator(this);
    }

    @Override
    public String getLink(RevInfoKey revInfoKey) {
        return "";
    }

    @Override
    public void requestFullscan() {
    }

    @Override
    protected long getPollPeriod() {
        return this.context.getScmConfig().getPollPeriod();
    }

    public HgContext getContext() {
        return this.context;
    }
}

