/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.ManifestDAO;
import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.hg.HgSubBranch;
import com.atlassian.fisheye.hg.SubBranchDAO;
import com.atlassian.fisheye.hg.client.HgBlameParser;
import com.atlassian.fisheye.hg.client.HgClientManifestDAO;
import com.atlassian.fisheye.hg.client.HgCommandBuilder;
import com.atlassian.fisheye.hg.client.HgCommitDetails;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.fisheye.hg.client.HgDiffInfo;
import com.atlassian.fisheye.hg.db.BranchPointCommitIndex;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgChangeSetDAO;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.atlassian.fisheye.hg.db.HgRevInfoDAO;
import com.atlassian.fisheye.hg.db.MergeCommitIndex;
import com.atlassian.utils.process.CopyOutputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HgCache
extends DvcsCache<HgRevInfo, HgChangeSet, CommonStringTables> {
    private final HgContext context;
    private final MergeCommitIndex mergeCommitIndex;
    private BranchPointCommitIndex branchPointCommitIndex;
    private HgRevInfoDAO fileRevDAO;
    private HgChangeSetDAO csDAO;
    private ManifestDAO<HgRevInfo> manifestDAO;
    private SubBranchDAO subBranchDAO;

    public HgCache(long cacheSerial, int version, HgContext context, String repositoryName, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext) {
        super(context.getConfig().getStatus(), cacheSerial, version, dbh, luceneConnection, new CommonStringTables(dbh), licenseEnforcer, indexingContext, repositoryName, context);
        this.context = context;
        this.branchPointCommitIndex = new BranchPointCommitIndex(dbh, (CommonStringTables)this.getStringTables());
        this.fileRevDAO = new HgRevInfoDAO(this.getRepositoryName(), this.getInfDb(), (CommonStringTables)this.getStringTables(), this.getLicenseEnforcer());
        this.csDAO = new HgChangeSetDAO(context.getConfig().getStatus(), this.getInfDb(), (CommonStringTables)this.getStringTables(), this.getFileRevisionDAO(), this.getLicenseEnforcer());
        this.manifestDAO = new HgClientManifestDAO(context, this.fileRevDAO, this.csDAO);
        this.mergeCommitIndex = new MergeCommitIndex(dbh, (CommonStringTables)this.getStringTables());
        this.subBranchDAO = new SubBranchDAO(this.getInfDb(), (CommonStringTables)this.getStringTables());
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, OutputStream outputStream) throws IOException, DbException {
        try {
            if (((HgRevInfo)this.getFileRevision(key)).isDead()) {
                return;
            }
            HgCommandBuilder command = HgCommandBuilder.createContentCommand(key.getPath().toString(), key.getRev());
            CopyOutputHandler copyHandler = new CopyOutputHandler(outputStream);
            this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)copyHandler);
            outputStream.flush();
        }
        catch (DvcsProcessException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> patchRevisions) throws DbException {
        if (!patchRevisions.isEmpty()) {
            String longCommitHash;
            String patchCommitHash = patchRevisions.values().iterator().next().getId();
            if (patchCommitHash.indexOf(":") != -1) {
                patchCommitHash = patchCommitHash.substring(patchCommitHash.indexOf(":") + 1);
            }
            if ((longCommitHash = this.csDAO.getLongCommitHash(patchCommitHash)) == null) {
                Logs.APP_LOG.debug((Object)("Unknown commit hash: " + patchCommitHash));
                return Collections.emptyMap();
            }
            Manifest<HgRevInfo> manifest = this.manifestDAO.load(longCommitHash);
            HashSet<Path> paths = new HashSet<Path>();
            for (Path path : patchRevisions.keySet()) {
                paths.add(path);
            }
            PatchResolverVisitor visitor = new PatchResolverVisitor(paths);
            manifest.visitFileRevisions(visitor);
            return visitor.resolvedCache;
        }
        return Collections.emptyMap();
    }

    @Override
    public Blame getBlameFallback(final RevInfoKey revInfoKey) throws DbException, IOException {
        HgCommandBuilder command = HgCommandBuilder.createBlameCommand(revInfoKey);
        int revid = this.getRevId(revInfoKey);
        final HgRevInfo fileRev = revid == -1 ? null : (HgRevInfo)this.getFileRevision(revid, true);
        final ArrayList<BlameChunk> blameChunks = new ArrayList<BlameChunk>();
        final HashMap ancestors = new HashMap();
        if (!(fileRev == null || fileRev.isBinary() || fileRev.isDead() || fileRev.isDir())) {
            try {
                this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)new HgBlameParser(this.context.getScmConfig().getEncoding()){

                    @Override
                    protected void endChunk(String commit, String filename, int originalLine, int lineNum, int length) throws DbException {
                        BlameChunk chunk;
                        String revision = HgCache.this.getLongHash(commit);
                        HgRevInfo fileRevision = (HgRevInfo)ancestors.get(revision);
                        if (fileRevision == null) {
                            Path path = HgCache.this.context.getLocalPath(filename);
                            RevInfoKey key = new RevInfoKey(path, revision);
                            fileRevision = (HgRevInfo)HgCache.this.getFileRevision(key);
                        }
                        if (fileRevision == null) {
                            fileRevision = HgCache.this.getAncestorAtRevision(fileRev, revision);
                        }
                        if (fileRevision != null) {
                            ancestors.put(revision, fileRevision);
                            chunk = new BlameChunk(fileRevision, lineNum - 1, originalLine - 1);
                            chunk.setLength(length);
                        } else {
                            Logs.APP_LOG.warn((Object)("Unable to find file revision for " + filename + "@" + revision + ", line = " + lineNum + ", length = " + length));
                            SyntheticBlameInfo info = new SyntheticBlameInfo(commit, DvcsUtils.truncateHash(commit), revInfoKey.getPath());
                            chunk = new BlameChunk(info, lineNum - 1, originalLine - 1, length);
                        }
                        blameChunks.add(chunk);
                    }
                });
            }
            catch (DvcsProcessException e2) {
                throw new IOException("Could not retrieve blame for file " + fileRev.getRevInfoKey(), e2);
            }
        }
        return new Blame(blameChunks);
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.HG;
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    protected DvcsContext getContext() {
        return this.context;
    }

    @Override
    public HgRevInfoDAO getFileRevisionDAO() {
        return this.fileRevDAO;
    }

    @Override
    public HgChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    public boolean isBranchPointIndexed(String branch) throws DbException {
        return this.branchPointCommitIndex.isBranchPointIndexed(branch);
    }

    public void addBranchPoint(String branch, String commitHash, String parentHash) throws DbException {
        this.branchPointCommitIndex.addBranchPoint(branch, commitHash, parentHash);
    }

    public void visitManifestRevisions(String tagCommitHash, Visitor<HgRevInfo> visitor) throws DbException {
        this.manifestDAO.visitRevisions(tagCommitHash, visitor);
    }

    public void addMergeCommit(HgDiffInfo hgDiffInfo, HgCommitDetails commitDetails) throws DbException {
        this.mergeCommitIndex.insert(hgDiffInfo, commitDetails);
    }

    public BranchPointCommitIndex.IndexEntry getBranchPointCommit(long id) throws DbException {
        return this.branchPointCommitIndex.getCommit(id);
    }

    public void visitMergeCommitRevisions(long startId, MergeCommitIndex.Visitor visitor) throws DbException {
        this.mergeCommitIndex.visitRevisions(startId, visitor);
    }

    public HgSubBranch getSubBranch(long subBranch) throws DbException {
        return this.subBranchDAO.load(subBranch);
    }

    public void saveSubBranch(HgSubBranch subBranch) throws DbException {
        this.subBranchDAO.save(subBranch);
    }

    public HgSubBranch getSubBranch(String subBranch) throws DbException {
        return this.subBranchDAO.load(subBranch);
    }

    @Override
    public Manifest<HgRevInfo> getManifest(String csid) throws DbException {
        return this.manifestDAO.load(csid);
    }

    @Override
    public void applyTag(final Tag tag) throws DvcsProcessException, DbException {
        String longHash;
        super.applyTag(tag);
        if (!"tip".equals(tag.getName()) && (longHash = this.getLongHash(tag.getChangesetId())) != null) {
            this.manifestDAO.visitRevisions(longHash, new Visitor<HgRevInfo>(){

                @Override
                public void visit(HgRevInfo revInfo) {
                    HgCache.this.fileRevDAO.getCommonRevInfoDAO().addTagData(revInfo.getRevID(), tag.getName());
                }
            });
        }
    }

    @Override
    public long getSubBranchId(String changeSetId) throws DbException {
        return this.csDAO.getSubBranchId(changeSetId);
    }

    public static interface RevInfoKeyVisitor {
        public void visit(RevInfoKey var1) throws DbException;
    }

    private static class PatchResolverVisitor
    implements Visitor<HgRevInfo> {
        public Map<Path, String> resolvedCache = new HashMap<Path, String>();
        private final Set<Path> paths;

        private PatchResolverVisitor(Set<Path> paths) {
            this.paths = paths;
        }

        @Override
        public void visit(HgRevInfo rev) {
            if (this.paths.contains(rev.getPath())) {
                this.resolvedCache.put(rev.getPath(), rev.getRevision());
                this.paths.remove(rev.getPath());
            }
        }
    }
}

