/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgSubBranch;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.atlassian.fisheye.hg.db.MergeCommitIndex;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.History;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.blame.BaseBlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.SumMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HgBlameAndLinecountCalculator
extends BaseBlameAndLinecountCalculator {
    public HgBlameAndLinecountCalculator(HgRepositoryEngine hgRepositoryEngine) {
        super(hgRepositoryEngine);
        this.changesetLinecountCalculator = new HgChangesetLinecountCalculator();
    }

    public HgCache getCache() {
        return (HgCache)super.getCache();
    }

    @Override
    protected Date getRevDate(FileRevision rev) {
        return new Date(((HgRevInfo)rev).getAdjustedDate());
    }

    protected Date getCommitDate(HgChangeSet cs) {
        return new Date(cs.getAdjustedDate());
    }

    @Override
    @Nullable
    protected FileRevision determineDiffRevision(@Nonnull FileRevision revision, @Nullable FileRevision ancestor) {
        return ancestor;
    }

    class HgChangesetLinecountCalculator
    implements BaseBlameAndLinecountCalculator.ChangesetLinecountCalculator {
        HgChangesetLinecountCalculator() {
        }

        private void processBranchPoint(String parentCommit, final String commitHash, final String branch) throws DbException {
            if (!"0000000000000000000000000000000000000000".equals(parentCommit)) {
                final HgChangeSet cs = (HgChangeSet)HgBlameAndLinecountCalculator.this.getCache().getChangeSet(commitHash);
                HgBlameAndLinecountCalculator.this.getCache().visitManifestRevisions(parentCommit, new Visitor<HgRevInfo>(){

                    @Override
                    public void visit(HgRevInfo revInfo) {
                        RevInfoKey key = revInfo.getRevInfoKey();
                        History history = HgBlameAndLinecountCalculator.this.getHistory(key);
                        long subBranchId = HgBlameAndLinecountCalculator.this.getCache().getSubBranchId(commitHash);
                        for (Map.Entry<String, Integer> e2 : history.getAuthorLinecount().entrySet()) {
                            HgBlameAndLinecountCalculator.this.getBucketGraph().addRevision(key.getPath(), branch, HgBlameAndLinecountCalculator.this.getCommitDate(cs), e2.getValue(), 0, e2.getKey(), false, subBranchId);
                        }
                    }
                });
            }
        }

        private void processMergeCommit(long id, final Long subBranchId) throws DbException {
            HgBlameAndLinecountCalculator.this.getCache().visitMergeCommitRevisions(id, new MergeCommitIndex.Visitor(){

                @Override
                public boolean visit(MergeCommitIndex.IndexEntry indexEntry) throws DbException {
                    long subBranch;
                    RevInfoKey key = new RevInfoKey(new Path(indexEntry.path), indexEntry.fileCommit);
                    History history = HgBlameAndLinecountCalculator.this.getHistory(key);
                    HgChangeSet cs = (HgChangeSet)HgBlameAndLinecountCalculator.this.getCache().getChangeSet(indexEntry.commit);
                    long l2 = subBranch = subBranchId == null ? cs.getSubBranchId() : subBranchId.longValue();
                    if (cs != null) {
                        boolean isTrunklike = cs.getBranch().equals(HgBlameAndLinecountCalculator.this.getCache().getContext().getMainBranchName());
                        SumMap<String> authorLoc = history.getAuthorLinecount();
                        if (indexEntry.isReplace()) {
                            RevInfoKey predecessorKey = new RevInfoKey(new Path(indexEntry.path), indexEntry.mergeReplaceCommit);
                            History predecessorHistory = HgBlameAndLinecountCalculator.this.getHistory(predecessorKey);
                            authorLoc.subtractAllValues(predecessorHistory.getAuthorLinecount());
                        }
                        for (Object2IntMap.Entry e2 : history.getAuthorLinecount().object2IntEntrySet()) {
                            int loc = e2.getIntValue();
                            if (loc == 0) continue;
                            HgBlameAndLinecountCalculator.this.getBucketGraph().addRevision(key.getPath(), cs.getBranch(), HgBlameAndLinecountCalculator.this.getCommitDate(cs), loc, 0, (String)e2.getKey(), isTrunklike, subBranch);
                        }
                    }
                    return !HgBlameAndLinecountCalculator.this.status.isStopRequested();
                }
            });
        }

        @Override
        public void indexChangeset(long id, CharSequence str) throws DbException {
            this.processMergeCommit(id, null);
            this.processSubBranchPoints(id, str.toString());
        }

        private void processSubBranchPoints(final long commitId, String changesetName) throws DbException {
            HgSubBranch subBranch = HgBlameAndLinecountCalculator.this.getCache().getSubBranch(commitId);
            if (subBranch == null) {
                return;
            }
            HgChangeSet csFirstOnSubBranch = (HgChangeSet)HgBlameAndLinecountCalculator.this.getCache().getChangeSet(changesetName);
            HgChangeSet csParentCs = (HgChangeSet)HgBlameAndLinecountCalculator.this.getCache().getChangeSet(subBranch.getParentCommit());
            if (csParentCs == null) {
                return;
            }
            if (!csFirstOnSubBranch.getBranch().equals(csParentCs.getBranch())) {
                this.processBranchPoint(csParentCs.getId(), changesetName, csFirstOnSubBranch.getBranch());
            } else {
                Period parentCsBucket = new Period(PeriodUnit.DAY, HgBlameAndLinecountCalculator.this.getCommitDate(csParentCs), HgBlameAndLinecountCalculator.this.getBucketGraph().getTimeZone());
                HgChangeSet cs = csParentCs;
                long subBranchId = cs.getSubBranchId();
                while (cs != null && subBranchId == cs.getSubBranchId() && HgBlameAndLinecountCalculator.this.getCommitDate(cs).getTime() >= parentCsBucket.getStartTime()) {
                    cs.visitRevisions(new Visitor<FileRevision>(){

                        @Override
                        public void visit(FileRevision rev) {
                            List data = HgBlameAndLinecountCalculator.this.calculateRevisionData(rev);
                            for (ParameterSetInsertion e2 : data) {
                                e2.setSubBranchId(commitId);
                                e2.setNumRevisions(0);
                                HgBlameAndLinecountCalculator.this.getBucketGraph().addRevision(e2);
                            }
                        }
                    });
                    this.processMergeCommit(((CommonStringTables)HgBlameAndLinecountCalculator.this.getCache().getStringTables()).changeSetIdDB.find(cs.getId()), commitId);
                    cs = this.getParentChangeset(cs);
                }
            }
        }

        private HgChangeSet getParentChangeset(HgChangeSet cs) throws DbException {
            String csid = cs.getParents().isEmpty() ? null : cs.getParents().get(0);
            return csid == null ? null : (HgChangeSet)HgBlameAndLinecountCalculator.this.getCache().getChangeSet(csid);
        }
    }
}

