/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.utils.HttpUtils;
import com.atlassian.fisheye.gravatar.Avatar;
import com.atlassian.fisheye.gravatar.AvatarManager;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.MD5;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class RenderAvatarAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String username;
    private int s = 48;
    private boolean noCache;
    private AvatarManager avatarManager;
    private UserManager userManager;
    private AvatarTypeInfo avatarTypeInfo;

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setUsername(String username) {
        try {
            this.username = URLDecoder.decode(username, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.error((Object)"UTF-8 is not supported", (Throwable)e2);
            this.username = username;
        }
    }

    public void setS(int s2) {
        s2 = Math.min(s2, 512);
        this.s = s2 = Math.max(s2, 1);
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        String hash;
        FecruUser user = this.userManager.getUser(this.username);
        if (this.noCache) {
            this.response.setHeader("Cache-Control", "no-cache");
        } else {
            long expires = 60000L * (long)FishEyeSysProps.AVATAR_TTL_MINUTES;
            HttpUtils.addCacheHeaders(this.response, expires);
        }
        if (user != null && this.avatarTypeInfo.isExternal()) {
            String redirectUrl = this.avatarTypeInfo.getExternalAvatarUrl(user, this.s);
            this.response.sendRedirect(redirectUrl);
            return "none";
        }
        if (user != null) {
            hash = MD5.hash(user.getUsername());
        } else {
            switch (this.username) {
                case "j_doe": 
                case "deleted": {
                    hash = this.username;
                    break;
                }
                default: {
                    hash = null;
                }
            }
        }
        String etag = this.createEtag(this.avatarManager.getAvatarLastModified(hash));
        if (etag.equals(this.request.getHeader("If-None-Match"))) {
            this.response.setStatus(304);
            return "none";
        }
        this.response.setHeader("ETag", etag);
        Avatar avatar = this.avatarManager.getAvatar(hash);
        if (avatar == null) {
            avatar = this.avatarManager.getGenericAvatar();
        }
        if (avatar == null) {
            this.response.sendError(404);
            return "none";
        }
        this.response.setContentType(avatar.getContentType());
        ServletOutputStream out = this.response.getOutputStream();
        ImageIO.write((RenderedImage)avatar.getThumbnail(this.s), avatar.getFormatName(), (OutputStream)out);
        return "none";
    }

    private String createEtag(long lastModified) {
        return FisheyeVersionInfo.BUILD_STAMP + lastModified + this.s;
    }

    @Autowired
    public void setAvatarManager(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Autowired
    public void setAvatarTypeInfo(AvatarTypeInfo avatarTypeInfo) {
        this.avatarTypeInfo = avatarTypeInfo;
    }
}

