/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class MersenneTwisterFast
implements Serializable,
Cloneable {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;

    public Object clone() throws CloneNotSupportedException {
        MersenneTwisterFast f2 = (MersenneTwisterFast)super.clone();
        f2.mt = (int[])this.mt.clone();
        f2.mag01 = (int[])this.mag01.clone();
        return f2;
    }

    public boolean stateEquals(Object o2) {
        int x2;
        if (o2 == this) {
            return true;
        }
        if (o2 == null || !(o2 instanceof MersenneTwisterFast)) {
            return false;
        }
        MersenneTwisterFast other = (MersenneTwisterFast)o2;
        if (this.mti != other.mti) {
            return false;
        }
        for (x2 = 0; x2 < this.mag01.length; ++x2) {
            if (this.mag01[x2] == other.mag01[x2]) continue;
            return false;
        }
        for (x2 = 0; x2 < this.mt.length; ++x2) {
            if (this.mt[x2] == other.mt[x2]) continue;
            return false;
        }
        return true;
    }

    public void readState(DataInputStream stream) throws IOException {
        int x2;
        int len = this.mt.length;
        for (x2 = 0; x2 < len; ++x2) {
            this.mt[x2] = stream.readInt();
        }
        len = this.mag01.length;
        for (x2 = 0; x2 < len; ++x2) {
            this.mag01[x2] = stream.readInt();
        }
        this.mti = stream.readInt();
        this.__nextNextGaussian = stream.readDouble();
        this.__haveNextNextGaussian = stream.readBoolean();
    }

    public void writeState(DataOutputStream stream) throws IOException {
        int x2;
        int len = this.mt.length;
        for (x2 = 0; x2 < len; ++x2) {
            stream.writeInt(this.mt[x2]);
        }
        len = this.mag01.length;
        for (x2 = 0; x2 < len; ++x2) {
            stream.writeInt(this.mag01[x2]);
        }
        stream.writeInt(this.mti);
        stream.writeDouble(this.__nextNextGaussian);
        stream.writeBoolean(this.__haveNextNextGaussian);
    }

    public MersenneTwisterFast() {
        this(System.currentTimeMillis());
    }

    public MersenneTwisterFast(long seed) {
        this.setSeed(seed);
    }

    public MersenneTwisterFast(int[] array) {
        this.setSeed(array);
    }

    public synchronized void setSeed(long seed) {
        this.__haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n2 = this.mti++;
            this.mt[n2] = this.mt[n2] & 0xFFFFFFFF;
        }
    }

    public synchronized void setSeed(int[] array) {
        int k2;
        if (array.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        this.setSeed(19650218L);
        int i2 = 1;
        int j2 = 0;
        int n2 = k2 = 624 > array.length ? 624 : array.length;
        while (k2 != 0) {
            this.mt[i2] = (this.mt[i2] ^ (this.mt[i2 - 1] ^ this.mt[i2 - 1] >>> 30) * 1664525) + array[j2] + j2;
            int n3 = i2++;
            this.mt[n3] = this.mt[n3] & 0xFFFFFFFF;
            ++j2;
            if (i2 >= 624) {
                this.mt[0] = this.mt[623];
                i2 = 1;
            }
            if (j2 >= array.length) {
                j2 = 0;
            }
            --k2;
        }
        for (k2 = 623; k2 != 0; --k2) {
            this.mt[i2] = (this.mt[i2] ^ (this.mt[i2 - 1] ^ this.mt[i2 - 1] >>> 30) * 1566083941) - i2;
            int n4 = i2++;
            this.mt[n4] = this.mt[n4] & 0xFFFFFFFF;
            if (i2 < 624) continue;
            this.mt[0] = this.mt[623];
            i2 = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    public final int nextInt() {
        int y2;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        return y2;
    }

    public final short nextShort() {
        int y2;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        return (short)(y2 >>> 16);
    }

    public final char nextChar() {
        int y2;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        return (char)(y2 >>> 16);
    }

    public final boolean nextBoolean() {
        int y2;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        return (y2 ^= y2 >>> 18) >>> 31 != 0;
    }

    public final boolean nextBoolean(float probability) {
        int y2;
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0f) {
            return false;
        }
        if (probability == 1.0f) {
            return true;
        }
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        return (float)((y2 ^= y2 >>> 18) >>> 8) / 1.6777216E7f < probability;
    }

    public final boolean nextBoolean(double probability) {
        int z2;
        int y2;
        int kk;
        int[] mag01;
        int[] mt;
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        if (this.mti >= 624) {
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        if (this.mti >= 624) {
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z2 >>> 1 ^ mag01[z2 & 1];
            }
            while (kk < 623) {
                z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z2 >>> 1 ^ mag01[z2 & 1];
                ++kk;
            }
            z2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z2 >>> 1 ^ mag01[z2 & 1];
            this.mti = 0;
        }
        z2 = this.mt[this.mti++];
        z2 ^= z2 >>> 11;
        z2 ^= z2 << 7 & 0x9D2C5680;
        z2 ^= z2 << 15 & 0xEFC60000;
        return (double)(((long)(y2 >>> 6) << 27) + (long)((z2 ^= z2 >>> 18) >>> 5)) / 9.007199254740992E15 < probability;
    }

    public final byte nextByte() {
        int y2;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        return (byte)(y2 >>> 24);
    }

    public final void nextBytes(byte[] bytes) {
        for (int x2 = 0; x2 < bytes.length; ++x2) {
            int y2;
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.mt;
                int[] mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                    ++kk;
                }
                y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            bytes[x2] = (byte)(y2 >>> 24);
        }
    }

    public final long nextLong() {
        int z2;
        int y2;
        int kk;
        int[] mag01;
        int[] mt;
        if (this.mti >= 624) {
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        if (this.mti >= 624) {
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z2 >>> 1 ^ mag01[z2 & 1];
            }
            while (kk < 623) {
                z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z2 >>> 1 ^ mag01[z2 & 1];
                ++kk;
            }
            z2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z2 >>> 1 ^ mag01[z2 & 1];
            this.mti = 0;
        }
        z2 = this.mt[this.mti++];
        z2 ^= z2 >>> 11;
        z2 ^= z2 << 7 & 0x9D2C5680;
        z2 ^= z2 << 15 & 0xEFC60000;
        z2 ^= z2 >>> 18;
        return ((long)y2 << 32) + (long)z2;
    }

    public final long nextLong(long n2) {
        long val;
        int z2;
        int y2;
        long bits;
        if (n2 <= 0L) {
            throw new IllegalArgumentException("n must be > 0");
        }
        do {
            int kk;
            int[] mag01;
            int[] mt;
            if (this.mti >= 624) {
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                    ++kk;
                }
                y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            if (this.mti >= 624) {
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ z2 >>> 1 ^ mag01[z2 & 1];
                }
                while (kk < 623) {
                    z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ z2 >>> 1 ^ mag01[z2 & 1];
                    ++kk;
                }
                z2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ z2 >>> 1 ^ mag01[z2 & 1];
                this.mti = 0;
            }
            z2 = this.mt[this.mti++];
            z2 ^= z2 >>> 11;
            z2 ^= z2 << 7 & 0x9D2C5680;
            z2 ^= z2 << 15 & 0xEFC60000;
        } while ((bits = ((long)y2 << 32) + (long)(z2 ^= z2 >>> 18) >>> 1) - (val = bits % n2) + (n2 - 1L) < 0L);
        return val;
    }

    public final double nextDouble() {
        int z2;
        int y2;
        int kk;
        int[] mag01;
        int[] mt;
        if (this.mti >= 624) {
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        if (this.mti >= 624) {
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z2 >>> 1 ^ mag01[z2 & 1];
            }
            while (kk < 623) {
                z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z2 >>> 1 ^ mag01[z2 & 1];
                ++kk;
            }
            z2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z2 >>> 1 ^ mag01[z2 & 1];
            this.mti = 0;
        }
        z2 = this.mt[this.mti++];
        z2 ^= z2 >>> 11;
        z2 ^= z2 << 7 & 0x9D2C5680;
        z2 ^= z2 << 15 & 0xEFC60000;
        z2 ^= z2 >>> 18;
        return (double)(((long)(y2 >>> 6) << 27) + (long)(z2 >>> 5)) / 9.007199254740992E15;
    }

    public final double nextGaussian() {
        int b2;
        int a2;
        double v2;
        int z2;
        int y2;
        double v1;
        double s2;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        do {
            int kk;
            int[] mag01;
            int[] mt;
            if (this.mti >= 624) {
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                    ++kk;
                }
                y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            if (this.mti >= 624) {
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ z2 >>> 1 ^ mag01[z2 & 1];
                }
                while (kk < 623) {
                    z2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ z2 >>> 1 ^ mag01[z2 & 1];
                    ++kk;
                }
                z2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ z2 >>> 1 ^ mag01[z2 & 1];
                this.mti = 0;
            }
            z2 = this.mt[this.mti++];
            z2 ^= z2 >>> 11;
            z2 ^= z2 << 7 & 0x9D2C5680;
            z2 ^= z2 << 15 & 0xEFC60000;
            z2 ^= z2 >>> 18;
            if (this.mti >= 624) {
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    a2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ a2 >>> 1 ^ mag01[a2 & 1];
                }
                while (kk < 623) {
                    a2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ a2 >>> 1 ^ mag01[a2 & 1];
                    ++kk;
                }
                a2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ a2 >>> 1 ^ mag01[a2 & 1];
                this.mti = 0;
            }
            a2 = this.mt[this.mti++];
            a2 ^= a2 >>> 11;
            a2 ^= a2 << 7 & 0x9D2C5680;
            a2 ^= a2 << 15 & 0xEFC60000;
            a2 ^= a2 >>> 18;
            if (this.mti >= 624) {
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    b2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ b2 >>> 1 ^ mag01[b2 & 1];
                }
                while (kk < 623) {
                    b2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ b2 >>> 1 ^ mag01[b2 & 1];
                    ++kk;
                }
                b2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ b2 >>> 1 ^ mag01[b2 & 1];
                this.mti = 0;
            }
            b2 = this.mt[this.mti++];
            b2 ^= b2 >>> 11;
            b2 ^= b2 << 7 & 0x9D2C5680;
            b2 ^= b2 << 15 & 0xEFC60000;
        } while ((s2 = (v1 = 2.0 * ((double)(((long)(y2 >>> 6) << 27) + (long)(z2 >>> 5)) / 9.007199254740992E15) - 1.0) * v1 + (v2 = 2.0 * ((double)(((long)(a2 >>> 6) << 27) + (long)((b2 ^= b2 >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * v2) >= 1.0 || s2 == 0.0);
        double multiplier = Math.sqrt(-2.0 * Math.log(s2) / s2);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public final float nextFloat() {
        int y2;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
            }
            while (kk < 623) {
                y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                ++kk;
            }
            y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        return (float)(y2 >>> 8) / 1.6777216E7f;
    }

    public final int nextInt(int n2) {
        int val;
        int y2;
        int bits;
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if ((n2 & -n2) == n2) {
            int y3;
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.mt;
                int[] mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y3 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y3 >>> 1 ^ mag01[y3 & 1];
                }
                while (kk < 623) {
                    y3 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y3 >>> 1 ^ mag01[y3 & 1];
                    ++kk;
                }
                y3 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y3 >>> 1 ^ mag01[y3 & 1];
                this.mti = 0;
            }
            y3 = this.mt[this.mti++];
            y3 ^= y3 >>> 11;
            y3 ^= y3 << 7 & 0x9D2C5680;
            y3 ^= y3 << 15 & 0xEFC60000;
            y3 ^= y3 >>> 18;
            return (int)((long)n2 * (long)(y3 >>> 1) >> 31);
        }
        do {
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.mt;
                int[] mag01 = this.mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                    ++kk;
                }
                y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
        } while ((bits = (y2 ^= y2 >>> 18) >>> 1) - (val = bits % n2) + (n2 - 1) < 0);
        return val;
    }
}

