/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.core.util.ImageInfo;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.Avatar;
import com.atlassian.fisheye.gravatar.AvatarManager;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.gravatar.Charlatar;
import com.atlassian.fisheye.gravatar.ImageUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.MD5;
import com.google.common.base.Strings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="avatarManager")
public class DefaultAvatarManager
implements AvatarManager {
    private static final String AVATAR_DIR_NAME = "data/avatars";
    private static final int CHARLATAR_SIZE = 200;
    private final File avatarDir = this.initAvatarDir();
    private AvatarTypeInfo avatarTypeInfo;

    @Autowired
    public DefaultAvatarManager(AvatarTypeInfo avatarTypeInfo) {
        this.avatarTypeInfo = avatarTypeInfo;
    }

    private File initAvatarDir() {
        File dir = new File(AppConfig.getVarDir(), AVATAR_DIR_NAME);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            Logs.APP_LOG.error((Object)("Could not create avatar upload directory: " + dir));
            return null;
        }
        return dir;
    }

    private void ensureInitialised() {
        this.ensureDirectory(this.avatarDir);
    }

    private void ensureDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            throw new IllegalStateException("Avatar upload directory is unavailable");
        }
    }

    private File getAvatarFile(String emailHash) {
        return new File(this.getAvatarDirectory(emailHash), emailHash + ".image");
    }

    private File getAvatarDirectory(String emailHash) {
        return new File(this.avatarDir, emailHash.substring(0, 2));
    }

    private void createAndEnsureDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.ensureDirectory(dir);
    }

    @Override
    public void saveAvatar(FecruUser user, File src) throws IOException {
        this.ensureInitialised();
        if (user == null) {
            throw new IllegalArgumentException("user must not be null");
        }
        String hash = MD5.hash(user.getUsername());
        File dir = this.getAvatarDirectory(hash);
        this.createAndEnsureDirectory(dir);
        File dest = this.getAvatarFile(hash);
        BufferedImage avatar = ImageIO.read(src);
        avatar = ImageUtils.crop(avatar);
        ImageInfo avatarInfo = ImageUtils.getImageInfo(src);
        ImageIO.write((RenderedImage)avatar, avatarInfo.getFormatName(), dest);
    }

    @Override
    public boolean hasAvatar(FecruUser user) {
        if (user == null) {
            return false;
        }
        String hash = MD5.hash(user.getUsername());
        return this.hasAvatar(hash);
    }

    private boolean hasAvatar(String usernameHashOrSpecialToken) {
        return this.avatarDir != null && !Strings.isNullOrEmpty((String)usernameHashOrSpecialToken) && !usernameHashOrSpecialToken.equals("j_doe") && !usernameHashOrSpecialToken.equals("deleted") && this.getAvatarFile(usernameHashOrSpecialToken).exists();
    }

    @Override
    public Avatar getAvatar(String usernameHashOrSpecialToken) throws IOException {
        Avatar avatar;
        String hashOrToken;
        String string = hashOrToken = usernameHashOrSpecialToken != null ? usernameHashOrSpecialToken.toLowerCase(Locale.US) : null;
        if (this.hasAvatar(hashOrToken)) {
            avatar = new Avatar(this.getAvatarFile(hashOrToken));
        } else {
            BufferedImage image;
            if ("j_doe".equals(hashOrToken)) {
                image = Charlatar.getJDoe(200);
            } else if ("deleted".equals(hashOrToken)) {
                image = Charlatar.getDeleted(200);
            } else if (hashOrToken != null && MD5.matchesMD5Pattern(hashOrToken)) {
                byte[] bytes = MD5.hexDecode(hashOrToken);
                image = Charlatar.createAvatar(bytes, 200);
            } else {
                image = Charlatar.getDefaultCharlatar(200);
            }
            avatar = new Avatar(image, "image/png", "PNG");
        }
        return avatar;
    }

    @Override
    public Avatar getAvatar(FecruUser user) throws IOException {
        String hash = user != null ? MD5.hash(user.getUsername()) : null;
        return this.getAvatar(hash);
    }

    @Override
    public Avatar getGenericAvatar() throws IOException {
        return this.getAvatar("j_doe");
    }

    @Override
    public Avatar getDeletedAvatar() throws IOException {
        return this.getAvatar("deleted");
    }

    @Override
    public Avatar getDefaultCharlatar() throws IOException {
        return this.getAvatar((String)null);
    }

    @Override
    public List<String> getPermittedContentTypes() {
        return Thumber.getThumbnailMimeTypes();
    }

    @Override
    public AvatarTypeInfo getAvatarTypeInformation() {
        return this.avatarTypeInfo;
    }

    @Override
    public long getAvatarLastModified(FecruUser user) {
        String hash = user != null ? MD5.hash(user.getUsername()) : null;
        return this.getAvatarLastModified(hash);
    }

    @Override
    public long getAvatarLastModified(String hash) {
        String string = hash = hash != null ? hash.toLowerCase(Locale.US) : null;
        if (this.hasAvatar(hash)) {
            return this.getAvatarFile(hash).lastModified();
        }
        return 0L;
    }
}

