/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fisheye.gravatar.MersenneTwister;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Charlatar {
    private static final String DEFAULT_IMAGE = "default.png";
    private static final String J_DOE = "j_doe.png";
    private static final String DELETED = "deleted.png";
    private static final String[] EYES = new String[7];
    private static final String[] MOUTH = new String[7];
    private static final String[] RARM = new String[5];
    private static final String[] RLEG = new String[5];
    private static final String[] BODY = new String[]{"body.png"};

    private static void initarray(String[] a2, String s2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = String.format("%s%02d.png", s2, i2 + 1);
        }
    }

    public static BufferedImage getJDoe(int size) throws IOException {
        return Charlatar.getSpecialImage(size, J_DOE);
    }

    public static BufferedImage getDeleted(int size) throws IOException {
        return Charlatar.getSpecialImage(size, DELETED);
    }

    public static BufferedImage getDefaultCharlatar(int size) throws IOException {
        return Charlatar.getSpecialImage(size, DEFAULT_IMAGE);
    }

    public static BufferedImage getSpecialImage(int size, String imageFileName) throws IOException {
        BufferedImage i2 = new BufferedImage(size, size, 2);
        Graphics2D g2 = i2.createGraphics();
        g2.setRenderingHints(Charlatar.hints());
        Charlatar.drawInto(g2, Charlatar.getImage(imageFileName), size);
        return i2;
    }

    public static BufferedImage createAvatar(byte[] seed, int size) throws IOException {
        MersenneTwister rnd = new MersenneTwister(seed);
        float h2 = (float)(rnd.nextInt(16) * 16) / 256.0f;
        float s2 = (float)(rnd.nextInt(3) + 1) / 4.0f;
        float b2 = (float)(rnd.nextInt(3) + 1) / 4.0f;
        BufferedImage rarm = Charlatar.rndpart(rnd, RARM);
        BufferedImage larm = Charlatar.flip(Charlatar.rndpart(rnd, RARM));
        BufferedImage rleg = Charlatar.rndpart(rnd, RLEG);
        BufferedImage lleg = Charlatar.flip(Charlatar.rndpart(rnd, RLEG));
        BufferedImage body = Charlatar.getImage(BODY[0]);
        BufferedImage eyes = Charlatar.rndpart(rnd, EYES);
        BufferedImage mouth = Charlatar.rndpart(rnd, MOUTH);
        BufferedImage i2 = new BufferedImage(size, size, 2);
        Graphics2D g2 = i2.createGraphics();
        g2.setRenderingHints(Charlatar.hints());
        Charlatar.drawInto(g2, rarm, size);
        Charlatar.drawInto(g2, larm, size);
        Charlatar.drawInto(g2, rleg, size);
        Charlatar.drawInto(g2, lleg, size);
        Charlatar.drawInto(g2, body, size);
        g2.dispose();
        i2 = Charlatar.colourize(h2, s2, b2, i2);
        g2 = i2.createGraphics();
        g2.setRenderingHints(Charlatar.hints());
        Charlatar.drawInto(g2, mouth, size);
        Charlatar.drawInto(g2, eyes, size);
        g2.dispose();
        return i2;
    }

    private static void drawInto(Graphics2D g2, BufferedImage image, int size) {
        Image i2 = image.getScaledInstance(size, size, 4);
        g2.drawImage(i2, 0, 0, null);
    }

    private static BufferedImage flip(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-image.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    private static RenderingHints hints() {
        RenderingHints h2 = new RenderingHints(null);
        h2.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        h2.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        h2.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return h2;
    }

    private static BufferedImage colourize(float h2, float s2, float br, BufferedImage i2) {
        int rgb = Color.HSBtoRGB(h2, s2, br);
        float r2 = (float)(rgb >> 16 & 0xFF) / 256.0f;
        float g2 = (float)(rgb >> 8 & 0xFF) / 256.0f;
        float b2 = (float)(rgb & 0xFF) / 256.0f;
        float[][] f2 = new float[][]{{r2, 0.0f, 0.0f, 0.0f}, {0.0f, g2, 0.0f, 0.0f}, {0.0f, 0.0f, b2, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        BandCombineOp op = new BandCombineOp(f2, null);
        WritableRaster result = op.filter(i2.getRaster(), null);
        return new BufferedImage(i2.getColorModel(), result, false, null);
    }

    private static BufferedImage background(float h2, float s2, float br, BufferedImage i2) {
        int rgb = Color.HSBtoRGB(h2, s2, br);
        float r2 = (float)(rgb >> 16 & 0xFF) / 256.0f;
        float g2 = (float)(rgb >> 8 & 0xFF) / 256.0f;
        float b2 = (float)(rgb & 0xFF) / 256.0f;
        float[][] f2 = new float[][]{{r2, 0.0f, 0.0f, 0.0f}, {0.0f, g2, 0.0f, 0.0f}, {0.0f, 0.0f, b2, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        BandCombineOp op = new BandCombineOp(f2, null);
        WritableRaster result = op.filter(i2.getRaster(), null);
        return new BufferedImage(i2.getColorModel(), result, false, null);
    }

    private static BufferedImage rndpart(MersenneTwister rnd, String[] parts) throws IOException {
        int i2 = rnd.nextInt(parts.length);
        return Charlatar.getImage(parts[i2]);
    }

    private static BufferedImage getImage(String img) throws IOException {
        return ImageIO.read(Charlatar.class.getResourceAsStream("parts/" + img));
    }

    static {
        Charlatar.initarray(EYES, "eyes-");
        Charlatar.initarray(MOUTH, "mouth-");
        Charlatar.initarray(RARM, "arm-");
        Charlatar.initarray(RLEG, "leg-");
    }
}

