/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.config.ConfigParameters;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.AvatarType;
import com.cenqua.fisheye.config1.AvatarUrlType;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="avatarTypeInfo")
public class AvatarTypeInfo {
    private static final int DEFAULT_SIZE = 48;
    public static final String J_DOE = "j_doe";
    public static final String DELETED = "deleted";
    private static final String INTERNAL_AVATAR_CONTEXT = "avatar";
    private static final String DEFAULT_EXTERNAL_AVATAR_URL = "http://www.gravatar.com/avatar/";
    private static AvatarTypeInfo STATIC_REFERENCE;
    private final ConfigParameters config;
    private Type type;

    public static String getAvatarUrlAbs(HttpServletRequest req, String username, int size, boolean noCache, boolean deleted) {
        UserManager um = SpringContext.getComponentByClass(UserManager.class);
        return AvatarTypeInfo.getAvatarUrlAbs(req, um.getEnabledUser(username).orElse(null), (Integer)size, noCache, deleted);
    }

    @Autowired
    public AvatarTypeInfo(ConfigParameters configParameters) {
        this.config = configParameters;
        AvatarType avatar = this.config.getAvatarType();
        this.type = avatar.isSetInternal() || !avatar.isSetUrl() ? Type.INTERNAL : Type.EXTERNAL;
        STATIC_REFERENCE = this;
    }

    protected AvatarType getAvatarType() {
        return this.config.getAvatarType();
    }

    public boolean isInternal() {
        return this.config.getAvatarType().isSetInternal();
    }

    public boolean isExternal() {
        return this.config.getAvatarType().isSetUrl();
    }

    public String getUrl() {
        String url;
        if (this.isExternal()) {
            url = this.config.getAvatarType().getUrl().getUrl();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = "/".equals(url) ? DEFAULT_EXTERNAL_AVATAR_URL : url;
        } else {
            url = AvatarTypeInfo.getSiteUrl() + "/" + INTERNAL_AVATAR_CONTEXT + "/";
        }
        return url;
    }

    public String getTypeString() {
        return this.getType().name().toLowerCase(Locale.US);
    }

    public Type getType() {
        return this.type;
    }

    public String getSuffix() {
        if (this.config.getAvatarType().isSetUrl()) {
            return this.config.getAvatarType().getUrl().getSuffix();
        }
        return "";
    }

    public void setType(String typeString, String url, String suffix) {
        AvatarType avatar = this.config.getAvatarType();
        if (avatar.isSetInternal()) {
            avatar.unsetInternal();
        }
        if (avatar.isSetUrl()) {
            avatar.unsetUrl();
        }
        if (avatar.isSetDisabled()) {
            avatar.unsetDisabled();
        }
        typeString = typeString != null ? typeString.toUpperCase(Locale.US) : Type.INTERNAL.name();
        Type type = Type.valueOf(typeString);
        type.setType(avatar, url, suffix);
        this.type = type;
    }

    public static String getAvatarUrl(FecruUser user, Integer size) {
        return AvatarTypeInfo.getAvatarUrl(user, size, false, false, false);
    }

    public static String getAvatarUrl(String username, Integer size) {
        UserManager um = SpringContext.getComponentByClass(UserManager.class);
        return AvatarTypeInfo.getAvatarUrl(um.getEnabledUser(username).orElse(null), size, false, false, false);
    }

    public static String getAvatarUrl(FecruUser user, Integer size, boolean noCache) {
        return AvatarTypeInfo.getAvatarUrl(user, size, noCache, false, false);
    }

    public static String getFullAvatarUrl(FecruUser user, Integer size, boolean noCache) {
        return AvatarTypeInfo.getAvatarUrl(user, size, noCache, true, false);
    }

    public static String getDeletedAvatarUrl(Integer size) {
        return AvatarTypeInfo.getAvatarUrl(null, size, false, false, true);
    }

    public static String getFullAvatarUrl(Integer size) {
        return AvatarTypeInfo.getFullAvatarUrl((FecruUser)null, size);
    }

    public static String getFullAvatarUrl(String username, Integer size) {
        UserManager um = SpringContext.getComponentByClass(UserManager.class);
        return AvatarTypeInfo.getFullAvatarUrl(um.getEnabledUser(username).orElse(null), size);
    }

    public static String getFullAvatarUrl(FecruUser user, Integer size) {
        return AvatarTypeInfo.getAvatarUrl(user, size, false, true, false);
    }

    public static String getUnknownAvatarUrl(Integer size) {
        return AvatarTypeInfo.getAvatarUrl(null, size, false);
    }

    public static String getFullUnknownAvatarUrl(Integer size) {
        return AvatarTypeInfo.getFullAvatarUrl((FecruUser)null, size);
    }

    private static String getSiteUrl() {
        return AvatarTypeInfo.STATIC_REFERENCE.config.getSiteURL();
    }

    public static String getAvatarUrlAbs(HttpServletRequest request, FecruUser user, Integer size, boolean noCache, boolean deleted) {
        return STATIC_REFERENCE.getAvatarUrl(request == null ? AvatarTypeInfo.getSiteUrl() : ServletUtils.getBaseUrl(request), user, size, noCache, deleted);
    }

    public static String getAvatarUrl(FecruUser user, Integer size, boolean noCache, boolean fullUrls, boolean deleted) {
        return STATIC_REFERENCE.getAvatarUrl(fullUrls ? AvatarTypeInfo.getSiteUrl() : AvatarTypeInfo.STATIC_REFERENCE.config.getContextPath(), user, size, noCache, deleted);
    }

    private String getAvatarUrl(String contextPath, FecruUser user, Integer size, boolean noCache, boolean deleted) {
        return deleted ? this.deletedUrl(contextPath, size, noCache) : this.customAvatarUrl(contextPath, user, size, noCache);
    }

    private static String getParamString(Integer size, boolean noCache) {
        String paramString = "?s=" + (size != null ? size : 48);
        if (noCache) {
            paramString = paramString + (Strings.isNullOrEmpty((String)paramString) ? "?noCache=true" : "&noCache=true");
        }
        return paramString;
    }

    public String getExternalAvatarUrl(FecruUser user, Integer size) {
        UrlHelper fallbackUrl = new UrlHelper();
        String email = user.getEmail() != null ? user.getEmail().toLowerCase(Locale.US).trim() : user.getUsername().trim();
        fallbackUrl.setEncodedUrl(this.getUrl() + MD5.hash(email));
        fallbackUrl.putParam("s", size != null ? size : 48);
        if (this.isExternal()) {
            fallbackUrl.putParam("d", "mm");
        }
        fallbackUrl.parseAndAddParams(this.getSuffix());
        return fallbackUrl.toString();
    }

    private String customAvatarUrl(String contextPath, FecruUser user, Integer size, boolean noCache) {
        if (user == null) {
            return this.internalUrl(contextPath, J_DOE, size, noCache);
        }
        if (this.isExternal()) {
            return this.getExternalAvatarUrl(user, size);
        }
        return this.internalUrl(contextPath, user.getUsername(), size, noCache);
    }

    private String deletedUrl(String contextPath, Integer size, boolean noCache) {
        return this.internalUrl(contextPath, DELETED, size, noCache);
    }

    private String internalUrl(String contextPath, String emailHash, Integer size, boolean noCache) {
        UrlHelper urlHelper = new UrlHelper();
        urlHelper.setUrl(INTERNAL_AVATAR_CONTEXT);
        String paramString = AvatarTypeInfo.getParamString(size, noCache);
        return String.format("%s/%s/%s%s", contextPath, INTERNAL_AVATAR_CONTEXT, FishEyeURLEncoder.uriEncode(emailHash), paramString);
    }

    public static enum Type {
        INTERNAL{

            @Override
            protected void setType(AvatarType avatar, String url, String suffix) {
                avatar.addNewInternal();
            }
        }
        ,
        EXTERNAL{

            @Override
            protected void setType(AvatarType avatar, String url, String suffix) {
                AvatarUrlType avatarUrlType = avatar.addNewUrl();
                avatarUrlType.setUrl(url);
                avatarUrlType.setSuffix(suffix);
            }
        };


        protected abstract void setType(AvatarType var1, String var2, String var3);
    }
}

