/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.gravatar;

import com.atlassian.core.util.ImageInfo;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.fisheye.gravatar.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class Avatar {
    private static Thumber thumber = new Thumber(Thumbnail.MimeType.PNG);
    private Image image;
    private String contentType;
    private String formatName;

    public Avatar(File sourceFile) throws IOException {
        this(thumber.getImage(sourceFile), ImageUtils.getImageInfo(sourceFile));
    }

    public Avatar(Image image, ImageInfo imageInfo) {
        this(image, imageInfo.getMimeType(), imageInfo.getFormatName());
    }

    public Avatar(Image image, String contentType, String formatName) {
        this.image = image;
        this.contentType = contentType;
        this.formatName = formatName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Image getImage() {
        return this.image;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public BufferedImage getThumbnail(int size) throws IOException {
        if (this.image instanceof BufferedImage && ((BufferedImage)this.image).getHeight() == size && ((BufferedImage)this.image).getWidth() == size) {
            return (BufferedImage)this.image;
        }
        Thumber.WidthHeightHelper dimension = new Thumber.WidthHeightHelper(size, size);
        return thumber.scaleImage(this.image, dimension);
    }
}

