/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.db;

import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitChangeSetDAO;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.git.db.GitStringTables;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GitRevInfoDAO
extends DvcsRevInfoDAO<GitRevInfo, GitStringTables> {
    private GitChangeSetDAO csDAO;

    public GitRevInfoDAO(String repositoryName, InfinityDbHandle dbh, GitStringTables stringTables, LicenseEnforcer licenseEnforcer) {
        super(repositoryName, dbh, stringTables, licenseEnforcer);
    }

    public void setChangeSetDAO(GitChangeSetDAO csDAO) {
        this.csDAO = csDAO;
    }

    @Override
    public int insertNew(GitRevInfo revision, AncestorLink ancestorLink, boolean storeDiffs) throws DbException, LicensePolicyException {
        int revid = super.insertNew(revision, ancestorLink, storeDiffs);
        long commitId = ((GitStringTables)this.stringTables).changeSetIdDB.add(revision.getChangeSetId());
        this.commonDAO.addPathLongProperty(DvcsSchema.I_PATHID_COMMIT, revision.getPath(), revision.getDate(), commitId);
        if (revision.getDestHash() == null) {
            Logs.APP_LOG.warn((Object)("Storing revision without a content hash: " + revision.getRevInfoKey()));
        }
        long destHashId = ((GitStringTables)this.stringTables).contentHashDB.add(revision.getDestHash());
        this.commonDAO.addRevIdLongProperty(DvcsSchema.Git.I_REVID_DESTHASH, revid, destHashId);
        if (!revision.getDestHash().equals("0000000000000000000000000000000000000000")) {
            this.commonDAO.addRevidLongIndex(DvcsSchema.Git.I_DESTHASH_REVID, destHashId, revid);
        }
        this.commonDAO.addRevIdLongProperty(DvcsSchema.Git.I_REVID_DESTMODE, revid, revision.getDestMode());
        long srcHashId = ((GitStringTables)this.stringTables).contentHashDB.add(revision.getSrcHash());
        this.commonDAO.addRevIdLongProperty(DvcsSchema.Git.I_REVID_SRCHASH, revid, srcHashId);
        long pathId = this.commonDAO.getPathId(revision.getPath());
        this.commonDAO.addRevIdLongProperty(DvcsSchema.I_REVID_PATHID, revid, pathId);
        EavEntityCu eav = this.commonDAO.makeEav(revid);
        try {
            eav.addString(DvcsSchema.Git.A_EMAIL, revision.getEmail());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return revid;
    }

    public Iterable<GitRevInfo> getRevisionsAtBranchHead(String branchName) throws DbException {
        y cu = y.a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(branchName);
        int pl = cu.e();
        return new InfDbIterable<GitRevInfo>(this.dbh, cu, pl){

            @Override
            public GitRevInfo getElement(y cu, int elementOffset) throws IOException, DbException {
                int revid = (int)cu.v(elementOffset);
                return (GitRevInfo)GitRevInfoDAO.this.loadLazy(revid);
            }
        };
    }

    public List<GitRevInfo> getFileRevisionsForContentHash(String hash, Path path) throws DbException {
        if (hash == null) {
            return Collections.emptyList();
        }
        long hashId = ((GitStringTables)this.stringTables).contentHashDB.find(hash);
        if (hashId == -1L) {
            return Collections.emptyList();
        }
        IntList revids = this.commonDAO.getIndexedRevIds(DvcsSchema.Git.I_DESTHASH_REVID, hashId);
        ArrayList<GitRevInfo> revisions = new ArrayList<GitRevInfo>();
        long pathIdForPath = path == null ? -1L : this.commonDAO.getPathId(path);
        for (int i2 = 0; i2 < revids.size(); ++i2) {
            long pathId = this.commonDAO.getLongProperty(DvcsSchema.I_REVID_PATHID, revids.getInt(i2), -1L);
            if (pathId == -1L || path != null && pathId != pathIdForPath) continue;
            revisions.add((GitRevInfo)this.loadLazy(revids.getInt(i2)));
        }
        return revisions;
    }

    public List<String> resolveContentHash(final String shortContent) throws DbException {
        final ArrayList<String> contentStrings = new ArrayList<String>(1);
        if (shortContent != null) {
            ((GitStringTables)this.stringTables).contentHashDB.visit(new UniqueStringTable.Visitor(){

                @Override
                public boolean visit(long id, CharSequence s2) {
                    if (s2 != null && s2.length() >= shortContent.length() && s2.subSequence(0, shortContent.length()).equals(shortContent)) {
                        contentStrings.add(s2.toString());
                    }
                    return true;
                }
            }, 0);
        }
        return contentStrings;
    }

    @Override
    public GitRevInfo load(int revid) throws DbException {
        GitRevInfo revInfo = null;
        if (this.commonDAO.exists(revid)) {
            try {
                revInfo = new GitRevInfo();
                this.commonDAO.load(revid, revInfo);
                revInfo.setDestHash(this.getDestHash(revid));
                revInfo.setSrcHash(this.getSrcHash(revid));
                revInfo.setDestMode((int)this.commonDAO.getLongProperty(DvcsSchema.Git.I_REVID_DESTMODE, revid, 0L));
                EavEntityCu eav = this.commonDAO.makeEav(revid);
                revInfo.setEmail(eav.getString(DvcsSchema.Git.A_EMAIL, null));
                if (this.csDAO != null) {
                    revInfo.setChangeSet((GitChangeSet)this.csDAO.load(revInfo.getChangeSetId()));
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Exception", (Throwable)e2);
                revInfo = null;
            }
            catch (IOException e3) {
                Logs.APP_LOG.warn((Object)"Exception", (Throwable)e3);
                revInfo = null;
            }
        } else {
            Logs.APP_LOG.warn((Object)("Could not find revision " + revid));
        }
        return revInfo;
    }

    public String getDestHash(int revid) throws DbException {
        return this.getContentHash(DvcsSchema.Git.I_REVID_DESTHASH, revid);
    }

    private String getContentHash(I index, int revid) throws DbException {
        long hashId = this.commonDAO.getLongProperty(index, revid, -1L);
        if (hashId != -1L) {
            return ((GitStringTables)this.stringTables).contentHashDB.get(hashId);
        }
        return null;
    }

    public String getSrcHash(int revid) throws DbException {
        return this.getContentHash(DvcsSchema.Git.I_REVID_SRCHASH, revid);
    }
}

