/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.db;

import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.git.db.GitRevInfoDAO;
import com.atlassian.fisheye.git.db.GitStringTables;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class GitChangeSetDAO
extends DvcsChangeSetDAO<GitRevInfo, GitChangeSet, GitStringTables> {
    public GitChangeSetDAO(RepositoryStatus status, InfinityDbHandle dbh, GitStringTables stringTables, GitRevInfoDAO revDAO, LicenseEnforcer licenseEnforcer) {
        super(status, dbh, stringTables, revDAO, licenseEnforcer);
    }

    @Override
    public GitChangeSet createChangeSet(String csid) {
        return new GitChangeSet(csid, this, (GitRevInfoDAO)this.fileRevDAO);
    }

    @Override
    public boolean supportsCreatedOnBranch() {
        return false;
    }

    @Override
    public Set<String> getChangeSetAncestors(String csId, int limit, @Nullable Iterable<Branch> excludedBranches, @Nullable AtomicReference<String> topmostBranchPointCsId) {
        if (excludedBranches == null) {
            return super.getChangeSetAncestors(csId, limit, excludedBranches, topmostBranchPointCsId);
        }
        try {
            Function csDbIdToCsId = ((GitStringTables)this.stringTables).changeSetIdDB.idToString();
            ImmutableSet excludedBranchesNames = ImmutableSet.copyOf((Iterable)Iterables.transform(excludedBranches, Branch.TO_NAME));
            long topmostBranchPointCsDbId = -1L;
            LinkedHashSet<Long> ancestryCsDbIds = new LinkedHashSet<Long>();
            LinkedList<Long> csToDo = new LinkedList<Long>();
            csToDo.add(this.getDbId(csId));
            while (!csToDo.isEmpty() && ancestryCsDbIds.size() < limit) {
                long csDbId = (Long)csToDo.poll();
                if (csDbId == -1L) continue;
                if (Collections.disjoint(this.getBranchesContributedTo(csDbId), excludedBranchesNames)) {
                    if (!ancestryCsDbIds.add(csDbId)) continue;
                    csToDo.addAll((Collection<Long>)this.getExistingParentDbIds(csDbId));
                    continue;
                }
                if (topmostBranchPointCsDbId >= csDbId) continue;
                topmostBranchPointCsDbId = csDbId;
            }
            if (topmostBranchPointCsId != null) {
                topmostBranchPointCsId.set(((GitStringTables)this.stringTables).changeSetIdDB.get(topmostBranchPointCsDbId));
            }
            return ImmutableSet.copyOf((Iterable)Iterables.transform(ancestryCsDbIds, csDbIdToCsId));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

