/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.cenqua.fisheye.logging.Logs;
import java.nio.charset.Charset;

class GitRemoteShowOutputHandler
extends BaseLineOutputHandler {
    private static final String GIT_REMOTE_SHOW_HEAD_BRANCH_PREFIX = "HEAD branch:";
    private static final String GIT_REMOTE_SHOW_AMBIGOUS_HEAD_BRANCH_PREFIX = "HEAD branch (remote HEAD is ambiguous, may be one of the following):";
    private static final String UNKNOWN_HEAD_BRANCH_STRING = "(unknown)";
    private String result;
    private boolean ambiguousHead;

    public GitRemoteShowOutputHandler(Charset encoding) {
        super(encoding);
    }

    protected void processLine(int lineNum, String line) {
        String trimmed = line.trim();
        if (trimmed.startsWith(GIT_REMOTE_SHOW_HEAD_BRANCH_PREFIX)) {
            this.result = trimmed.substring(GIT_REMOTE_SHOW_HEAD_BRANCH_PREFIX.length()).trim();
        } else if (trimmed.startsWith(GIT_REMOTE_SHOW_AMBIGOUS_HEAD_BRANCH_PREFIX)) {
            this.ambiguousHead = true;
        } else if (this.ambiguousHead && this.result == null) {
            this.result = trimmed;
            Logs.APP_LOG.debug((Object)("Got ambiguous heads from git remote-show, using " + this.result));
        }
    }

    public String getResult() {
        return UNKNOWN_HEAD_BRANCH_STRING.equals(this.result) ? null : this.result;
    }
}

