/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.security.SshWrapper;
import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsProcessFactory;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessHandler;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="gitProcessFactory")
public class GitProcessFactory
extends DvcsProcessFactory {
    @Inject
    public GitProcessFactory(SshKeyManager sshKeyManager) {
        super(sshKeyManager);
    }

    @Override
    public DvcsProcessFactory.DvcsProcessBuilder<?> builder(DvcsScmConfig config, DvcsCommandBuilder command, ProcessHandler handler, File workingDir) {
        return new GitProcessBuilder(config, command, handler, workingDir);
    }

    private class GitProcessBuilder
    extends DvcsProcessFactory.DvcsProcessBuilder<GitProcessBuilder> {
        protected GitProcessBuilder(DvcsScmConfig config, DvcsCommandBuilder command, ProcessHandler handler, File workingDir) {
            super(config, command, handler, workingDir);
        }

        @Override
        protected ExternalProcessBuilder initProcessBuilder() {
            ExternalProcessBuilder processBuilder = super.initProcessBuilder();
            if (this.config.isSshAuthenticatedRepo()) {
                processBuilder.env("GIT_SSH", SshWrapper.getSshWrapperCmd(true));
            }
            return processBuilder;
        }
    }
}

