/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.GitTreeNode;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitListTreeOutputHandler
extends BaseLineOutputHandler {
    private static final Pattern TREE_LIST_PATTERN = Pattern.compile("([0-9a-f]{6}) +([^ ]+) *([0-9a-f]{40})\t*(.*)");
    private static final int PERMISSION_GROUP = 1;
    private static final int TYPE_GROUP = 2;
    private static final int HASH_GROUP = 3;
    private static final int NAME_GROUP = 4;
    private Set<GitTreeNode> treeNodes = new HashSet<GitTreeNode>();

    public GitListTreeOutputHandler(Charset encoding, String loggingContext) {
        super(encoding, loggingContext);
    }

    protected void processLine(int lineNum, String line) {
        Matcher matcher = TREE_LIST_PATTERN.matcher(line);
        if (matcher.matches()) {
            GitTreeNode.Type nodeType = null;
            try {
                nodeType = GitTreeNode.Type.valueOf(matcher.group(2).toUpperCase().trim());
            }
            catch (IllegalArgumentException ex) {
                Logs.APP_LOG.warn((Object)("Attempting to process git ls-tree output with invalid object type '" + matcher.group(2) + "'," + " Full output: " + line), (Throwable)ex);
            }
            if (nodeType != null) {
                this.treeNodes.add(new GitTreeNode(matcher.group(1), nodeType, matcher.group(3), matcher.group(4)));
            }
        } else {
            this.reportNonMatchingLine(line);
        }
    }

    public Set<GitTreeNode> getTreeNodes() {
        return this.treeNodes;
    }
}

