/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.utils.process.LineOutputHandler;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public abstract class GitListBranchesOutputHandler
extends LineOutputHandler {
    private static final Pattern BRANCH_LIST_PATTERN = Pattern.compile("^([0-9a-f]{40}) refs/heads/(.+)$");
    private static final int NAME_GROUP = 2;
    private static final int HEAD_GROUP = 1;

    public GitListBranchesOutputHandler(String encoding) {
        super(encoding);
    }

    protected void processLine(int lineNum, String line) {
        Matcher matcher = BRANCH_LIST_PATTERN.matcher(line);
        if (matcher.find()) {
            Branch branch = new Branch(matcher.group(2), matcher.group(1), BranchState.ACTIVE);
            this.processBranch(branch);
        } else {
            Logs.APP_LOG.warn((Object)("Failed parsing branch from line " + line));
            Logs.APP_LOG.debug((Object)("Encoding is: " + this.getEncoding() + ", line is: " + new String(Hex.encodeHex((byte[])line.getBytes()))));
        }
    }

    protected abstract void processBranch(Branch var1);
}

