/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.text.ParsePosition;

public class GitEscape {
    public static String unescape(String s2) {
        if (s2 == null) {
            return s2;
        }
        int start = 0;
        int end = s2.length();
        if (s2.matches("\".*\"")) {
            ++start;
            --end;
        }
        byte[] bytes = new byte[end - start];
        int index = 0;
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '\\') {
                ParsePosition p2 = new ParsePosition(++i2);
                c2 = GitEscape.doSingleGitEscape(s2, p2);
                i2 = p2.getIndex() - 1;
            }
            bytes[index++] = (byte)c2;
        }
        try {
            String newString = new String(bytes, 0, index, "UTF-8");
            newString = Normalizer.normalize(newString, Normalizer.Form.NFC);
            return newString;
        }
        catch (UnsupportedEncodingException e2) {
            return new String(bytes, 0, index);
        }
    }

    public static String unescapeQuoted(String s2) {
        if (s2 != null && s2.matches("\".*\"")) {
            return GitEscape.unescape(s2);
        }
        return s2;
    }

    public static char doSingleGitEscape(String gitString, ParsePosition p2) {
        int end = gitString.length();
        int temp = p2.getIndex();
        char c2 = '\\';
        if (temp < end) {
            c2 = gitString.charAt(temp++);
            switch (c2) {
                case 't': {
                    c2 = '\t';
                    break;
                }
                case 'n': {
                    c2 = '\n';
                    break;
                }
                case '\"': {
                    c2 = '\"';
                    break;
                }
                case '\\': {
                    c2 = '\\';
                    break;
                }
                case 'r': {
                    c2 = '\r';
                    break;
                }
                default: {
                    int digit;
                    if (!Character.isDigit(c2) || (digit = c2 - 48) < 0 || digit > 7) break;
                    c2 = (char)digit;
                    if (temp >= end || (digit = gitString.charAt(temp++) - 48) < 0 || digit > 7) break;
                    c2 = (char)(c2 * 8 + digit);
                    if (temp >= end || (digit = gitString.charAt(temp++) - 48) < 0 || digit > 7) break;
                    c2 = (char)(c2 * 8 + digit);
                }
            }
        }
        p2.setIndex(temp);
        return c2;
    }
}

