/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.GitEscape;
import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.crucible.revision.diff.unified.GitDiffListener;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.diff.UnifiedDiffSectionSpec;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GitDiffParser {
    public static final Pattern DIFF_PATTERN = Pattern.compile("^diff --git (.*)$");
    private static final Pattern FILE_MODE_PATTERN = Pattern.compile("(new file mode|new mode|old mode|deleted file mode) ([0-9]+)");
    private static final String COPY_FROM = "copy from";
    private static final String RENAME_FROM = "rename from";
    private static final String COPY_TO = "copy to";
    private static final String RENAME_TO = "rename to";
    private static final Pattern COPY_MOVE_PATTERN = Pattern.compile("(copy from|copy to|rename from|rename to) (.+)");
    private static final String DISSIMILARITY_INDEX = "dissimilarity index";
    private static final String SIMILARITY_INDEX = "similarity index";
    private static final Pattern SIMILARITY_PATTERN = Pattern.compile("(similarity index|dissimilarity index) (.+)");
    private static final Pattern INDEX_PATTERN = Pattern.compile("index ([0-9a-fA-F]+)\\.\\.([0-9a-fA-F]+)(| [0-9]+)");
    private static final String COMBO_REGEX = "(@@ *-([0-9]*)(|,([0-9]*)) *(|\\+([0-9]*)(|,([0-9]*))) *@@)(.+)";
    private static final Pattern COMBO_SECTION_LINE = Pattern.compile("(@@ *-([0-9]*)(|,([0-9]*)) *(|\\+([0-9]*)(|,([0-9]*))) *@@)(.+)");
    private static final Pattern BINARY_PATCH_MATCHER = Pattern.compile("(GIT binary patch|Binary file .*)");
    private final String srcPrefix;
    private final String destPrefix;
    private ParserState state;
    private boolean unescapePaths;
    private GitDiffListener gitDiffListener;

    public GitDiffParser(GitDiffListener gitDiffListener, String srcPrefix, String destPrefix, boolean unescapePaths) {
        this.gitDiffListener = gitDiffListener;
        this.srcPrefix = srcPrefix;
        this.destPrefix = destPrefix;
        this.unescapePaths = unescapePaths;
        this.state = ParserState.DIFF_SEARCH;
    }

    public ParserState processLine(String line) throws DbException {
        Matcher diffHeaderMatcher = DIFF_PATTERN.matcher(line);
        if (diffHeaderMatcher.matches()) {
            this.extractPathsFromDiffHeader(diffHeaderMatcher);
        } else {
            switch (this.state) {
                case DIFF_SEARCH: {
                    break;
                }
                case DIFF_HEADER: {
                    this.findFromToHeader(line);
                    if (this.state != ParserState.DIFF_HEADER) break;
                    this.findOptionalHeaders(line);
                    break;
                }
                case DIFF_STARTED: {
                    this.findFromToHeader(line);
                    break;
                }
                case SEARCH_SECTION: {
                    this.searchSection(line);
                    break;
                }
                case IN_SECTION: {
                    this.addRemoveLine(line);
                    break;
                }
                default: {
                    throw new DbException("Unhandled state: " + (Object)((Object)this.state));
                }
            }
        }
        return this.state;
    }

    private void findFromToHeader(String line) {
        Matcher fromHeaderMatcher = DiffMatcher.FROM_HEADER.matcher(line);
        if (fromHeaderMatcher.matches()) {
            this.gitDiffListener.fromHeader(fromHeaderMatcher.group(1));
            this.state = ParserState.DIFF_STARTED;
        } else {
            Matcher toHeaderMatcher = DiffMatcher.TO_HEADER.matcher(line);
            if (toHeaderMatcher.matches()) {
                this.gitDiffListener.toHeader(toHeaderMatcher.group(1));
                this.state = ParserState.DIFF_STARTED;
            } else if (line.matches(COMBO_REGEX) || UnifiedDiffSectionSpec.isValidSection(line)) {
                this.searchSection(line);
            } else if (line.startsWith("Binary file") || line.startsWith("GIT binary patch")) {
                this.gitDiffListener.binaryHeader();
                this.state = ParserState.DIFF_SEARCH;
            }
        }
    }

    private void searchSection(String line) {
        if (line.matches(COMBO_REGEX)) {
            Matcher sectionMatcher = COMBO_SECTION_LINE.matcher(line);
            if (sectionMatcher.matches()) {
                this.gitDiffListener.section(sectionMatcher.group(1));
            }
        } else if (UnifiedDiffSectionSpec.isValidSection(line)) {
            this.gitDiffListener.section(line);
        } else {
            return;
        }
        this.state = ParserState.IN_SECTION;
    }

    private void extractPathsFromDiffHeader(Matcher diffHeaderMatcher) {
        String diffSpec = diffHeaderMatcher.group(1);
        ParsePosition pos = new ParsePosition(0);
        String fromPath = this.extractDiffPath(diffSpec, pos, this.unescapePaths, this.srcPrefix, this.destPrefix);
        String toPath = this.extractDiffPath(diffSpec, pos, this.unescapePaths, this.destPrefix, null);
        this.gitDiffListener.diffHeader(fromPath, toPath);
        this.state = ParserState.DIFF_HEADER;
    }

    private String extractDiffPath(String diffSpec, ParsePosition pos, boolean unescapePaths, String prefix, String suffix) {
        int currentIndex;
        byte[] result = new byte[diffSpec.getBytes().length];
        int resultIndex = 0;
        int endIndex = diffSpec.length();
        for (currentIndex = pos.getIndex(); currentIndex < endIndex && diffSpec.charAt(currentIndex) == ' '; ++currentIndex) {
        }
        if (currentIndex < endIndex) {
            char c2;
            boolean quoted;
            boolean bl = quoted = diffSpec.charAt(currentIndex) == '\"';
            if (quoted) {
                ++currentIndex;
            }
            while (!(currentIndex >= endIndex || (c2 = diffSpec.charAt(currentIndex++)) == '\"' && quoted)) {
                if (c2 == ' ' && !quoted) {
                    if (this.diffSpecRemainderStartWithPrefix(diffSpec.substring(currentIndex), suffix)) {
                        break;
                    }
                } else if (c2 == '\\' && unescapePaths) {
                    ParsePosition p2 = new ParsePosition(currentIndex);
                    c2 = GitEscape.doSingleGitEscape(diffSpec, p2);
                    currentIndex = p2.getIndex();
                }
                result[resultIndex++] = (byte)c2;
            }
        }
        pos.setIndex(currentIndex);
        try {
            String diffPath = new String(result, 0, resultIndex, "UTF-8");
            diffPath = Normalizer.normalize(diffPath, Normalizer.Form.NFC);
            if (diffPath.startsWith(prefix)) {
                diffPath = diffPath.substring(prefix.length());
            } else {
                Logs.APP_LOG.warn((Object)("Diff path " + diffPath + " from " + diffSpec + " did not start with expected prefix: " + prefix));
            }
            return diffPath;
        }
        catch (UnsupportedEncodingException e2) {
            return new String(result, 0, resultIndex);
        }
    }

    private boolean diffSpecRemainderStartWithPrefix(String remainder, String suffix) {
        return suffix != null && (remainder.startsWith(suffix) || remainder.startsWith("\"" + suffix) && remainder.trim().endsWith("\""));
    }

    private void findOptionalHeaders(String line) {
        Matcher fileModeMatcher = FILE_MODE_PATTERN.matcher(line);
        if (fileModeMatcher.matches()) {
            String operator = fileModeMatcher.group(1);
            String mode = fileModeMatcher.group(2);
            this.gitDiffListener.fileChangeInfo(operator, mode);
        } else {
            Matcher copyMoveMatcher = COPY_MOVE_PATTERN.matcher(line);
            if (copyMoveMatcher.matches()) {
                String operator = copyMoveMatcher.group(1);
                String path = copyMoveMatcher.group(2);
                if (operator.equals(COPY_FROM)) {
                    this.gitDiffListener.copyFrom(path);
                } else if (operator.equals(RENAME_FROM)) {
                    this.gitDiffListener.renameFrom(path);
                } else if (operator.equals(RENAME_TO)) {
                    this.gitDiffListener.renameTo(path);
                } else if (operator.equals(COPY_TO)) {
                    this.gitDiffListener.copyTo(path);
                }
            } else {
                Matcher similarityMatcher = SIMILARITY_PATTERN.matcher(line);
                if (similarityMatcher.matches()) {
                    String operator;
                    double similarityValue = 0.0;
                    String similarityValueString = similarityMatcher.group(2).trim();
                    if (similarityValueString.endsWith("%")) {
                        try {
                            similarityValue = Double.parseDouble(StringUtils.stripEnd((String)similarityValueString, (String)"%")) / 100.0;
                        }
                        catch (NumberFormatException e2) {
                            Logs.APP_LOG.warn((Object)("Unrecognized similarity value: " + similarityValueString));
                        }
                    }
                    if ((operator = similarityMatcher.group(1)).equals(DISSIMILARITY_INDEX)) {
                        similarityValue = 1.0 - similarityValue;
                    }
                    this.gitDiffListener.similarityIndex(operator, similarityValue);
                } else {
                    Matcher indexMatcher = INDEX_PATTERN.matcher(line);
                    if (indexMatcher.matches()) {
                        String hash1 = indexMatcher.group(1);
                        String hash2 = indexMatcher.group(2);
                        String mode = indexMatcher.group(3);
                        this.gitDiffListener.revisionInfo(hash1, hash2, mode);
                    } else {
                        Matcher diffHeaderMatcher = DIFF_PATTERN.matcher(line);
                        if (diffHeaderMatcher.matches()) {
                            this.extractPathsFromDiffHeader(diffHeaderMatcher);
                        } else {
                            Matcher binaryMatcher = BINARY_PATCH_MATCHER.matcher(line);
                            if (binaryMatcher.matches()) {
                                this.gitDiffListener.binaryHeader();
                                this.state = ParserState.DIFF_SEARCH;
                            } else {
                                Logs.APP_LOG.debug((Object)("Unexpected line when processing diff header: " + line));
                            }
                        }
                    }
                }
            }
        }
    }

    private void addRemoveLine(String line) {
        if (line.startsWith("+")) {
            this.gitDiffListener.addLine(line.substring(1));
        } else if (line.startsWith("-")) {
            this.gitDiffListener.removeLine(line.substring(1));
        } else {
            this.state = ParserState.SEARCH_SECTION;
            this.searchSection(line);
        }
    }

    public static enum ParserState {
        DIFF_SEARCH,
        DIFF_HEADER,
        DIFF_STARTED,
        SEARCH_SECTION,
        IN_SECTION;

    }
}

