/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.dvcs.client.DvcsLineOutputHandler;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.atlassian.fisheye.git.client.GitDiffParser;
import com.cenqua.crucible.revision.diff.unified.GitDiffListener;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.diff.UnifiedDiffSectionSpec;
import java.nio.charset.Charset;

public abstract class GitDiffOutputHandler
extends DvcsLineOutputHandler
implements GitDiffListener {
    private final RepositoryStatus status;
    private GitDiffInfo currentInfo;
    public DiffTextCache diffTextCache;
    private GitCommitDetails commitDetails;
    private String parentChangesetId;
    private GitDiffParser parser;

    public GitDiffOutputHandler(RepositoryStatus status, Charset encoding, DiffTextCache diffTextCache) {
        this(status, encoding, diffTextCache, true);
    }

    protected GitDiffOutputHandler(RepositoryStatus status, Charset encoding, DiffTextCache diffTextCache, boolean unescapePaths) {
        super(encoding, true);
        this.diffTextCache = diffTextCache;
        this.status = status;
        this.parser = new GitDiffParser(this, "a/", "b/", unescapePaths);
    }

    public void setCommitDetails(GitCommitDetails commitDetails) {
        this.commitDetails = commitDetails;
    }

    @Override
    public void binaryHeader() {
        this.currentInfo.setBinary(true);
    }

    @Override
    public void section(String sectionHeader) {
        UnifiedDiffSectionSpec diffHunk = new UnifiedDiffSectionSpec(sectionHeader);
        Hunk hunk = new Hunk(diffHunk.getFrom(), diffHunk.getTo(), diffHunk.getFromCount(), diffHunk.getToCount());
        this.currentInfo.addHunk(hunk);
    }

    @Override
    public void diffHeader(String fromPath, String toPath) {
        if (this.currentInfo != null) {
            this.processDiffInfo(this.currentInfo);
            if (this.diffTextCache != null) {
                this.diffTextCache.finishFileRevision();
            }
        }
        this.currentInfo = new GitDiffInfo(fromPath, toPath);
        Logs.APP_LOG.debug((Object)("Processing diff from " + fromPath + " to " + toPath));
        this.currentInfo.setParentChangesetId(this.parentChangesetId);
        if (this.diffTextCache != null) {
            this.diffTextCache.startFileRevision(false, this.currentInfo);
        }
    }

    @Override
    public void revisionInfo(String fromRev, String toRev, String mode) {
        this.currentInfo.setFromContentHash(fromRev);
        this.currentInfo.setToContentHash(toRev);
        if (mode.trim().length() != 0) {
            this.currentInfo.setFileMode(mode.trim());
        }
    }

    @Override
    public void similarityIndex(String operator, double similarityValue) {
        this.currentInfo.setSimilarityValue(similarityValue);
    }

    @Override
    public void renameFrom(String path) {
        this.currentInfo.setRenameFromPath(path);
    }

    @Override
    public void copyFrom(String path) {
        this.currentInfo.setCopyFromPath(path);
    }

    @Override
    public void renameTo(String path) {
    }

    @Override
    public void copyTo(String path) {
    }

    @Override
    public void fileChangeInfo(String operator, String mode) {
        this.currentInfo.setFileMode(mode);
    }

    @Override
    public void removeLine(String line) {
        if (this.diffTextCache != null) {
            this.diffTextCache.removeLine(line);
        }
    }

    @Override
    public void addLine(String line) {
        if (this.diffTextCache != null) {
            this.diffTextCache.addLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        GitDiffOutputHandler gitDiffOutputHandler = this;
        synchronized (gitDiffOutputHandler) {
            if (this.currentInfo != null) {
                this.processDiffInfo(this.currentInfo);
                if (this.diffTextCache != null) {
                    this.diffTextCache.finishFileRevision();
                }
                this.currentInfo = null;
            }
        }
    }

    @Override
    public void toHeader(String path) {
    }

    @Override
    public void fromHeader(String path) {
    }

    protected GitCommitDetails getCommitDetails() {
        return this.commitDetails;
    }

    protected abstract void processDiffInfo(GitDiffInfo var1);

    public void setParentChangesetId(String parentChangesetId) {
        this.parentChangesetId = parentChangesetId;
    }

    public void processLine(int lineNum, String line) {
        if (this.status.isStopRequested()) {
            this.cancelProcess();
            throw new RuntimeException("Repository is stopping");
        }
        this.parser.processLine(line);
    }
}

