/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.impl.CommonChangeInfo;
import java.util.List;

public class GitDiffInfo
extends CommonChangeInfo {
    private String toPath;
    private String parentChangesetId;
    private String fileMode;
    private String fromContentHash;
    private String toContentHash;
    private boolean binary;
    private double similarityValue;
    private String fromPath;
    private boolean isCopy;
    private boolean isMove;

    public GitDiffInfo(String fromPath, String toPath) {
        this.fromPath = fromPath;
        this.toPath = toPath;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode.trim();
    }

    public void setFromContentHash(String fromHash) {
        this.fromContentHash = fromHash;
    }

    public void setToContentHash(String toHash) {
        this.toContentHash = toHash;
    }

    public void setParentChangesetId(String csid) {
        this.parentChangesetId = csid;
    }

    public String getParentChangesetId() {
        return this.parentChangesetId;
    }

    @Override
    public int getNumAdded() {
        int added = 0;
        List<Hunk> hunks = this.getHunks();
        if (hunks != null) {
            for (Hunk hunk : hunks) {
                added += hunk.getToCount();
            }
        }
        return added;
    }

    @Override
    public int getNumRemoved() {
        int added = 0;
        List<Hunk> hunks = this.getHunks();
        if (hunks != null) {
            for (Hunk hunk : hunks) {
                added += hunk.getFromCount();
            }
        }
        return added;
    }

    public String getToPath() {
        return this.toPath;
    }

    @Override
    public String toString() {
        return "GitChange - " + this.toPath + "(" + this.toContentHash + ")";
    }

    @Override
    public String toStringChild() {
        return this.toString();
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setSimilarityValue(double similarityValue) {
        this.similarityValue = similarityValue;
    }

    public void setCopyFromPath(String copyFrom) {
        this.isCopy = true;
        if (!copyFrom.equals(this.fromPath)) {
            Logs.APP_LOG.debug((Object)"Copy from path does not match diff from path");
        }
    }

    public void setRenameFromPath(String renameFrom) {
        this.isMove = true;
        if (!renameFrom.equals(this.fromPath)) {
            Logs.APP_LOG.debug((Object)"renameFrom path does not match diff from path");
        }
    }

    public boolean isCopy() {
        return this.isCopy;
    }

    public boolean isMove() {
        return this.isMove;
    }

    public String getFromContentHash() {
        return this.fromContentHash;
    }

    public String getToContentHash() {
        return this.toContentHash;
    }

    public double getSimilarityValue() {
        return this.similarityValue;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getFileMode() {
        return this.fileMode;
    }
}

