/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitEscape;
import com.atlassian.fisheye.git.client.GitListBranchesOutputHandler;
import com.atlassian.fisheye.git.client.GitRemoteShowOutputHandler;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.StringOutputHandler;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.SafeExternalProcessBuilder;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.rep.VersionHandler;
import com.cenqua.fisheye.util.NamedProcessHandler;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class GitContext
extends DvcsContext {
    public static final String GC_PRUNE_EXPIRE_CONFIG = "gc.pruneExpire";
    public static final String NEVER_CONFIG = "never";
    private static final String GIT_VERSION_PATTERN_STRING = "git version (.*)";
    private static final long TIMEOUT_VERSION_COMMAND_MS = 60000L;
    private final Logger log = Logs.APP_LOG;
    private GitScmConfig gitConfig;
    private Version gitVersion;
    private String mainBranch = null;
    private Date mainBranchDeterminationTime;
    private static final long MAIN_BRANCH_CACHE_TIME_MS = 3600000L;
    public static final GitCommandBuilder LIST_BRANCHES = new GitCommandBuilder("show-ref", "--heads", "--no-abbrev");

    protected GitContext() {
    }

    public GitContext(RepositoryConfig config) {
        super(config);
        this.gitConfig = (GitScmConfig)config.getScmConfig();
    }

    public Charset getEncoding() {
        return this.getScmConfig().getEncoding();
    }

    public Version determineGitVersion() throws ConfigException {
        this.gitVersion = GitContext.determineGitVersion(this.getScmConfig().getExecutable());
        this.log.debug((Object)("Git Version: " + this.gitVersion));
        return this.gitVersion;
    }

    public static Version determineGitVersion(String gitExecutable) throws ConfigException {
        VersionHandler handler = new VersionHandler(GIT_VERSION_PATTERN_STRING);
        ExternalProcess process = new SafeExternalProcessBuilder().command(Arrays.asList(gitExecutable, "--version")).idleTimeout(60000L).handlers((OutputHandler)handler).log(Logs.APP_LOG, (Priority)Level.DEBUG).build();
        process.execute();
        if (process.getHandler().succeeded()) {
            if (handler.getVersionString() != null) {
                return new Version(handler.getVersionString());
            }
            throw new ConfigException("No version string found in output of " + process.getCommandLine());
        }
        throw new ConfigException("Unable to get git version", process.getHandler().getException());
    }

    @Override
    public GitScmConfig getScmConfig() {
        return this.gitConfig;
    }

    public Version getGitVersion() {
        return this.gitVersion;
    }

    public void refreshMainBranchNameIfStale(boolean forceRefresh) {
        if (forceRefresh || this.mainBranchDeterminationTime == null || new Date().getTime() - this.mainBranchDeterminationTime.getTime() > 3600000L) {
            if (!this.getRepoLocation().exists()) {
                return;
            }
            this.mainBranchDeterminationTime = new Date();
            try {
                GitRemoteShowOutputHandler outputHandler = new GitRemoteShowOutputHandler(this.getEncoding());
                this.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("remote", "show", this.getScmConfig().getRemoteLocationWithCredentials()), (OutputHandler)outputHandler);
                String result = outputHandler.getResult();
                if (result == null) {
                    this.log.warn((Object)("No HEAD branch found in git repo " + this.getName()));
                }
                this.mainBranch = result;
            }
            catch (DvcsProcessException e2) {
                this.log.error((Object)("Error getting HEAD branch for git repo " + this.getName()), (Throwable)e2);
                this.mainBranch = null;
            }
        }
    }

    @Override
    @Nullable
    public String getMainBranchName() {
        return this.mainBranch;
    }

    @Override
    public Set<Branch> getBranchesInLocalRepo() throws DvcsProcessException {
        HashSet branches;
        block2: {
            branches = Sets.newHashSet();
            try {
                this.executeCommand((DvcsCommandBuilder)LIST_BRANCHES, (OutputHandler)new GitListBranchesOutputHandler(this.getEncoding().name()){

                    @Override
                    protected void processBranch(Branch branch) {
                        branches.add(branch);
                    }
                });
            }
            catch (DvcsProcessException e2) {
                if (e2.isExitCode(1)) break block2;
                throw e2;
            }
        }
        return branches;
    }

    public void addEmptyPathSets(GitCommitDetails commitDetails) {
        for (String parentHash : commitDetails.getParents()) {
            GitCommandBuilder command = new GitCommandBuilder("diff", "--quiet");
            command.append(parentHash + ".." + commitDetails.getCommitHash());
            NamedProcessHandler handler = new NamedProcessHandler(this.getName());
            handler.setThrowOnNonZeroExit(false);
            StringOutputHandler output = new StringOutputHandler();
            handler.setOutputHandler((OutputHandler)output);
            StringOutputHandler errors = new StringOutputHandler();
            handler.setErrorHandler((OutputHandler)errors);
            try {
                this.executeCommand((DvcsCommandBuilder)command, handler);
                if (handler.getExitCode() != 0) continue;
                commitDetails.addEmptyPathSet(parentHash);
                if (!commitDetails.hasAllPathSets()) continue;
                break;
            }
            catch (ProcessException e2) {
                e2.printStackTrace();
            }
        }
    }

    public Map<Path, String> getManifestContentHashesForChangeset(String csid) throws DvcsProcessException {
        final HashMap<Path, String> result = new HashMap<Path, String>();
        this.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("ls-tree", "-r", "--full-name", csid), (OutputHandler)new BaseLineOutputHandler(this.getEncoding()){

            protected void processLine(int lineNum, String line) throws DbException {
                Matcher matcher = GitScanner.TREEINFO_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String contentHash = matcher.group(2);
                    String pathString = GitEscape.unescapeQuoted(matcher.group(3));
                    Path path = GitContext.this.getLocalPath(pathString);
                    if (GitContext.this.isPathInRepo(path)) {
                        result.put(path, contentHash);
                    }
                }
            }
        });
        return result;
    }

    public void visitChangesetIds(String headRef, Iterable<String> excludedRefs, boolean reverse, final StoppableVisitor<String> commitHashHandler) throws DvcsProcessException {
        GitCommandBuilder command = new GitCommandBuilder("rev-list", "--date-order");
        if (reverse) {
            command.append("--reverse");
        }
        command.append(headRef);
        for (String excludedRef : excludedRefs) {
            if (Strings.isNullOrEmpty((String)excludedRef)) continue;
            command.append("^" + excludedRef);
        }
        command.append("--");
        if (StringUtils.isNotBlank((String)this.getPath())) {
            command.append(this.getPath());
        }
        this.executeCommand((DvcsCommandBuilder)command, (OutputHandler)new BaseLineOutputHandler(this.getEncoding()){
            private boolean cancelled;
            {
                super(encoding);
                this.cancelled = false;
            }

            protected void processLine(int lineNum, String line) {
                boolean keepGoing;
                if (!this.cancelled && !(keepGoing = commitHashHandler.visit(line))) {
                    this.cancelled = true;
                    this.cancelProcess();
                }
            }
        });
    }

    public void updateLocalCloneConfig(String ... settings) throws DvcsProcessException {
        StringOutputHandler handler = new StringOutputHandler();
        GitCommandBuilder command = new GitCommandBuilder("config", new String[0]);
        command.append(settings);
        command.append("--local");
        this.log.info((Object)String.format("Updating %s repository with config: %s", this.getName(), Arrays.toString(settings)));
        this.executeCommand((DvcsCommandBuilder)command, (OutputHandler)handler);
        if (StringUtils.isNotBlank((String)handler.getOutput())) {
            this.log.warn((Object)String.format("Unexpected git config command output: %s", handler.getOutput()));
        }
    }
}

