/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.dvcs.client.DvcsCommitDetails;
import com.atlassian.fisheye.git.client.GitChangePath;
import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GitCommitDetails
extends DvcsCommitDetails {
    private String committer;
    private String subject;
    private String body;
    private String email;
    private String committerEmail;
    private int currentPathsetIndex;
    private List<List<GitChangePath>> pathSets = new ArrayList<List<GitChangePath>>(2);
    protected Multimap<String, GitDiffInfo> diffInfoMap = ArrayListMultimap.create();

    public GitCommitDetails(String branch, String commitHash) {
        this.setCommitHash(commitHash);
        this.setBranch(branch);
        this.currentPathsetIndex = 0;
        this.pathSets.add(new ArrayList());
    }

    public void addParentCommit(String parent) {
        super.getParents().add(parent);
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void addBodyLine(String line) {
        this.body = this.body == null ? line : this.body + "\n" + line;
    }

    public void addPath(GitChangePath changePath) {
        if (!this.getParents().isEmpty()) {
            changePath.setParentCsId(this.getParents().get(this.currentPathsetIndex));
        }
        this.pathSets.get(this.currentPathsetIndex).add(changePath);
    }

    public Collection<GitChangePath> getPaths() {
        if (this.pathSets.isEmpty()) {
            return Collections.emptyList();
        }
        return this.pathSets.get(0);
    }

    public Collection<GitChangePath> getChangedPaths(String parentCommit) {
        if (!this.hasAllPathSets()) {
            throw new IllegalStateException("Getting changes by parent " + parentCommit + " of commit " + this.commitHash + " but some path sets are missing");
        }
        int parentIndex = this.parents.indexOf(parentCommit);
        if (parentIndex == -1 || parentIndex > this.pathSets.size() - 1) {
            return Collections.emptyList();
        }
        return this.pathSets.get(parentIndex);
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    public Collection<GitDiffInfo> getDiffInfo(String path) {
        return this.diffInfoMap.get((Object)path);
    }

    public Map<String, GitChangePath> getChangePathsByParent(String path) {
        if (!this.hasAllPathSets()) {
            throw new IllegalStateException("Getting changes by parent but some path sets are missing");
        }
        HashMap<String, GitChangePath> result = new HashMap<String, GitChangePath>();
        for (int i2 = 0; i2 < this.pathSets.size(); ++i2) {
            List<GitChangePath> pathSet = this.pathSets.get(i2);
            String parent = (String)this.parents.get(i2);
            for (GitChangePath changePath : pathSet) {
                if (!changePath.getPath().equals(path)) continue;
                result.put(parent, changePath);
            }
        }
        return result;
    }

    public void addDiffInfo(GitDiffInfo diffInfo) {
        this.diffInfoMap.put((Object)diffInfo.getToPath(), (Object)diffInfo);
        if (diffInfo.getFromContentHash() == null) {
            String path = diffInfo.getToPath();
            if ("/dev/null".equals(path)) {
                path = diffInfo.getFromPath();
            }
            for (GitChangePath changePath : this.pathSets.get(0)) {
                if (!changePath.getPath().equals(path)) continue;
                diffInfo.setFromContentHash(changePath.getSrcHash());
                diffInfo.setToContentHash(changePath.getDestHash());
                break;
            }
        }
    }

    public Multimap<String, GitDiffInfo> getDiffInfoMap() {
        return this.diffInfoMap;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCommitterEmail(String committerEmail) {
        this.committerEmail = committerEmail;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCommitter() {
        return this.committer;
    }

    public String toString() {
        return "GitCommitDetails{" + this.getCommitHash() + '}';
    }

    public void newPathset() {
        ++this.currentPathsetIndex;
        this.pathSets.add(new ArrayList());
    }

    public boolean hasAllPathSets() {
        return this.parents.size() == this.pathSets.size();
    }

    public void addEmptyPathSet(String parentHash) {
        int parentIndex = this.parents.indexOf(parentHash);
        if (parentIndex != -1) {
            this.pathSets.add(parentIndex, new ArrayList());
        }
    }

    public void addEmptyParents() {
        int numMissing = this.parents.size() - this.pathSets.size();
        for (int i2 = 0; i2 < numMissing; ++i2) {
            this.newPathset();
        }
    }
}

