/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.ManifestDAO;
import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitEscape;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.git.db.GitRevInfoDAO;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.CommonManifestDAOImpl;
import com.atlassian.fisheye.manifest.ManifestEntry;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.util.regex.Matcher;

public class GitClientManifestDAO
implements ManifestDAO<GitRevInfo> {
    private final CommonManifestDAO commonManifestDAO;
    private final GitRevInfoDAO fileRevDAO;
    private final GitCache cache;

    public GitClientManifestDAO(GitCache cache) {
        this.cache = cache;
        this.commonManifestDAO = new CommonManifestDAOImpl(cache.getInfDb(), (CommonStringTables)cache.getStringTables());
        this.fileRevDAO = cache.getFileRevisionDAO();
    }

    @Override
    public void visitRevisions(String csid, final Visitor<GitRevInfo> visitor) throws DbException {
        CommonManifest manifest = this.commonManifestDAO.load(csid);
        if (manifest != null) {
            manifest.visitPaths(new Visitor<ManifestEntry>(){

                @Override
                public void visit(ManifestEntry manifestEntry) {
                    if (!manifestEntry.isDeleted()) {
                        RevInfoKey key = manifestEntry.getRevInfoKey();
                        GitRevInfo revision = (GitRevInfo)GitClientManifestDAO.this.fileRevDAO.loadLazy(key);
                        if (revision != null) {
                            visitor.visit(revision);
                        }
                    }
                }
            });
        } else {
            this.visitRevisionsUsingTreeContent(csid, visitor);
        }
    }

    private void visitRevisionsUsingTreeContent(final String csid, final Visitor<GitRevInfo> visitor) {
        try {
            this.cache.getContext().executeCommand((DvcsCommandBuilder)new GitCommandBuilder("ls-tree", "-r", "--full-name", csid), (OutputHandler)new BaseLineOutputHandler(this.cache.getContext().getEncoding()){

                protected void processLine(int lineNum, String line) throws DbException {
                    Matcher matcher = GitScanner.TREEINFO_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        GitRevInfo revision;
                        String contentHash = matcher.group(2);
                        String pathString = GitEscape.unescapeQuoted(matcher.group(3));
                        Path path = GitClientManifestDAO.this.cache.getContext().getLocalPath(pathString);
                        if (GitClientManifestDAO.this.cache.getContext().isPathInRepo(path) && (revision = GitClientManifestDAO.this.cache.getFileRevisionAtManifest(path, contentHash, csid, true)) != null) {
                            visitor.visit(revision);
                        }
                    }
                }
            });
        }
        catch (DvcsProcessException e2) {
            Logs.APP_LOG.warn((Object)("Unable to get manifest for commit " + csid), (Throwable)e2);
        }
    }

    @Override
    public Manifest<GitRevInfo> load(String csid) throws DbException {
        GitChangeSet cs = (GitChangeSet)this.cache.getChangeSet(csid);
        return new Manifest<GitRevInfo>(cs, this);
    }
}

