/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.dvcs.client.DvcsChangeParser;
import com.atlassian.fisheye.git.client.GitAction;
import com.atlassian.fisheye.git.client.GitChangePath;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitEscape;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class GitChangeParser
extends DvcsChangeParser {
    public static final String LOG_BODY_SEPERATOR = "@@fe_body_end@@";
    public static final String LOG_FORMAT = "C:%H%nP:%P%nA:%aN%nE:%aE%nR:%cN%nF:%cE%nD:%at%nS:%s%nB:%b%n@@fe_body_end@@";
    private static final String COMMIT_REGEX = "C:([0-9a-fA-F]{40})";
    private static final Pattern COMMIT_PATTERN = Pattern.compile("C:([0-9a-fA-F]{40})");
    private static final Pattern HEADER_PATTERN = Pattern.compile("^[PAERFDSB]:.*");
    private static final Pattern PATH_PATTERN = Pattern.compile(":([0-9]+) ([0-9]+) ([0-9a-fA-F]{40}) ([0-9a-fA-F]{40}) ([ACDMRTUXB])([0-9]*)\\t([^\\t]+)\\t?(.*)");
    private static final Pattern MERGE_PATH_PATTERN = Pattern.compile("::([0-9]+) ([0-9]+) ([0-9]+) ([0-9a-fA-F]{40}) ([0-9a-fA-F]{40}) ([0-9a-fA-F]+) ([ACDMRTUXB])([ACDMRTUXB])([0-9]*)\\t([^\\t]+)(\\t(.*)|)");
    private ParserState state = ParserState.START;
    private GitCommitDetails commitDetails;

    public GitChangeParser(Charset encoding, RepositoryStatus status) {
        super(encoding, status, true);
    }

    protected void processLine(int lineNum, String line) throws DbException {
        block10: {
            block9: {
                if (this.getStatus().isStopRequested()) break block9;
                if (line.matches(COMMIT_REGEX) && this.state != ParserState.START && this.state != ParserState.PATHS) {
                    if (this.commitDetails != null) {
                        Logs.APP_LOG.error((Object)("Unexpected commit statement " + line + " while in state " + (Object)((Object)this.state) + ", existing commit " + this.commitDetails.getCommitHash()));
                    } else {
                        Logs.APP_LOG.debug((Object)("Unexpected commit statement " + line + " while in state " + (Object)((Object)this.state) + ", existing commit null"));
                    }
                    this.state = ParserState.START;
                }
                switch (this.state) {
                    case START: {
                        this.scanForCommit(line);
                        break block10;
                    }
                    case HEADER: {
                        this.processHeaderLine(line);
                        break block10;
                    }
                    case IN_BODY: {
                        this.inBody(line);
                        break block10;
                    }
                    case PATHS: {
                        this.scanPaths(line);
                        break block10;
                    }
                    default: {
                        throw new RuntimeException("Unexpected parser state: " + (Object)((Object)this.state));
                    }
                }
            }
            this.cancelProcess();
            this.commitDetails = null;
            throw new RuntimeException("Repository is stopping");
        }
    }

    private void processHeaderLine(String line) {
        Matcher headerMatcher = HEADER_PATTERN.matcher(line);
        if (headerMatcher.matches()) {
            char field = line.charAt(0);
            String content = line.substring(2);
            switch (field) {
                case 'P': {
                    this.processParents(content);
                    break;
                }
                case 'A': {
                    this.commitDetails.setAuthor(content);
                    break;
                }
                case 'E': {
                    this.commitDetails.setEmail(content);
                    break;
                }
                case 'R': {
                    this.commitDetails.setCommitter(content);
                    break;
                }
                case 'F': {
                    this.commitDetails.setCommitterEmail(content);
                    break;
                }
                case 'D': {
                    this.processDate(content);
                    break;
                }
                case 'S': {
                    this.commitDetails.setSubject(content);
                    break;
                }
                case 'B': {
                    this.state = ParserState.IN_BODY;
                    this.inBody(content);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field on line [" + line + "]");
                }
            }
        }
    }

    private void scanForCommit(String line) {
        Matcher matcher = COMMIT_PATTERN.matcher(line);
        if (matcher.matches()) {
            this.startCommit(matcher);
        }
    }

    private void startCommit(Matcher matcher) {
        this.commitDetails = new GitCommitDetails(this.getBranch(), matcher.group(1));
        this.state = ParserState.HEADER;
    }

    private void processParents(String content) {
        if (content.trim().length() > 0) {
            String[] parentHashes;
            for (String parentHash : parentHashes = content.split(" ")) {
                this.commitDetails.addParentCommit(parentHash);
            }
        }
    }

    private void processDate(String content) {
        try {
            long millis = Long.parseLong(content) * 1000L;
            Date date = new Date(millis);
            this.commitDetails.setDate(date);
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)("Invalid date [" + content + "] for commit " + this.commitDetails.getCommitHash()));
        }
    }

    private void inBody(String line) {
        if (line.length() > 0 && line.startsWith(LOG_BODY_SEPERATOR)) {
            this.state = ParserState.PATHS;
        } else {
            this.commitDetails.addBodyLine(line);
        }
    }

    private void scanPaths(String line) throws DbException {
        GitChangePath changePath = GitChangeParser.parseChangePath(line);
        if (changePath != null && !changePath.isGitLinkPath()) {
            this.commitDetails.addPath(changePath);
        } else {
            Matcher matcher = COMMIT_PATTERN.matcher(line);
            if (matcher.matches()) {
                String commitHash = matcher.group(1);
                if (this.commitDetails == null || !this.commitDetails.getCommitHash().equals(commitHash)) {
                    this.handleCommit();
                    this.startCommit(matcher);
                } else {
                    this.commitDetails.newPathset();
                }
            }
        }
    }

    public static GitChangePath parseChangePath(String line) {
        GitChangePath changePath = null;
        Matcher matcher = PATH_PATTERN.matcher(line);
        if (matcher.matches()) {
            String path = null;
            String srcPath = null;
            if (StringUtils.isNotBlank((String)matcher.group(8))) {
                path = GitEscape.unescapeQuoted(matcher.group(8));
                srcPath = GitEscape.unescapeQuoted(matcher.group(7));
            } else {
                path = GitEscape.unescapeQuoted(matcher.group(7));
            }
            changePath = new GitChangePath(srcPath, path);
            GitAction action = GitAction.fromChar(matcher.group(5).charAt(0));
            if (action == GitAction.UNKNOWN) {
                Logs.APP_LOG.warn((Object)("Unknown file operation on line: " + line));
            }
            changePath.setAction(action);
            changePath.setSrcHash(matcher.group(3));
            changePath.setDestHash(matcher.group(4));
            int destMode = Integer.parseInt(matcher.group(2), 8);
            changePath.setDestMode(destMode);
        } else {
            matcher = MERGE_PATH_PATTERN.matcher(line);
            if (matcher.matches()) {
                Logs.APP_LOG.debug((Object)("Did not process merge pattern from - " + line));
            }
        }
        return changePath;
    }

    public void complete() throws DbException {
        this.handleCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommit() throws DbException {
        GitChangeParser gitChangeParser = this;
        synchronized (gitChangeParser) {
            if (this.commitDetails != null) {
                try {
                    this.processCommit(this.commitDetails);
                }
                finally {
                    this.commitDetails = null;
                }
            }
        }
    }

    protected abstract boolean processCommit(GitCommitDetails var1) throws DbException;

    private static enum ParserState {
        START,
        HEADER,
        IN_BODY,
        PATHS;

    }
}

