/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.cenqua.fisheye.rep.DbException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GitBlameParser
extends BaseLineOutputHandler {
    private static final Pattern COMMIT_PATTERN = Pattern.compile("^([0-9a-fA-F]{40}) ([0-9]+) ([0-9]+) ([0-9]*)");
    private static final Pattern TAG_PATTERN = Pattern.compile("^([^ ]+) (.*)");
    private int length;
    private int originalLine;
    private int lineNum;
    private Map<String, String> commitInfoMap = new HashMap<String, String>();
    private String filename;
    private String commit;
    private State state = State.COMMIT_SEARCH;

    public GitBlameParser(Charset encoding) {
        super(encoding);
    }

    protected void processLine(int lineNum, String line) throws DbException {
        switch (this.state) {
            case COMMIT_SEARCH: {
                this.searchCommit(line);
                break;
            }
            case IN_INFO: {
                this.processChunkLine(line);
            }
        }
    }

    private void searchCommit(String line) throws DbException {
        Matcher matcher = COMMIT_PATTERN.matcher(line);
        if (matcher.matches()) {
            this.commit = matcher.group(1);
            this.originalLine = Integer.parseInt(matcher.group(2));
            this.lineNum = Integer.parseInt(matcher.group(3));
            String lengthStr = matcher.group(4);
            this.length = lengthStr.length() != 0 ? Integer.parseInt(lengthStr) : 0;
            if (!this.commitInfoMap.containsKey(this.commit)) {
                this.filename = null;
                this.state = State.IN_INFO;
            } else {
                this.filename = this.commitInfoMap.get(this.commit);
                this.startChunk(this.commit, this.filename, this.originalLine, this.lineNum, this.length);
            }
        }
    }

    private void processChunkLine(String line) throws DbException {
        Matcher matcher = TAG_PATTERN.matcher(line);
        if (matcher.matches()) {
            String tagName = matcher.group(1);
            String tagValue = matcher.group(2);
            this.blameTag(tagName, tagValue);
            if (tagName.equals("filename")) {
                this.commitInfoMap.put(this.commit, this.filename);
                this.startChunk(this.commit, this.filename, this.originalLine, this.lineNum, this.length);
                this.state = State.COMMIT_SEARCH;
            }
        }
    }

    protected void blameTag(String tagName, String tagValue) {
        if (tagName.equals("filename")) {
            this.filename = tagValue;
        }
    }

    protected abstract void startChunk(String var1, String var2, int var3, int var4, int var5) throws DbException;

    private static enum State {
        COMMIT_SEARCH,
        IN_INFO;

    }
}

