/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import java.util.HashMap;
import java.util.Map;

public enum GitAction {
    ADD('A'),
    COPY('C'),
    DELETE('D'),
    MODIFY('M'),
    RENAME('R'),
    TYPE('T'),
    UNKNOWN('X');

    private final char actionChar;
    private static Map<Character, GitAction> actionMap;

    private GitAction(char actionChar) {
        this.actionChar = actionChar;
    }

    public static GitAction fromChar(char actionChar) {
        if (actionMap.containsKey(Character.valueOf(actionChar))) {
            return actionMap.get(Character.valueOf(actionChar));
        }
        return UNKNOWN;
    }

    public char getActionChar() {
        return this.actionChar;
    }

    static {
        actionMap = new HashMap<Character, GitAction>(GitAction.values().length);
        for (GitAction action : GitAction.values()) {
            actionMap.put(Character.valueOf(action.getActionChar()), action);
        }
    }
}

