/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import com.atlassian.fisheye.git.client.CommitTrail;
import com.cenqua.fisheye.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommitTrailMap {
    private Map<String, CommitTrail> commitTrailMap = new HashMap<String, CommitTrail>();
    private String headCommit;

    public CommitTrailMap(String headCommit, List<Pair<String, List<String>>> commits) {
        this.headCommit = headCommit;
        for (Pair<String, List<String>> commitInfo : commits) {
            String commit = commitInfo.getFirst();
            List<String> parents = commitInfo.getSecond();
            if (parents.isEmpty()) {
                this.setCommitTrail(commit, new CommitTrail(commit));
                continue;
            }
            for (String parent : parents) {
                this.addParent(commit, parent);
            }
        }
    }

    public boolean hasCommit(String commit) {
        return this.commitTrailMap.containsKey(commit);
    }

    public void addParent(String commit, String parentCommit) {
        CommitTrail childTrail = this.commitTrailMap.get(commit);
        CommitTrail parentTrail = this.commitTrailMap.get(parentCommit);
        if (parentTrail != null && !parentTrail.getLastCommit().equals(parentCommit)) {
            parentTrail = parentTrail.splitAt(parentCommit);
            for (String updatedCommit : parentTrail.getCommits()) {
                this.setCommitTrail(updatedCommit, parentTrail);
            }
            this.validateMap();
        }
        if (childTrail != null && !childTrail.getFirstCommit().equals(commit)) {
            childTrail = childTrail.splitAtChild(commit);
            for (String updatedCommit : childTrail.getCommits()) {
                this.setCommitTrail(updatedCommit, childTrail);
            }
            this.validateMap();
        }
        if (childTrail == null) {
            if (parentTrail == null) {
                CommitTrail trail = new CommitTrail(commit);
                trail.addParentCommit(parentCommit);
                this.setCommitTrail(commit, trail);
                this.setCommitTrail(parentCommit, trail);
            } else if (parentTrail.hasChildTrails()) {
                childTrail = new CommitTrail(commit);
                parentTrail.addChildTrail(childTrail);
                this.setCommitTrail(commit, childTrail);
            } else {
                parentTrail.addChildCommit(commit);
                this.setCommitTrail(commit, parentTrail);
            }
        } else if (parentTrail == null) {
            if (childTrail.hasParentTrails()) {
                parentTrail = new CommitTrail(parentCommit);
                childTrail.addParentTrail(parentTrail);
                this.setCommitTrail(parentCommit, parentTrail);
            } else {
                childTrail.addParentCommit(parentCommit);
                this.setCommitTrail(parentCommit, childTrail);
            }
        } else {
            parentTrail.addChildTrail(childTrail);
        }
    }

    private void setCommitTrail(String commit, CommitTrail trail) {
        if (!trail.getCommits().contains(commit)) {
            throw new IllegalStateException("Recording a trail for a commit which is not in the trail");
        }
        this.commitTrailMap.put(commit, trail);
    }

    private void validateMap() {
        for (Map.Entry<String, CommitTrail> entry : this.commitTrailMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().getCommits().contains(key)) continue;
            throw new IllegalStateException("Found a trail for a commit which is not in the trail");
        }
    }

    public String getHeadCommit() {
        return this.headCommit;
    }

    public CommitTrail getTrail(String commitHash) {
        return this.commitTrailMap.get(commitHash);
    }
}

