/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git.client;

import java.util.ArrayList;
import java.util.List;

public class CommitTrail {
    private List<CommitTrail> parents;
    private List<CommitTrail> children;
    private List<String> commits;

    public CommitTrail(String commit) {
        this.commits = new ArrayList<String>(1);
        this.commits.add(commit);
    }

    private CommitTrail(List<String> commits) {
        this.commits = new ArrayList<String>(commits);
    }

    public void addParentCommit(String commit) {
        this.commits.add(0, commit);
    }

    public void addParentTrail(CommitTrail trail) {
        if (this.parents == null) {
            this.parents = new ArrayList<CommitTrail>(2);
        }
        if (!this.parents.contains(trail)) {
            this.parents.add(trail);
            trail.addChildTrail(this);
        }
    }

    public void addChildTrail(CommitTrail trail) {
        if (this.children == null) {
            this.children = new ArrayList<CommitTrail>(2);
        }
        if (!this.children.contains(trail)) {
            this.children.add(trail);
            trail.addParentTrail(this);
        }
    }

    public String getLastCommit() {
        if (this.commits == null || this.commits.isEmpty()) {
            throw new IllegalStateException("Can't get commit from empty trail");
        }
        return this.commits.get(this.commits.size() - 1);
    }

    public CommitTrail splitAt(String commit) {
        int commitIndex = this.commits.indexOf(commit);
        if (commitIndex == -1) {
            throw new IllegalArgumentException("Cannot split at commit " + commit + " as it is not a member of the commit trail");
        }
        CommitTrail newTrail = new CommitTrail(this.commits.subList(0, commitIndex + 1));
        this.commits.removeAll(newTrail.commits);
        if (this.parents != null) {
            for (CommitTrail parent : this.parents) {
                parent.removeChild(this);
                parent.addChildTrail(newTrail);
            }
        }
        newTrail.addChildTrail(this);
        return newTrail;
    }

    public CommitTrail splitAtChild(String commit) {
        int index = this.commits.indexOf(commit);
        if (index == -1) {
            throw new IllegalArgumentException("Can't find commit in trail");
        }
        CommitTrail newTrail = new CommitTrail(this.commits.subList(index, this.commits.size()));
        this.commits = this.commits.subList(0, index);
        newTrail.addParentTrail(this);
        return newTrail;
    }

    private void removeChild(CommitTrail trail) {
        if (this.children == null) {
            throw new IllegalStateException("Cannot remove child as this trail has no children");
        }
        this.children.remove(trail);
    }

    public List<String> getCommits() {
        return this.commits;
    }

    public boolean hasChildTrails() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<CommitTrail> getChildren() {
        return this.children;
    }

    public String getFirstCommit() {
        if (this.commits == null) {
            throw new IllegalStateException("Cannot access commit as this trail has no commits");
        }
        return this.commits.get(0);
    }

    public void addChildCommit(String commit) {
        this.commits.add(commit);
    }

    public boolean hasParentTrails() {
        return this.parents != null && !this.parents.isEmpty();
    }
}

