/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fecru.security.Credentials;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitProcessFactory;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.StringProcessHandler;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.IntervalUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;

public class GitScmConfig
extends DvcsScmConfig {
    private static final String GIT_DEFAULT_EXECUTABLE = "git";
    private static final long TEST_CONNECTION_TIMEOUT = 30000L;
    public static final int CACHE_VERSION = 22;
    private RenameOptions.Enum renameMode;
    private GitRepType gitConfig;

    public GitScmConfig(String name, RootConfig rootConfig, RepositorySystemType scmConfig, SshKeyManager sshKeyManager, GitProcessFactory gitProcessFactory) {
        super(22, rootConfig, sshKeyManager, gitProcessFactory);
        this.gitConfig = (GitRepType)scmConfig;
        if (this.gitConfig == null) {
            throw new IllegalStateException(name + " did not contain expected <git> element");
        }
        this.reloadUpdateSettings();
        this.initRepoLocationAndCredentials(this.gitConfig);
        if (this.gitConfig.isSetPath() && !StringUtils.isBlank((String)this.gitConfig.getPath())) {
            this.setPath(this.gitConfig.getPath());
            if (this.getPath() != null && this.getPath().length() > 0 && this.getPath().charAt(0) == '/') {
                this.setPath(this.getPath().substring(1));
            }
        } else {
            this.setPath("");
        }
        this.setEncoding(Charsets.UTF_8);
        if (this.gitConfig.isSetBlocksize()) {
            this.setBlockSize(this.gitConfig.getBlocksize().intValue());
        } else {
            this.setBlockSize(GitScmConfig.getDefaultBlockSize());
        }
        if (this.gitConfig.isSetCommandTimeout() && !Strings.isNullOrEmpty((String)this.gitConfig.getCommandTimeout().trim())) {
            String commandTimeoutStr = this.gitConfig.getCommandTimeout();
            try {
                this.setCommandTimeout(new Interval(commandTimeoutStr));
            }
            catch (NumberFormatException e2) {
                this.setConfigException("Command timeout interval is not valid: " + commandTimeoutStr);
            }
        } else {
            this.setCommandTimeout(GitScmConfig.getDefaultCommandTimeout());
        }
        if (this.gitConfig.isSetRenames()) {
            this.setRenameMode(this.gitConfig.getRenames());
        } else {
            this.setRenameMode(RenameOptions.NONE);
        }
    }

    @Override
    public void reloadUpdateSettings() {
        String pollPeriodString = this.gitConfig.isSetUpdater() ? this.gitConfig.getUpdater().getPollPeriod() : null;
        this.setPollPeriod(IntervalUtils.convertStringToLongOrNever(pollPeriodString, this.getDefaultPollPeriod()));
    }

    @Override
    public Credentials getCredentials() {
        if (this.gitConfig.isSetPasswordAuth()) {
            return this.createCredentials(this.gitConfig.getPasswordAuth());
        }
        if (this.gitConfig.isSetSshAuth()) {
            return this.createCredentials(this.gitConfig.getSshAuth());
        }
        return null;
    }

    private void initRepoLocationAndCredentials(GitRepType gitConfig) {
        this.setLocation(gitConfig.getLocation());
    }

    @Override
    public GitRepositoryEngine createRepositoryEngine(RepositoryConfig repoConfig, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        return new GitRepositoryEngine(repoConfig, upgradeManager, indexingContext);
    }

    @Override
    public void testConnection(RepositoryConfig config) throws ConfigException {
        StringProcessHandler processHandler = new StringProcessHandler();
        try {
            this.executeCommand(new GitCommandBuilder("ls-remote", "-h", this.getRemoteLocationWithCredentials()), (PluggableProcessHandler)processHandler, 30000L, new ProcessMonitor[0]);
        }
        catch (ProcessTimeoutException e2) {
            String message = DvcsContext.OBFUSCATOR.obfuscate("The operation timed out while connecting to the repository. The server may be waiting for a password.\n" + processHandler.getOutput());
            throw new ConfigException(message);
        }
        catch (ProcessException e3) {
            String message = DvcsContext.OBFUSCATOR.obfuscate("Error talking to repository: \n" + processHandler.getOutput() + "\n" + processHandler.getError());
            throw new ConfigException(message);
        }
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.GIT;
    }

    public boolean isLocalRepo() {
        return false;
    }

    public RenameOptions.Enum getRenameMode() {
        return this.renameMode;
    }

    public void setRenameMode(RenameOptions.Enum renameMode) {
        this.renameMode = renameMode;
    }

    @Override
    public String getExecutable() {
        ConfigDocument.Config serverConfig = this.getRootConfig().getConfig();
        if (serverConfig != null && serverConfig.isSetGitConfig() && serverConfig.getGitConfig().getGitExecutable() != null) {
            return serverConfig.getGitConfig().getGitExecutable();
        }
        return GIT_DEFAULT_EXECUTABLE;
    }
}

