/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.PersistentStringSet;
import com.atlassian.fisheye.dvcs.DvcsScanner;
import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.fisheye.dvcs.client.DvcsChangeParser;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessRuntimeException;
import com.atlassian.fisheye.dvcs.handler.LineArrayOutputHandler;
import com.atlassian.fisheye.dvcs.handler.StatusProcessHandler;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.client.GitAction;
import com.atlassian.fisheye.git.client.GitChangeParser;
import com.atlassian.fisheye.git.client.GitChangePath;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.fisheye.git.client.GitDiffInfo;
import com.atlassian.fisheye.git.client.GitDiffOutputHandler;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitChangeSetDAO;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.git.db.GitRevInfoDAO;
import com.atlassian.fisheye.git.db.GitStringTables;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.ManifestEntry;
import com.atlassian.fisheye.manifest.ManifestProcessor;
import com.atlassian.fisheye.manifest.ManifestUpgrader;
import com.atlassian.fugue.Option;
import com.atlassian.utils.process.BaseInputHandler;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.CopyOutputHandler;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.IndexingConfig;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.util.EmailUtil;
import com.cenqua.fisheye.util.FileUtils;
import com.cenqua.fisheye.util.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GitScanner
extends DvcsScanner<GitRevInfo, GitChangeSet, GitCache, GitStringTables> {
    private static final Logger log = Logs.loggerFor(GitScanner.class);
    public static final Version GIT_161 = new Version("1.6.1");
    private static final long MAX_TAG_PROCESSING_TIME = 600000L;
    private static final Pattern BLOBINFO_PATTERN = Pattern.compile("([0-9a-fA-F]{40}) blob ([0-9]+)");
    private static final Pattern TAGINFO_PATTERN = Pattern.compile("([0-9a-fA-F]{40})\\srefs/tags/(.*?)(\\^\\{\\})?");
    public static final Pattern TREEINFO_PATTERN = Pattern.compile("([0-9]+) blob ([0-9a-fA-F]{40})\t(.*)");
    private static final double COPYMOVE_SIMILARITY_THRESHOLD = 0.7;
    public static final Pattern LSREMOTE_PATTERN = Pattern.compile("([0-9a-fA-F]{40})\trefs/heads/(.*)");
    public static final int POST_PROCESS_BRANCH_CHUNK_SIZE = 50;
    private GitContext context;
    private GitChangeParser changeParser;
    private GitDiffOutputHandler diffParser;
    private GitRevInfoDAO fileRevDAO;
    private GitChangeSetDAO csDAO;
    private String[] renameOption;
    public static final int EAGER_COMMIT_REINDEX_LIMIT = 100;
    @VisibleForTesting
    protected Set<String> commitsToReindex;
    @VisibleForTesting
    protected Set<String> commitsToReindexNow;
    private String mailMapHash;
    private ManifestProcessor manifestProcessor;
    private ManifestUpgrader upgrader;

    public GitScanner(GitRepositoryEngine engine) {
        super(engine);
        this.context = engine.getContext();
    }

    private void createDiffParser() {
        this.diffParser = new GitDiffOutputHandler(this.getStatus(), this.getEncoding(), this.getDiffTextCache()){

            @Override
            protected void processDiffInfo(GitDiffInfo diffInfo) {
                if (GitScanner.this.getContext().isPathInRepo(diffInfo.getToPath())) {
                    this.getCommitDetails().addDiffInfo(diffInfo);
                }
            }
        };
        switch (this.context.getScmConfig().getRenameMode().intValue()) {
            case 1: {
                this.renameOption = new String[]{"--no-renames"};
                break;
            }
            case 3: {
                this.renameOption = new String[]{"-M"};
                break;
            }
            case 2: {
                this.renameOption = new String[]{"-C"};
                break;
            }
            case 4: {
                this.renameOption = new String[]{"-C", "--find-copies-harder"};
                break;
            }
            default: {
                this.renameOption = new String[]{"--no-renames"};
            }
        }
    }

    @Override
    protected boolean fetchLatest() throws ConfigException {
        this.status.throwOnStopRequested();
        StatusProcessHandler handler = new StatusProcessHandler(this.getRepoName(), this.getEncoding(), this.getStatus());
        try {
            Set<Tag> newTags;
            Set<Branch> newBranches;
            Set<Branch> oldBranches = this.context.getBranchesInLocalRepo();
            Set<Tag> oldTags = this.getTagsInRepo();
            Set<String> remoteHeads = this.getRemoteHeads();
            if (remoteHeads.isEmpty()) {
                if (oldBranches.isEmpty()) {
                    if (((GitCache)this.getCache()).isInitialIndexingComplete()) {
                        return false;
                    }
                    ((GitCache)this.getCache()).setInitialIndexingComplete(true);
                    return true;
                }
                log.warn((Object)"Empty remote heads list returned, which makes no sense. Skipping this fetch.");
                return false;
            }
            ImmutableSet localBranchNames = ImmutableSet.copyOf((Iterable)Iterables.transform(oldBranches, Branch.TO_NAME));
            Sets.SetView removedBranches = Sets.difference((Set)localBranchNames, remoteHeads);
            String mainBranchName = this.getContext().getMainBranchName();
            if (mainBranchName != null && removedBranches.contains(mainBranchName)) {
                this.getContext().refreshMainBranchNameIfStale(true);
                mainBranchName = this.getContext().getMainBranchName();
                if (mainBranchName != null) {
                    GitCommandBuilder command = new GitCommandBuilder("symbolic-ref", "HEAD", "refs/heads/" + mainBranchName);
                    this.getContext().executeCommand((DvcsCommandBuilder)command, handler);
                }
            }
            for (String branch : removedBranches) {
                this.removeLocalBranch(branch);
            }
            boolean updateOccured = false;
            if (!removedBranches.isEmpty()) {
                updateOccured = this.updateRemovedBranches(remoteHeads);
            }
            this.fetchRemoteHeads(handler);
            if (updateOccured |= this.fetchAndPruneTags()) {
                ((GitCache)this.getCache()).commit();
            }
            if (!updateOccured && !(newBranches = this.context.getBranchesInLocalRepo()).equals(oldBranches)) {
                updateOccured = true;
            }
            if (!updateOccured && !(newTags = this.getTagsInRepo()).equals(oldTags)) {
                updateOccured = true;
            }
            return updateOccured;
        }
        catch (ProcessException e2) {
            String message = this.obfuscate("Unable to fetch from remote repository: " + this.getContext().getScmConfig().getRemoteLocation() + (!Strings.isNullOrEmpty((String)handler.getError()) ? "\n - " + handler.getError() : "") + (!Strings.isNullOrEmpty((String)handler.getStdOut()) ? "\n - " + handler.getStdOut() : ""));
            this.getStatus().setEngineError(message);
            throw new ConfigException(message, e2);
        }
        catch (DvcsProcessException e3) {
            throw new ConfigException(e3);
        }
        catch (DbException e4) {
            throw new ConfigException(e4);
        }
    }

    private void fetchRemoteHeads(StatusProcessHandler handler) throws ProcessException {
        GitCommandBuilder command = new GitCommandBuilder("fetch", this.getRemoteLocationWithCredentials(), "+refs/*:refs/*");
        this.getContext().executeCommand((DvcsCommandBuilder)command, handler);
    }

    private Set<String> getRemoteHeads() throws DvcsProcessException {
        GitCommandBuilder command = new GitCommandBuilder("ls-remote", "--heads", this.getRemoteLocationWithCredentials());
        final HashSet<String> remoteHeads = new HashSet<String>();
        this.getContext().executeCommand((DvcsCommandBuilder)command, (OutputHandler)new BaseLineOutputHandler(this.getEncoding()){

            protected void processLine(int lineNum, String line) {
                Matcher matcher = LSREMOTE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String remoteRef = matcher.group(2);
                    remoteHeads.add(remoteRef);
                }
            }
        });
        return remoteHeads;
    }

    private boolean updateRemovedBranches(Set<String> remoteHeads) {
        Set<Branch> indexBranches = ((GitCache)this.getCache()).getBranches();
        HashSet branchesRemovedFromCache = Sets.newHashSet();
        for (Branch indexBranch : indexBranches) {
            if (remoteHeads.contains(indexBranch.getName()) || indexBranch.getState() == BranchState.REMOVED) continue;
            Branch updatedBranch = this.prepareBranchToBeStored(indexBranch, null);
            ((GitCache)this.getCache()).getBranchDAO().store(updatedBranch, true);
            branchesRemovedFromCache.add(updatedBranch);
        }
        if (!branchesRemovedFromCache.isEmpty()) {
            this.getBranchCrossRepoIndexer().indexBranches(branchesRemovedFromCache, this.getCache(), this.getStatus());
            return true;
        }
        return false;
    }

    private void removeLocalBranch(String branch) throws ConfigException {
        StatusProcessHandler handler = new StatusProcessHandler(this.getRepoName(), this.getEncoding(), this.getStatus());
        try {
            GitCommandBuilder command = new GitCommandBuilder("branch", "-D", branch);
            this.getContext().executeCommand((DvcsCommandBuilder)command, handler);
        }
        catch (ProcessException e2) {
            log.error((Object)("Error removing local branch: " + handler.getError()), (Throwable)e2);
        }
    }

    @Override
    protected void performClone(File cloneLocation) throws ConfigException {
        StatusProcessHandler handler = new StatusProcessHandler(this.getRepoName(), this.getEncoding(), this.getStatus());
        try {
            GitCommandBuilder command = new GitCommandBuilder("clone", "--bare");
            if (this.context.getGitVersion().compareTo(GIT_161) >= 0) {
                command.append("-v");
            }
            command.append(this.getRemoteLocationWithCredentials());
            command.append(this.getContext().getRepoLocation().getName());
            this.getContext().executeCommand(command, (ProcessHandler)handler, cloneLocation.getParentFile());
            this.getContext().updateLocalCloneConfig("gc.pruneExpire", "never");
            this.getContext().storeCloneDetails();
        }
        catch (DvcsProcessException | ProcessException e2) {
            FileUtils.deleteTree(cloneLocation);
            String message = this.obfuscate("Unable to clone remote repository: " + this.getContext().getScmConfig().getRemoteLocation() + (!Strings.isNullOrEmpty((String)handler.getError()) ? "\n - " + handler.getError() : "") + (!Strings.isNullOrEmpty((String)handler.getStdOut()) ? "\n - " + handler.getStdOut() : ""));
            this.getStatus().setEngineError(message);
            throw new ConfigException(message, e2);
        }
        try {
            if (this.getBranchesToSlurp().isEmpty()) {
                log.warn((Object)("Repository " + this.getRepoName() + " has no heads. Possibly empty repository"));
            } else {
                this.updateMailMap(cloneLocation);
            }
        }
        catch (DvcsProcessException e3) {
            throw new ConfigException(e3);
        }
    }

    @Override
    protected boolean processRevisions() throws DbException, RepositoryClientException {
        this.getContext().refreshMainBranchNameIfStale(false);
        return super.processRevisions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMailMap(File cloneLocation) {
        String errorMessage = "Could not create .mailmap file for git repository '" + this.getRepoName() + "'. Committers will not be mapped.";
        File mailMap = new File(cloneLocation, ".mailmap");
        BufferedOutputStream out = null;
        GitCommandBuilder command = new GitCommandBuilder("ls-tree", "HEAD", "--", ".mailmap");
        try {
            StringOutputHandler outputHandler = new StringOutputHandler(this.getEncodingName());
            this.getContext().executeCommand((DvcsCommandBuilder)command, (OutputHandler)outputHandler);
            String mailMapHash = outputHandler.getOutput();
            if (!StringUtils.isEmpty((String)mailMapHash) && !mailMapHash.equals(this.mailMapHash)) {
                this.mailMapHash = mailMapHash;
                command = new GitCommandBuilder("show", "HEAD:.mailmap");
                if (mailMap.exists()) {
                    IOHelper.deleteFile(mailMap);
                }
                IOHelper.createNewFile(mailMap);
                out = new BufferedOutputStream(new FileOutputStream(mailMap));
                this.getContext().executeCommand((DvcsCommandBuilder)command, (OutputHandler)new CopyOutputHandler((OutputStream)out));
            }
        }
        catch (DvcsProcessException e2) {
            log.warn((Object)errorMessage, (Throwable)e2);
        }
        catch (IOException e3) {
            log.warn((Object)errorMessage, (Throwable)e3);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    private boolean fetchAndPruneTags() throws DvcsProcessException, DbException {
        boolean updateOccurred = false;
        final HashSet remoteTags = new HashSet();
        this.context.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("ls-remote", "--tags", this.getRemoteLocationWithCredentials()), (OutputHandler)new BaseLineOutputHandler(this.getEncoding()){

            protected void processLine(int lineNum, String line) {
                Matcher matcher = TAGINFO_PATTERN.matcher(line);
                if (matcher.matches()) {
                    remoteTags.add(matcher.group(2));
                }
            }
        });
        for (Tag tag : this.getTagsInRepo()) {
            if (remoteTags.contains(tag.getName())) continue;
            ((GitCache)this.getCache()).removeTag(tag);
            this.context.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("tag", "-d", tag.getName()), (OutputHandler)new StringOutputHandler());
            updateOccurred = true;
        }
        return updateOccurred;
    }

    private Set<Tag> getTagsInRepo() throws DvcsProcessException {
        HashMap tags;
        block2: {
            tags = new HashMap();
            try {
                BaseLineOutputHandler outputHandler = new BaseLineOutputHandler(this.getEncoding()){

                    protected void processLine(int lineNum, String line) {
                        Matcher matcher = TAGINFO_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            tags.put(matcher.group(2), new Tag(matcher.group(2), matcher.group(1)));
                        }
                    }
                };
                this.context.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("show-ref", "-d", "--tags"), (OutputHandler)outputHandler);
            }
            catch (DvcsProcessException e2) {
                if (e2.isExitCode(1)) break block2;
                throw e2;
            }
        }
        return ImmutableSet.copyOf(tags.values());
    }

    @Override
    protected boolean processTags() throws DvcsProcessException, DbException {
        this.getStatus().setMessage("Processing tags");
        boolean updated = false;
        long startTime = System.currentTimeMillis();
        Set<Tag> tags = this.getTagsInRepo();
        int processedTagsCounter = 0;
        boolean timeout = false;
        for (Tag tag : tags) {
            ++processedTagsCounter;
            if (this.isStopRequested() || !this.processTag(tag)) continue;
            updated = true;
            if (System.currentTimeMillis() - startTime <= 600000L) continue;
            int numberOfTagsLeft = tags.size() - processedTagsCounter;
            log.debug((Object)String.format("Processing tags paused, %d tags to process left on next slurp.", numberOfTagsLeft));
            ((GitCache)this.cache).setScanProperty(CommonProperties.GIT_TAGS_TO_PROCESS.value, numberOfTagsLeft);
            timeout = true;
            break;
        }
        if (timeout) {
            this.getStatus().setMessage("Paused processing tags");
        } else {
            ((GitCache)this.cache).setScanProperty(CommonProperties.GIT_TAGS_TO_PROCESS.value, 0L);
            this.getStatus().setMessage("Finished processing tags");
        }
        return updated;
    }

    private boolean processTag(Tag tag) throws DbException, DvcsProcessException {
        String tagName = tag.getName();
        String taggedCommit = tag.getChangesetId();
        boolean updated = false;
        Tag currentTag = this.csDAO.getTag(tagName);
        if (currentTag != null && !tag.equals(currentTag)) {
            this.getStatus().setMessage("Tag has moved. Removing tag " + tagName + " (" + taggedCommit + ")");
            this.fileRevDAO.removeTag(tagName);
            this.csDAO.removeTag(currentTag);
        }
        if (!this.csDAO.exists(taggedCommit)) {
            updated = this.addTagCommits(tag);
        }
        if (this.csDAO.exists(taggedCommit) && !tag.equals(currentTag)) {
            this.getStatus().setMessage("Adding tag " + tagName + " (" + taggedCommit + ")");
            this.applyTag(tag);
            updated = true;
        }
        return updated;
    }

    private boolean addTagCommits(Tag tag) throws DvcsProcessException {
        String tagStreamName = "./tag/" + tag.getName();
        this.getChangeParser().setBranch(null);
        return this.processCommitStream(tagStreamName, null, tag.getChangesetId(), new Function<List<String>, String>(){

            public String apply(@Nullable List<String> input) {
                return GitScanner.this.getLastNonBranchCommit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTag(final Tag tag) throws DbException {
        Timer timer = new Timer("applying tag " + tag);
        try {
            CommonManifestDAO manifestDAO = this.manifestProcessor.getManifestDAO();
            CommonManifest manifest = manifestDAO.load(tag.getChangesetId());
            if (manifest != null) {
                manifest.visitPaths(new Visitor<ManifestEntry>(){

                    @Override
                    public void visit(ManifestEntry manifestEntry) {
                        if (!manifestEntry.isDeleted()) {
                            RevInfoKey key = manifestEntry.getRevInfoKey();
                            GitScanner.this.fileRevDAO.addTag(GitScanner.this.fileRevDAO.getRevId(key), tag.getName());
                        }
                    }
                });
                this.csDAO.addTag(tag);
            } else {
                this.applyTagOnContentTree(tag);
            }
        }
        finally {
            timer.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTagOnContentTree(final Tag tag) {
        Timer timer = new Timer("applying tag based on content tree " + tag);
        try {
            this.context.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("ls-tree", "-r", "--full-name", tag.getName()), (OutputHandler)new BaseLineOutputHandler(this.getEncoding()){

                protected void processLine(int lineNum, String line) {
                    Matcher matcher;
                    if (!GitScanner.this.isStopRequested() && (matcher = TREEINFO_PATTERN.matcher(line)).matches()) {
                        GitRevInfo revision;
                        String destHash = matcher.group(2);
                        Path path = GitScanner.this.getContext().getLocalPath(matcher.group(3));
                        if (GitScanner.this.getContext().isPathInRepo(path) && (revision = ((GitCache)GitScanner.this.getCache()).getFileRevisionAtManifest(path, destHash, tag.getChangesetId(), true)) != null) {
                            GitScanner.this.fileRevDAO.getCommonRevInfoDAO().addTagData(revision.getRevID(), tag.getName());
                        }
                    }
                }
            });
            this.csDAO.addTag(tag);
        }
        catch (DvcsProcessException e2) {
            log.warn((Object)("Unable to get info for tag " + tag), (Throwable)e2);
        }
        finally {
            timer.end();
        }
    }

    @Override
    protected void indexScannedChangesets() {
        EggTimer backIndexTimer = new EggTimer(FishEyeSysProps.GIT_SCANNED_CHANGESET_INDEXING_TIMELIMIT_SECONDS, TimeUnit.SECONDS);
        super.indexScannedChangesets();
        Set<String> processedCommits = this.getCommitsProcessed();
        this.commitsToReindexNow.removeAll(processedCommits);
        this.indexChangesets(null, this.commitsToReindexNow);
        this.commitsToReindex.removeAll(processedCommits);
        this.commitsToReindex.removeAll(this.commitsToReindexNow);
        this.commitsToReindexNow.clear();
        while (!(backIndexTimer.isTimeExpired() || this.getStatus().isStopRequested() || this.commitsToReindex.isEmpty())) {
            ImmutableList reindexBatch = ImmutableList.copyOf((Iterable)Iterables.limit(this.commitsToReindex, (int)1000));
            this.indexChangesets(null, (Collection<String>)reindexBatch);
            this.commitsToReindex.removeAll((Collection<?>)reindexBatch);
        }
        int leftToReindex = this.commitsToReindex.size();
        ((GitCache)this.cache).setScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, leftToReindex);
        log.debug((Object)("Exiting indexScannedChangesets with " + leftToReindex + " old changesets to reindex lazily."));
    }

    @Override
    protected Branch prepareBranchToBeStored(Branch branchInCache, Branch branchInScm) {
        if (branchInScm != null) {
            if (branchInCache == null) {
                Branch createdBranch = branchInScm.clone();
                createdBranch.setLatestMarkedChangesetId((Option<String>)Option.none());
                return createdBranch;
            }
            Branch updatedBranch = branchInScm.clone();
            Option<String> lastMarked = branchInCache.getLatestMarkedChangesetId();
            String headInCache = branchInCache.getLatestChangeSetId();
            if (lastMarked.isEmpty()) {
                log.debug((Object)"Branch had an unset latestMarked attribute (deleted or never marked), needs remarking the entire ancestry");
                updatedBranch.setLatestMarkedChangesetId((Option<String>)Option.none());
            } else if (Objects.equal((Object)lastMarked.get(), (Object)headInCache)) {
                log.debug((Object)"Branch was fully marked, setting the previous head as the new latest marked head");
                updatedBranch.setLatestMarkedChangesetId((Option<String>)Option.some((Object)headInCache));
            } else {
                log.debug((Object)"Branch wasn't fully marked, keeping previous latest marked head");
                updatedBranch.setLatestMarkedChangesetId(lastMarked);
            }
            return updatedBranch;
        }
        if (branchInCache != null) {
            Branch removedBranch = branchInCache.clone();
            removedBranch.setLatestChangeSetId(null);
            removedBranch.setState(BranchState.REMOVED);
            return removedBranch;
        }
        throw new IllegalStateException("Both branchInCache and branchInScm not specified in onBranchHeadUpdated");
    }

    @Override
    protected boolean postProcessBranches() throws DvcsProcessException {
        this.getStatus().setMessage("Post-processing updated branches");
        boolean changedCache = false;
        Iterable branchesToMark = Iterables.filter(((GitCache)this.getCache()).getBranches(), (Predicate)new Predicate<Branch>(){

            public boolean apply(Branch branchInCache) {
                Option<String> latestMarked = branchInCache.getLatestMarkedChangesetId();
                String branchHead = branchInCache.getLatestChangeSetId();
                return !Objects.equal((Object)latestMarked.getOrNull(), (Object)branchHead);
            }
        });
        for (List branchesChunk : Iterables.partition((Iterable)branchesToMark, (int)50)) {
            log.debug((Object)("Processing branch list chunk with " + branchesChunk.size() + " items."));
            this.markChangesetsAsBelongingToBranches(branchesChunk);
            changedCache = true;
        }
        this.getStatus().setMessage("");
        return changedCache;
    }

    private void markChangesetsAsBelongingToBranches(Iterable<Branch> branchesToMark) {
        ImmutableListMultimap.Builder csIdsWithAddedBranchesBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder csIdsWithRemovedBranchesBuilder = ImmutableListMultimap.builder();
        for (Branch branchInCache : branchesToMark) {
            String branchName = branchInCache.getName();
            Option<String> latestMarked = branchInCache.getLatestMarkedChangesetId();
            String branchHead = branchInCache.getLatestChangeSetId();
            log.debug((Object)("Getting new commits to mark on branch " + branchInCache));
            try {
                if (branchHead != null) {
                    this.context.visitChangesetIds(branchHead, (Iterable<String>)latestMarked, false, new ChangesetsOnBranchCollector((ImmutableListMultimap.Builder<String, String>)csIdsWithAddedBranchesBuilder, branchName, true));
                }
                if (latestMarked.isDefined()) {
                    log.debug((Object)("Getting new commits to unmark on branch " + branchInCache));
                    this.context.visitChangesetIds((String)latestMarked.get(), (Iterable<String>)Option.option((Object)branchHead), false, new ChangesetsOnBranchCollector((ImmutableListMultimap.Builder<String, String>)csIdsWithRemovedBranchesBuilder, branchName, false));
                }
                branchInCache.setLatestMarkedChangesetId((Option<String>)Option.option((Object)branchHead));
                ((GitCache)this.getCache()).getBranchDAO().store(branchInCache, false);
            }
            catch (DvcsProcessException e2) {
                log.warn((Object)String.format("Failed to list revisions for branch %s (response was %s). Remarking using in-cache traversal.", branchInCache, e2.getMessage()));
                this.updateBranchAncestryFallback(branchInCache, latestMarked, branchHead);
            }
        }
        ImmutableListMultimap csIdsWithAddedBranches = csIdsWithAddedBranchesBuilder.build();
        ImmutableListMultimap csIdsWithRemovedBranches = csIdsWithRemovedBranchesBuilder.build();
        ImmutableSet addedBranchCsids = csIdsWithAddedBranches.keySet();
        ImmutableSet removedBranchCsids = csIdsWithRemovedBranches.keySet();
        log.debug((Object)("Done collecting changesets to mark (" + addedBranchCsids.size() + ") and unmark (" + removedBranchCsids.size() + ")"));
        for (String csid : Sets.union((Set)addedBranchCsids, (Set)removedBranchCsids)) {
            this.csDAO.updateChangesetBranches(csid, (Iterable<String>)csIdsWithAddedBranches.get((Object)csid), (Iterable<String>)csIdsWithRemovedBranches.get((Object)csid));
        }
        log.debug((Object)"Done marking changesets");
        Iterables.addAll(this.commitsToReindex, (Iterable)Sets.difference((Set)addedBranchCsids, this.commitsToReindexNow));
        Iterables.addAll(this.commitsToReindex, (Iterable)Sets.difference((Set)removedBranchCsids, (Set)addedBranchCsids));
        log.debug((Object)"Done queuing changeset indexing");
    }

    private void updateBranchAncestryFallback(Branch branchInCache, Option<String> latestMarked, String branchHead) {
        List<String> updatedCsIds = latestMarked.isEmpty() ? this.csDAO.updateBranchAncestry(null, branchInCache) : this.csDAO.updateBranchAncestry(new Branch(branchInCache.getName(), (String)latestMarked.get(), BranchState.ACTIVE), branchInCache);
        log.debug((Object)("Done marking via updateBranchAncestry, marked " + updatedCsIds.size() + " changesets"));
        branchInCache.setLatestMarkedChangesetId((Option<String>)Option.option((Object)branchHead));
        ((GitCache)this.getCache()).getBranchDAO().store(branchInCache, false);
        Iterables.addAll(this.commitsToReindexNow, (Iterable)Iterables.limit(updatedCsIds, (int)100));
        Iterables.addAll(this.commitsToReindex, (Iterable)Iterables.skip(updatedCsIds, (int)100));
        log.debug((Object)"Done queuing changeset indexing for updateBranchAncestry changesets");
    }

    protected static void removeOversizedBlobsFromRevisions(Multimap<String, DvcsRevInfo> revisionsByHash, List<String> blobInfos, IndexingConfig indexingConfig) {
        for (String info : blobInfos) {
            Matcher matcher = BLOBINFO_PATTERN.matcher(info);
            if (!matcher.matches()) continue;
            String blobHash = matcher.group(1);
            String sizeString = matcher.group(2);
            long size = Long.parseLong(sizeString);
            Iterator dvcsRevInfoIterator = revisionsByHash.get((Object)blobHash).iterator();
            while (dvcsRevInfoIterator.hasNext()) {
                DvcsRevInfo revInfo = (DvcsRevInfo)dvcsRevInfoIterator.next();
                if (indexingConfig.isOfIndexableSize(revInfo.getPath(), size, revInfo.getDisplayRevision())) continue;
                dvcsRevInfoIterator.remove();
            }
        }
    }

    @Override
    protected void indexContentBlock(final Multimap<String, DvcsRevInfo> revisions) throws DvcsProcessException {
        if (revisions.isEmpty()) {
            return;
        }
        Timer timer = new Timer("Indexing Content Block of " + this.context.getName());
        LineArrayOutputHandler linesHandler = new LineArrayOutputHandler(this.getEncoding());
        BaseInputHandler inputHandler = new BaseInputHandler(){

            public void process(OutputStream input) {
                PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(input, GitScanner.this.getEncoding())), false);
                for (String hash : revisions.keySet()) {
                    pw.println(hash);
                    this.resetWatchdog();
                }
                pw.close();
            }
        };
        try {
            this.context.executeWithInput(new GitCommandBuilder("cat-file", "--batch-check"), (OutputHandler)linesHandler, (InputHandler)inputHandler);
        }
        catch (RuntimeWrappedException e2) {
            log.error((Object)"Problem getting content information", e2.getCause());
        }
        GitScanner.removeOversizedBlobsFromRevisions(revisions, linesHandler.getLines(), this.context.getConfig());
        for (String blobHash : revisions.keySet()) {
            if (blobHash.equals("0000000000000000000000000000000000000000")) continue;
            Collection revs = revisions.get((Object)blobHash);
            for (final DvcsRevInfo revInfo : revs) {
                BaseOutputHandler indexerHandler = new BaseOutputHandler(){

                    public void process(InputStream output) throws ProcessException {
                        try {
                            GitScanner.this.getRepositoryIndexer().indexContent(revInfo, new InputStreamReader(output, GitScanner.this.getEncoding()));
                        }
                        catch (InterruptedIOException interruptedIOException) {
                        }
                        catch (IOException e2) {
                            throw new ProcessException((Throwable)e2);
                        }
                    }
                };
                try {
                    this.context.executeCommand((DvcsCommandBuilder)new GitCommandBuilder("cat-file", "-p", blobHash), (OutputHandler)indexerHandler);
                }
                catch (DvcsProcessException e3) {
                    String message = "Unable to get content for " + revInfo.getRevInfoKey() + ", hash = " + blobHash;
                    log.error((Object)(message + ": " + e3.getMessage()));
                    log.debug((Object)message, (Throwable)e3);
                }
            }
        }
        timer.end();
    }

    @Override
    protected DvcsChangeParser getChangeParser() {
        return this.changeParser;
    }

    @Override
    protected String getRevisionContentKey(DvcsRevInfo revision) {
        return ((GitRevInfo)revision).getDestHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processGitCommit(GitCommitDetails commitDetails) throws DvcsProcessException, DbException, LicensePolicyException {
        String commitHash = commitDetails.getCommitHash();
        Timer timer = new Timer("Processing commit " + commitHash);
        try {
            if (this.csDAO.exists(commitHash)) {
                boolean bl = false;
                return bl;
            }
            this.status.setMessage("Processing commit " + commitHash);
            this.populateDiffInfo(commitDetails);
            this.processFileRevisions(commitDetails);
            if (this.processChangeSet(commitDetails)) {
                this.addProcessedCommit(commitDetails.getBranch(), commitHash);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            timer.end();
        }
    }

    protected boolean shouldIndexChangeSet(GitCommitDetails commitDetails) throws DbException {
        if (commitDetails.getPaths().isEmpty()) {
            return true;
        }
        if (commitDetails.getParents().size() > 1) {
            return true;
        }
        return this.isAtLeastOnePathInRepo(commitDetails.getPaths());
    }

    protected boolean isAtLeastOnePathInRepo(Collection<GitChangePath> paths) {
        for (GitChangePath path : paths) {
            if (!this.context.isPathInRepo(path.getPath())) continue;
            return true;
        }
        return false;
    }

    private boolean processChangeSet(GitCommitDetails commitDetails) throws DbException, LicensePolicyException {
        if (this.shouldIndexChangeSet(commitDetails)) {
            GitChangeSet changeset = new GitChangeSet(commitDetails.getCommitHash(), this.csDAO, this.fileRevDAO);
            changeset.setAuthor(commitDetails.getAuthor() + " " + EmailUtil.wrapEmail(commitDetails.getEmail()));
            changeset.setComment(this.getComment(commitDetails));
            changeset.setDate(commitDetails.getDate().getTime());
            changeset.setParents(commitDetails.getParents());
            changeset.setBranch(commitDetails.getBranch());
            this.csDAO.store(changeset);
            return true;
        }
        this.csDAO.updateParentGraph(commitDetails.getCommitHash(), commitDetails.getParents());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s]: Ignoring changeset %s; it does not contain any changes in the watched area", ((GitCache)this.getCache()).getRepositoryName(), commitDetails.getCommitHash()));
        }
        return false;
    }

    private void processFileRevisions(final GitCommitDetails commitDetails) throws DbException, LicensePolicyException {
        Collection<GitChangePath> paths = commitDetails.getPaths();
        final int nCommitParents = commitDetails.getParents().size();
        for (GitChangePath gitChangePath : paths) {
            if (this.getStatus().isStopRequested()) {
                return;
            }
            this.processChangePath(commitDetails, nCommitParents, gitChangePath, false);
        }
        this.diffParser.diffTextCache.clear();
        boolean saveManifest = true;
        for (String parent : commitDetails.getParents()) {
            if (this.manifestProcessor.exists(parent)) continue;
            saveManifest = false;
            break;
        }
        if (saveManifest) {
            if (nCommitParents > 1) {
                this.manifestProcessor.saveMergeManifest(commitDetails, new ManifestProcessor.MergeDeleteCallback(){

                    @Override
                    public void deleteInMerge(String deletedFromParent, GitChangePath path) {
                        GitScanner.this.processChangePath(commitDetails, nCommitParents, path, true);
                    }
                });
            } else {
                String string = nCommitParents == 1 ? commitDetails.getParents().get(0) : null;
                this.manifestProcessor.saveSimpleManifest(commitDetails.getCommitHash(), string);
            }
        }
    }

    private void processChangePath(GitCommitDetails commitDetails, int nCommitParents, GitChangePath path, boolean force) {
        try {
            if (!this.context.isPathInRepo(path.getPath())) {
                return;
            }
            int nFileRevParents = 0;
            if (commitDetails.getDiffInfo(path.getPath()) != null) {
                nFileRevParents = commitDetails.getDiffInfo(path.getPath()).size();
            }
            if (force || nCommitParents == 1 || nCommitParents <= nFileRevParents) {
                switch (path.getAction()) {
                    case ADD: {
                        this.processAddition(commitDetails, path);
                        break;
                    }
                    case COPY: {
                        this.processCopy(commitDetails, path);
                        break;
                    }
                    case DELETE: {
                        this.processDeletion(commitDetails, path);
                        break;
                    }
                    case MODIFY: {
                        this.processModification(commitDetails, path);
                        break;
                    }
                    case RENAME: {
                        this.processRename(commitDetails, path);
                        break;
                    }
                    case TYPE: {
                        this.processModification(commitDetails, path);
                        break;
                    }
                    default: {
                        log.error((Object)("Unhandled change type " + (Object)((Object)path.getAction())));
                    }
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Error processing path " + path.toDebugString(), e2);
        }
    }

    private void processRename(GitCommitDetails commitDetails, GitChangePath path) throws DbException, LicensePolicyException {
        this.processCopyMove(commitDetails, path);
    }

    private void processCopy(GitCommitDetails commitDetails, GitChangePath path) throws DbException, LicensePolicyException {
        this.processCopyMove(commitDetails, path);
    }

    public void setMaxManifestDepth(int maxManifestDepth) {
        this.manifestProcessor.setMaxManifestDepth(maxManifestDepth);
    }

    public ManifestProcessor getManifestProcessor() {
        return this.manifestProcessor;
    }

    private List<GitDiffInfo> constructDiffInfos(GitCommitDetails commitDetails, GitChangePath changePath) throws DbException {
        ArrayList<GitDiffInfo> diffs = new ArrayList<GitDiffInfo>();
        if (changePath.getSrcHash() != null && !"0000000000000000000000000000000000000000".equals(changePath.getSrcHash())) {
            GitDiffInfo diffInfo = new GitDiffInfo(changePath.getSrcPath(), changePath.getPath());
            diffInfo.setBinary(true);
            diffInfo.setFromContentHash(changePath.getSrcHash());
            diffInfo.setToContentHash(changePath.getDestHash());
            if (changePath.getAction() == GitAction.COPY) {
                diffInfo.setCopyFromPath(changePath.getSrcPath());
                diffInfo.setSimilarityValue(0.7);
            } else if (changePath.getAction() == GitAction.RENAME) {
                diffInfo.setRenameFromPath(changePath.getSrcPath());
                diffInfo.setSimilarityValue(0.7);
            }
            if (commitDetails.getParents().size() == 1) {
                diffInfo.setParentChangesetId(commitDetails.getParents().get(0));
            } else if (commitDetails.getParents().size() > 1) {
                Path parentPath = this.context.getLocalPath(changePath.getSrcPath());
                for (String parentId : commitDetails.getParents()) {
                    GitRevInfo revInfo = ((GitCache)this.getCache()).getFileRevisionAtManifest(parentPath, parentId);
                    if (revInfo == null) continue;
                    diffInfo.setParentChangesetId(parentId);
                    break;
                }
            }
            diffs.add(diffInfo);
        }
        return diffs;
    }

    private DiffInfoContext getDiffInfoContext(GitCommitDetails commitDetails, GitChangePath changePath) throws DbException {
        DiffInfoContext context = null;
        Collection<GitDiffInfo> diffInfos = commitDetails.getDiffInfo(changePath.getPath());
        if (diffInfos == null || diffInfos.isEmpty()) {
            diffInfos = this.constructDiffInfos(commitDetails, changePath);
        }
        if (diffInfos != null && !diffInfos.isEmpty()) {
            context = new DiffInfoContext(diffInfos, changePath);
        } else {
            log.error((Object)("No Diff Info for path " + changePath + " in commit " + commitDetails.getCommitHash()));
        }
        return context;
    }

    private void processAddition(GitCommitDetails commitDetails, GitChangePath changePath) throws DbException, LicensePolicyException {
        DiffInfoContext context = this.getDiffInfoContext(commitDetails, changePath);
        if (context != null) {
            GitDiffInfo diffInfo = context.diffParentDiffInfo;
            GitRevInfo revInfo = this.createRevInfo(commitDetails, changePath, diffInfo, null);
            int linesAdded = diffInfo.getNumAdded();
            revInfo.setAdded(true);
            revInfo.setLineCount(linesAdded);
            revInfo.setLinesAdded(linesAdded);
            revInfo.setLinesRemoved(0);
            revInfo.createAdditionHunk();
            revInfo.setSrcHash("0000000000000000000000000000000000000000");
            this.insertNewRevision(revInfo, null);
        }
    }

    private void processCopyMove(GitCommitDetails commitDetails, GitChangePath changePath) throws DbException, LicensePolicyException {
        DiffInfoContext context = this.getDiffInfoContext(commitDetails, changePath);
        if (context != null) {
            GitDiffInfo diffInfo = context.diffParentDiffInfo;
            GitRevInfo revInfo = this.createRevInfo(commitDetails, changePath, diffInfo, context.ancestorLink);
            AncestorLink ancestorLink = null;
            int srcLineCount = context.ancestorLineCount;
            int linesAdded = diffInfo.getNumAdded();
            int linesRemoved = diffInfo.getNumRemoved();
            int totalLines = srcLineCount + linesAdded - linesRemoved;
            if (diffInfo.getSimilarityValue() < 0.7 || !context.diffParentRevId.isPresent()) {
                revInfo.setAdded(true);
                revInfo.setLineCount(totalLines);
                revInfo.setLinesAdded(totalLines);
                revInfo.setLinesRemoved(0);
                revInfo.createAdditionHunk();
                revInfo.setSrcHash("0000000000000000000000000000000000000000");
            } else {
                revInfo.setLineCount(totalLines);
                revInfo.setLinesAdded(linesAdded);
                revInfo.setLinesRemoved(linesRemoved);
                revInfo.setCopy(diffInfo.isCopy());
                revInfo.setMove(diffInfo.isMove());
                revInfo.setBinary(this.fileRevDAO.isBinary((Integer)context.diffParentRevId.get()));
                ancestorLink = new AncestorLink(revInfo.isMove() ? AncestorLink.Type.MOVE : AncestorLink.Type.COPY, (Iterable<Integer>)context.ancestorLink.getRevids());
            }
            this.insertNewRevision(revInfo, ancestorLink);
            if (revInfo.isMove()) {
                GitChangePath deletePath = new GitChangePath(diffInfo.getFromPath());
                deletePath.setSrcHash(diffInfo.getFromContentHash());
                deletePath.setAction(GitAction.DELETE);
                deletePath.setDestHash("0000000000000000000000000000000000000000");
                GitRevInfo deleteRevInfo = this.createRevInfo(commitDetails, deletePath, null, context.ancestorLink);
                deleteRevInfo.setDead(true);
                deleteRevInfo.setLineCount(0);
                deleteRevInfo.setLinesAdded(0);
                deleteRevInfo.setLinesRemoved(context.ancestorLineCount);
                deleteRevInfo.setBinary(this.fileRevDAO.isBinary((Integer)context.diffParentRevId.or((Object)-1)));
                AncestorLink deleteLink = new AncestorLink(AncestorLink.Type.DIRECT, (Integer)context.diffParentRevId.or((Object)-1));
                this.insertNewRevision(deleteRevInfo, deleteLink);
            }
        }
    }

    private void processModification(GitCommitDetails commitDetails, GitChangePath changePath) throws DbException, LicensePolicyException {
        DiffInfoContext context = this.getDiffInfoContext(commitDetails, changePath);
        if (context != null) {
            GitRevInfo revInfo = this.createRevInfo(commitDetails, changePath, context.diffParentDiffInfo, context.ancestorLink);
            revInfo.setModify(true);
            int lineCount = context.ancestorLineCount + context.diffParentDiffInfo.getNumAdded() - context.diffParentDiffInfo.getNumRemoved();
            revInfo.setLineCount(lineCount);
            revInfo.setLinesAdded(context.diffParentDiffInfo.getNumAdded());
            revInfo.setLinesRemoved(context.diffParentDiffInfo.getNumRemoved());
            this.insertNewRevision(revInfo, context.ancestorLink);
        }
    }

    private void processDeletion(GitCommitDetails commitDetails, GitChangePath changePath) throws DbException, LicensePolicyException {
        DiffInfoContext context = this.getDiffInfoContext(commitDetails, changePath);
        if (context != null) {
            GitRevInfo revInfo = this.createRevInfo(commitDetails, changePath, context.diffParentDiffInfo, context.ancestorLink);
            revInfo.setDead(true);
            revInfo.setLineCount(0);
            revInfo.setLinesAdded(0);
            revInfo.setLinesRemoved(context.ancestorLineCount);
            this.insertNewRevision(revInfo, context.ancestorLink);
        }
    }

    private void insertNewRevision(GitRevInfo revInfo, AncestorLink ancestorLink) throws DbException, LicensePolicyException {
        this.createParentDir(revInfo.getPath().getParent());
        int revid = this.fileRevDAO.insertNew(revInfo, ancestorLink, this.getFeatures().isStoreDiffs());
        if (this.getFeatures().isStoreDiffs()) {
            this.getRepositoryIndexer().indexDiffText(revInfo, revid, this.getDiffTextCache(), ((GitCache)this.getCache()).getCommonRevInfoDAO());
        }
    }

    private String getComment(GitCommitDetails commitDetails) {
        if (commitDetails.getBody() == null) {
            return commitDetails.getSubject();
        }
        return commitDetails.getSubject() + "\n" + commitDetails.getBody();
    }

    private GitRevInfo createRevInfo(GitCommitDetails commitDetails, GitChangePath changePath, GitDiffInfo diffInfo, AncestorLink ancestorLink) {
        GitRevInfo revInfo = new GitRevInfo();
        revInfo.setComment(this.getComment(commitDetails));
        revInfo.setAuthor(commitDetails.getAuthor() + " " + EmailUtil.wrapEmail(commitDetails.getEmail()));
        revInfo.setEmail(commitDetails.getEmail());
        revInfo.setDate(commitDetails.getDate().getTime());
        revInfo.setPath(this.context.getLocalPath(changePath.getPath()));
        revInfo.setRevision(commitDetails.getCommitHash());
        revInfo.setFileType(1);
        revInfo.addBranch(commitDetails.getBranch());
        if (commitDetails.getBranch() != null) {
            revInfo.setTrunkLike(commitDetails.getBranch().equals(this.context.getMainBranchName()));
        }
        String destHash = changePath.getDestHash();
        String srcHash = changePath.getSrcHash();
        revInfo.setDestHash(destHash);
        revInfo.setDestMode(changePath.getDestMode());
        revInfo.setSrcHash(srcHash);
        if (destHash != null && destHash.equals(srcHash)) {
            if (ancestorLink != null) {
                GitRevInfo ancestor = (GitRevInfo)((GitCache)this.getCache()).getFileRevision((Integer)ancestorLink.getRevids().get(0));
                revInfo.setBinary(ancestor.isBinary());
                revInfo.setOversize(ancestor.isOversize());
                revInfo.setHunks(null);
                revInfo.setTmpDiffAddedFile(null);
                revInfo.setTmpDiffRemovedFile(null);
            }
        } else {
            Optional<Integer> revisionSize;
            if (diffInfo != null) {
                revInfo.setHunks(diffInfo.getHunks());
                revInfo.setTmpDiffAddedFile(diffInfo.getTmpDiffAddedFile());
                revInfo.setTmpDiffRemovedFile(diffInfo.getTmpDiffRemovedFile());
                revInfo.setBinary(diffInfo.isBinary());
            }
            if ((revisionSize = this.getRevisionSize(destHash)).isPresent() && (long)((Integer)revisionSize.get()).intValue() > this.getRepositoryConfig().getMaxIndexableSize()) {
                revInfo.setOversize(true);
            }
        }
        return revInfo;
    }

    private Optional<Integer> getRevisionSize(String revision) {
        return Optional.absent();
    }

    @Override
    protected boolean slurpCommits(String currentIndexedHead, final List<String> commits) throws DvcsProcessException, LicensePolicyException {
        this.updateMailMap(this.getContext().getRepoLocation());
        GitCommandBuilder command = new GitCommandBuilder("show", "-m", "--no-abbrev", "--raw", "--stdin");
        command.append(this.renameOption);
        command.append("--pretty=format:C:%H%nP:%P%nA:%aN%nE:%aE%nR:%cN%nF:%cE%nD:%at%nS:%s%nB:%b%n@@fe_body_end@@");
        if (StringUtils.isNotBlank((String)this.context.getPath())) {
            command.append("--", this.context.getPath());
        }
        BaseInputHandler inputHandler = new BaseInputHandler(){

            public void process(OutputStream input) {
                try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(input, GitScanner.this.getEncoding())));){
                    commits.forEach(line -> {
                        writer.print((String)line);
                        writer.print('\n');
                    });
                }
            }
        };
        this.processChanges(command, (Optional<InputHandler>)Optional.of((Object)inputHandler));
        String lastCommit = commits.get(commits.size() - 1);
        if (!this.getCommitsProcessed().contains(lastCommit)) {
            this.getSingleCommitDetails(lastCommit);
        }
        return true;
    }

    @Override
    protected DvcsRevInfoDAO<GitRevInfo, GitStringTables> getDvcsRevInfoDAO() {
        return this.fileRevDAO;
    }

    private void getSingleCommitDetails(String commit) throws DvcsProcessException, LicensePolicyException {
        GitCommandBuilder command = new GitCommandBuilder("log", "-m", "-1", "--no-abbrev");
        command.append(commit);
        command.append("--pretty=format:C:%H%nP:%P%nA:%aN%nE:%aE%nR:%cN%nF:%cE%nD:%at%nS:%s%nB:%b%n@@fe_body_end@@");
        command.append("--");
        if (StringUtils.isNotBlank((String)this.context.getPath())) {
            command.append(this.context.getPath());
        }
        this.processChanges(command, (Optional<InputHandler>)Optional.absent());
    }

    private void processChanges(GitCommandBuilder command, Optional<InputHandler> input) throws LicensePolicyException, DvcsProcessException {
        try {
            if (input.isPresent()) {
                this.context.executeWithInput(command, (OutputHandler)this.changeParser, (InputHandler)input.get());
            } else {
                this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)this.changeParser);
            }
        }
        catch (DvcsProcessException e2) {
            e2.rethrowCauseIfItsA(LicensePolicyException.class);
            throw e2;
        }
        finally {
            this.changeParser.clearWatchdogs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateDiffInfo(GitCommitDetails commitDetails) throws DvcsProcessException, DbException {
        if (this.isAtLeastOnePathInRepo(commitDetails.getPaths())) {
            this.diffParser.setCommitDetails(commitDetails);
            this.diffParser.addOuterWatchdog(this.changeParser.getWatchdog());
            try {
                List<String> parents = commitDetails.getParents();
                if (parents.isEmpty()) {
                    this.diffParser.setParentChangesetId(null);
                    GitCommandBuilder command = new GitCommandBuilder("whatchanged", "--always").append(this.renameOption).append("--no-abbrev", "--full-index", "-U0", "--pretty=format:").append(commitDetails.getCommitHash());
                    this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)this.diffParser);
                } else {
                    for (String parent : parents) {
                        this.diffParser.setParentChangesetId(parent);
                        GitCommandBuilder command = new GitCommandBuilder("diff", new String[0]).append(this.renameOption).append("--no-abbrev", "--full-index", "-U0").append(parent + ".." + commitDetails.getCommitHash());
                        this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)this.diffParser);
                    }
                }
            }
            finally {
                this.diffParser.clearWatchdogs();
            }
        }
    }

    @Override
    protected GitContext getContext() {
        return this.context;
    }

    @Override
    protected List<String> getUnseenCommits(String startCommit, String endCommit, String commitStreamName) throws DvcsProcessException {
        if (log.isDebugEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append("Getting commits ");
            if (commitStreamName != null) {
                message.append("from ").append(commitStreamName).append(" ");
            }
            if (startCommit != null) {
                message.append("from ").append(startCommit).append(" ");
            }
            message.append("up to ").append(endCommit);
            log.debug((Object)message.toString());
            this.status.setMessage(message.toString());
        }
        ArrayList<String> result = new ArrayList<String>();
        int blockSize = this.getContext().getScmConfig().getBlockSize();
        String mainBranch = this.context.getMainBranchName();
        ArrayList excludedRefs = Lists.newArrayList((Object[])new String[]{startCommit});
        if (mainBranch != null && !mainBranch.equals(commitStreamName)) {
            excludedRefs.add(mainBranch);
        }
        StoppableVisitor<String> visitor = commit -> {
            if (!this.getChangeSetDAO().exists((String)commit)) {
                if (result.size() >= blockSize) {
                    log.debug((Object)("Fetched up to block size commits: " + blockSize));
                    return false;
                }
                result.add((String)commit);
            }
            return true;
        };
        try {
            this.getContext().visitChangesetIds(endCommit, excludedRefs, true, visitor);
        }
        catch (DvcsProcessException e2) {
            log.info((Object)String.format("Failed to list revisions for branch: %s and last indexed head: %sListing all commits for this branch without rev exclusions", commitStreamName, startCommit), (Throwable)e2);
            this.getContext().visitChangesetIds(endCommit, Collections.emptyList(), true, visitor);
        }
        return result;
    }

    protected void createChangeParser() {
        this.changeParser = new GitChangeParser(this.getEncoding(), this.getStatus()){

            @Override
            protected boolean processCommit(GitCommitDetails commitDetails) throws DbException {
                try {
                    List<String> parents = commitDetails.getParents();
                    for (String parent : parents) {
                        if (!GitScanner.this.csDAO.resolveParent(parent).isEmpty()) continue;
                        log.warn((Object)("No indexed parents found for commit " + commitDetails.getCommitHash() + ", parent " + parent));
                    }
                    return GitScanner.this.processGitCommit(commitDetails);
                }
                catch (DvcsProcessException e2) {
                    throw new DvcsProcessRuntimeException(e2);
                }
                catch (LicensePolicyException e3) {
                    throw new DvcsProcessRuntimeException(e3);
                }
            }
        };
    }

    @Override
    public void start(GitCache cache) throws DbException, ConfigException {
        super.start(cache);
        this.fileRevDAO = cache.getFileRevisionDAO();
        this.csDAO = cache.getChangeSetDAO();
        this.manifestProcessor = new ManifestProcessor(this.status, cache, this.context, this.fileRevDAO);
        this.commitsToReindex = new PersistentStringSet(cache.getInfDb(), DvcsSchema.E_CHANGESET_UPDATED);
        this.commitsToReindexNow = new PersistentStringSet(cache.getInfDb(), DvcsSchema.E_PRIORITY_CHANGESET_UPDATED);
        this.createChangeParser();
        this.createDiffParser();
    }

    @Override
    public String updateRevisions(String start, String end) throws RepositoryClientException, DbException {
        throw new UnsupportedOperationException("Git Repositories do not support rescanning presently");
    }

    protected GitChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    protected void slurpRepository(boolean priorUpdateOccurred) throws DbException, ConfigException, IOException, RepositoryClientException {
        long timeLimit = System.currentTimeMillis() + this.getEngine().getEffectivePollPeriod();
        if (FishEyeSysProps.forceManifestUpgrade && !((GitCache)this.cache).hasScanProperty(CommonProperties.GIT_MANIFEST_UPGRADE.value)) {
            this.doManifestUpgrade(0L);
        }
        if (((GitCache)this.cache).getScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, 0L) > 0L) {
            priorUpdateOccurred = true;
            log.debug((Object)String.format("%d changesets to reindex left from previous slurp", ((GitCache)this.cache).getScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, 0L)));
        }
        if (!((GitCache)this.cache).hasScanProperty(CommonProperties.GIT_TAGS_TO_PROCESS.value)) {
            ((GitCache)this.cache).setScanProperty(CommonProperties.GIT_TAGS_TO_PROCESS.value, 0L);
            priorUpdateOccurred = true;
        }
        if (((GitCache)this.cache).getScanProperty(CommonProperties.GIT_TAGS_TO_PROCESS.value, 0L) > 0L) {
            priorUpdateOccurred = true;
            log.info((Object)String.format("%d tags to process left from previous slurp", ((GitCache)this.cache).getScanProperty(CommonProperties.GIT_TAGS_TO_PROCESS.value, 0L)));
        }
        super.slurpRepository(priorUpdateOccurred);
        if (!((GitCache)this.cache).hasScanProperty(CommonProperties.GIT_MANIFEST_UPGRADE.value)) {
            this.doManifestUpgrade(timeLimit);
        }
    }

    private void doManifestUpgrade(long timeLimit) throws RepositoryClientException {
        if (this.upgrader == null) {
            this.upgrader = new ManifestUpgrader(this.getRepoName(), (GitCache)this.cache, this.status, this.getChangesetIndexer(), this.getPathCrossRepoIndexer(), this.getPathMatcher(), this.manifestProcessor, this.renameOption, this.context);
        }
        try {
            this.upgrader.doUpgrade(timeLimit);
            if (((GitCache)this.cache).hasScanProperty(CommonProperties.GIT_MANIFEST_UPGRADE.value)) {
                this.upgrader = null;
            }
        }
        catch (DvcsProcessException e2) {
            throw new RepositoryClientException(e2);
        }
    }

    @Override
    protected void updateBranchManifest(Branch from, Branch to) throws DvcsProcessException {
        if (from == null || from.getLatestChangeSetId() == null) {
            ((GitCache)this.cache).rebuildHeadsOnBranch(to);
        } else if (this.manifestProcessor.exists(to.getLatestChangeSetId())) {
            super.updateBranchManifest(from, to);
        } else {
            this.oldBranchManifestUpdate(to);
        }
    }

    private void oldBranchManifestUpdate(Branch to) throws DvcsProcessException {
        Map<Path, String> newHeadManifest = this.getContext().getManifestContentHashesForChangeset(to.getLatestChangeSetId());
        try {
            CommonRevInfoDAO commonDAO = this.fileRevDAO.getCommonRevInfoDAO();
            for (GitRevInfo gitRevInfo : this.fileRevDAO.getRevisionsAtBranchHead(to.getName())) {
                Path path = gitRevInfo.getPath();
                String newHeadContentHash = newHeadManifest.get(path);
                if (newHeadContentHash != null) {
                    if (!newHeadContentHash.equals(gitRevInfo.getDestHash())) {
                        commonDAO.deleteBranchHeadInfo(gitRevInfo.getRevID(), to.getName());
                        GitRevInfo headRevInfo = ((GitCache)this.getCache()).getFileRevisionAtManifest(path, newHeadContentHash, to.getLatestChangeSetId(), true);
                        if (headRevInfo != null) {
                            commonDAO.updateBranchHead(headRevInfo.getRevID(), null, null, to.getName());
                        } else {
                            log.warn((Object)("Could not resolve contenthash " + newHeadContentHash + " for " + path + " at commit " + to.getLatestChangeSetId()));
                        }
                    }
                    newHeadManifest.remove(path);
                    continue;
                }
                if (gitRevInfo.isDead()) continue;
                this.fileRevDAO.getCommonRevInfoDAO().deleteBranchHeadInfo(gitRevInfo.getRevID(), to.getName());
            }
            for (Map.Entry entry : newHeadManifest.entrySet()) {
                GitRevInfo headRevInfo = ((GitCache)this.getCache()).getFileRevisionAtManifest((Path)entry.getKey(), (String)entry.getValue(), to.getLatestChangeSetId(), true);
                if (headRevInfo == null) continue;
                commonDAO.updateBranchHead(headRevInfo.getRevID(), null, null, to.getName());
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private class ChangesetsOnBranchCollector
    implements StoppableVisitor<String> {
        private final ImmutableListMultimap.Builder<String, String> csIdsToModifiedBranchNames;
        private final String branchName;
        private final boolean queueEagerReindexing;
        int count = 0;

        public ChangesetsOnBranchCollector(ImmutableListMultimap.Builder<String, String> csIdsToModifiedBranchNames, String branchName, boolean queueEagerReindexing) {
            this.csIdsToModifiedBranchNames = csIdsToModifiedBranchNames;
            this.branchName = branchName;
            this.queueEagerReindexing = queueEagerReindexing;
        }

        @Override
        public boolean visit(String csid) {
            if (this.count++ < 100 && this.queueEagerReindexing) {
                GitScanner.this.commitsToReindexNow.add(csid);
            }
            this.csIdsToModifiedBranchNames.put((Object)csid, (Object)this.branchName);
            return true;
        }
    }

    private class DiffInfoContext {
        public static final int NO_PARENT_REVISION = -1;
        private LinkedHashMap<GitDiffInfo, Optional<Integer>> resolvedParents = new LinkedHashMap();
        public GitDiffInfo diffParentDiffInfo;
        public Optional<Integer> diffParentRevId;
        private AncestorLink ancestorLink;
        private int ancestorLineCount;

        private DiffInfoContext(Collection<GitDiffInfo> diffInfos, GitChangePath changePath) throws DbException {
            this.resolveParents(diffInfos);
            if (this.resolvedParents.isEmpty()) {
                if (changePath.getSrcPath() != null && !GitScanner.this.getContext().isPathInRepo(changePath.getSrcPath()) && !((Object)((Object)GitScanner.this.context.getScmConfig().getRenameMode())).equals((Object)RenameOptions.NONE)) {
                    this.diffParentDiffInfo = new GitDiffInfo(null, changePath.getPath());
                    this.diffParentDiffInfo.setToContentHash(changePath.getDestHash());
                } else {
                    this.diffParentDiffInfo = diffInfos.iterator().next();
                }
                this.diffParentRevId = Optional.absent();
            } else {
                this.diffParentDiffInfo = diffInfos.stream().filter(diffInfo -> this.resolvedParents.containsKey(diffInfo)).filter(diffInfo -> Objects.equal((Object)diffInfo.getParentChangesetId(), (Object)changePath.getParentCsId())).findFirst().orElse(this.resolvedParents.keySet().iterator().next());
                this.diffParentRevId = this.resolvedParents.get(this.diffParentDiffInfo);
                List<Integer> ancestorIds = this.resolvedParents.values().stream().filter(id -> id.isPresent()).map(id -> (Integer)id.get()).collect(Collectors.toList());
                if (!ancestorIds.isEmpty()) {
                    this.ancestorLink = new AncestorLink(AncestorLink.Type.DIRECT, ancestorIds);
                }
                if (this.diffParentRevId.isPresent()) {
                    this.ancestorLineCount = GitScanner.this.fileRevDAO.getLineCount((Integer)this.diffParentRevId.get());
                }
            }
        }

        private void resolveParents(Collection<GitDiffInfo> diffInfos) throws DbException {
            for (GitDiffInfo diffInfo : diffInfos) {
                String parentContentHash = diffInfo.getFromContentHash();
                Path parentPath = GitScanner.this.getContext().getLocalPath(diffInfo.getFromPath());
                boolean pathInRepo = GitScanner.this.getContext().isPathInRepo(parentPath);
                if (!pathInRepo) continue;
                String diffInfoParentChangesetId = diffInfo.getParentChangesetId();
                if (diffInfoParentChangesetId == null) {
                    log.debug((Object)("Diff Information is missing parent changeset id for " + diffInfo.getFromPath()));
                    continue;
                }
                Set<String> existingParentCsIds = GitScanner.this.csDAO.resolveParent(diffInfoParentChangesetId);
                if (existingParentCsIds.isEmpty()) {
                    log.warn((Object)("Diff Information is missing parent changeset id for " + diffInfo.getFromPath() + ". Could not resolve parent changeset " + diffInfo.getParentChangesetId()));
                    continue;
                }
                if ("0000000000000000000000000000000000000000".equals(parentContentHash)) {
                    this.resolvedParents.put(diffInfo, (Optional<Integer>)Optional.absent());
                    continue;
                }
                for (String parentChangesetId : existingParentCsIds) {
                    GitRevInfo parentRev = ((GitCache)GitScanner.this.getCache()).getFileRevisionAtManifest(parentPath, parentChangesetId);
                    if (parentRev != null) {
                        this.resolvedParents.put(diffInfo, (Optional<Integer>)Optional.of((Object)parentRev.getRevID()));
                        continue;
                    }
                    String msg = "Could not find parent file revision in fisheye index: path " + parentPath + " at commit " + parentChangesetId;
                    if (parentContentHash != null) {
                        msg = msg + " (content hash " + parentContentHash + ")";
                    }
                    msg = msg + ". Out of order scanning going on?";
                    log.warn((Object)msg);
                }
            }
        }
    }
}

